/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.common.initializedfields.qual.InitializedFields;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.EnsuresQualifierIf;

public final class RegexUtil {
    private RegexUtil() {
        throw new Error("do not instantiate");
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean isRegex(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s) {
        return RegexUtil.isRegex(s, 0);
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean isRegex(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int groups) {
        Pattern p;
        try {
            p = Pattern.compile(s);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return RegexUtil.getGroupCount(p) >= groups;
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean isRegex(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) char c) {
        return RegexUtil.isRegex(Character.toString(c));
    }

    @SideEffectFree
    public static @Regex @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @SignatureUnknown @UnknownThis @InitializedFields(value={}) String asRegex(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s) {
        return RegexUtil.asRegex(s, 0);
    }

    @SideEffectFree
    public static @Regex @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @SignatureUnknown @UnknownThis @InitializedFields(value={}) String asRegex(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int groups) {
        try {
            Pattern p = Pattern.compile(s);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                throw new Error(RegexUtil.regexErrorMessage(s, groups, actualGroups));
            }
            return s;
        }
        catch (PatternSyntaxException e) {
            throw new Error(e);
        }
    }

    @SideEffectFree
    public static @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String regexError(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s) {
        return RegexUtil.regexError(s, 0);
    }

    @SideEffectFree
    public static @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String regexError(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int groups) {
        try {
            Pattern p = Pattern.compile(s);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                return RegexUtil.regexErrorMessage(s, groups, actualGroups);
            }
        }
        catch (PatternSyntaxException e) {
            return e.getMessage();
        }
        return null;
    }

    @SideEffectFree
    public static @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) PatternSyntaxException regexException(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s) {
        return RegexUtil.regexException(s, 0);
    }

    @SideEffectFree
    public static @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) PatternSyntaxException regexException(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int groups) {
        try {
            Pattern p = Pattern.compile(s);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                return new PatternSyntaxException(RegexUtil.regexErrorMessage(s, groups, actualGroups), s, -1);
            }
        }
        catch (PatternSyntaxException pse) {
            return pse;
        }
        return null;
    }

    @SideEffectFree
    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String regexErrorMessage(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int expectedGroups, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int actualGroups) {
        return "regex \"" + s + "\" has " + actualGroups + " groups, but " + expectedGroups + " groups are needed.";
    }

    @Pure
    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int getGroupCount(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Pattern p) {
        return p.matcher("").groupCount();
    }

    public static class CheckedPatternSyntaxException
    extends Exception {
        private static final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) long serialVersionUID = 6266881831979001480L;
        private final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) PatternSyntaxException pse;

        public CheckedPatternSyntaxException(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) PatternSyntaxException pse) {
            this.pse = pse;
        }

        public CheckedPatternSyntaxException(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String desc, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String regex, @GTENegativeOne @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int index) {
            this(new PatternSyntaxException(desc, regex, index));
        }

        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String getDescription() {
            return this.pse.getDescription();
        }

        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int getIndex() {
            return this.pse.getIndex();
        }

        @Override
        @Pure
        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String getMessage(@GuardSatisfied CheckedPatternSyntaxException this) {
            return this.pse.getMessage();
        }

        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String getPattern() {
            return this.pse.getPattern();
        }
    }
}

