/*
 * Decompiled with CFR 0.152.
 */
package org.pmml4s.common;

import org.pmml4s.common.FactorPredictor;
import org.pmml4s.common.Matrix;
import org.pmml4s.data.Series;
import org.pmml4s.metadata.Field;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public class ContrastMatrixFactorPredictor
extends FactorPredictor {
    private final Field field;
    private final Object value;
    private final Map categories;
    private final Matrix matrix;
    private final int colIdx;

    public ContrastMatrixFactorPredictor(Field field, Object value, Map<Object, Object> categories, Matrix matrix) {
        this.field = field;
        this.value = value;
        this.categories = categories;
        this.matrix = matrix;
        super(field, value);
        this.colIdx = BoxesRunTime.unboxToInt((Object)categories.apply(value));
    }

    @Override
    public Field field() {
        return this.field;
    }

    @Override
    public Object value() {
        return this.value;
    }

    public Map<Object, Object> categories() {
        return this.categories;
    }

    public Matrix matrix() {
        return this.matrix;
    }

    @Override
    public double eval(Series series) {
        double d;
        if (this.field().isMissing(series)) {
            d = 0.0;
        } else {
            int rowIdx = BoxesRunTime.unboxToInt((Object)this.categories().apply(this.field().get(series)));
            d = this.matrix().apply(rowIdx, this.colIdx);
        }
        return d;
    }
}

