/*
 * Decompiled with CFR 0.152.
 */
package org.pmml4s.common;

import org.pmml4s.common.HasExtensions;
import org.pmml4s.common.RegressionEvaluator;
import org.pmml4s.common.RegressionPredictor;
import org.pmml4s.data.Series;
import org.pmml4s.metadata.Field;

public class CovariatePredictor
implements HasExtensions,
RegressionEvaluator,
RegressionPredictor {
    private final Field field;
    private final double multiplicity;

    public CovariatePredictor(Field field, double multiplicity) {
        this.field = field;
        this.multiplicity = multiplicity;
    }

    public Field field() {
        return this.field;
    }

    public double multiplicity() {
        return this.multiplicity;
    }

    @Override
    public double eval(Series series) {
        double d;
        if (this.field().isMissing(series)) {
            d = Double.NaN;
        } else {
            double value = this.field().getDouble(series);
            d = this.multiplicity() == 1.0 ? value : Math.pow(value, this.multiplicity());
        }
        return d;
    }
}

