/*
 * Decompiled with CFR 0.152.
 */
package org.pmml4s.common;

import org.pmml4s.common.ContinuousDistribution;
import org.pmml4s.common.ContinuousDistributionType$;
import org.pmml4s.common.HasExtensions;
import scala.Enumeration;

public class GaussianDistribution
implements HasExtensions,
ContinuousDistribution {
    private final double mean;
    private final double variance;
    private final double beta;

    public GaussianDistribution(double mean, double variance) {
        this.mean = mean;
        this.variance = variance;
        this.beta = Math.sqrt(Math.PI * 2 * variance);
    }

    public double mean() {
        return this.mean;
    }

    public double variance() {
        return this.variance;
    }

    @Override
    public double probability(double x) {
        double a = x - this.mean();
        return Math.exp(-0.5 * (a * a) / this.variance()) / this.beta;
    }

    @Override
    public Enumeration.Value distType() {
        return ContinuousDistributionType$.MODULE$.GAUSSIAN();
    }
}

