/*
 * Decompiled with CFR 0.152.
 */
package org.pmml4s.data;

import org.pmml4s.common.StructField;
import org.pmml4s.common.StructType;
import org.pmml4s.common.StructType$;
import org.pmml4s.data.Series;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public class JoinedSeries
implements Series {
    private final Series series1;
    private final Series series2;
    private final StructType schema;
    private final int length;

    public JoinedSeries(Series series1, Series series2) {
        StructType structType;
        this.series1 = series1;
        this.series2 = series2;
        if (series1.schema() != null && series2.schema() != null) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])series1.schema().fields());
            structType = StructType$.MODULE$.apply((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)series2.schema().fields(), ClassTag$.MODULE$.apply(StructField.class)));
        } else {
            structType = null;
        }
        this.schema = structType;
        this.length = series1.length() + series2.length();
    }

    public Series series1() {
        return this.series1;
    }

    public Series series2() {
        return this.series2;
    }

    public JoinedSeries withLeft(Series left) {
        return new JoinedSeries(left, this.series2());
    }

    public JoinedSeries withRight(Series right) {
        return new JoinedSeries(this.series1(), right);
    }

    @Override
    public Seq<Object> toSeq() {
        return (Seq)this.series1().toSeq().$plus$plus(this.series2().toSeq());
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int fieldIndex(String name) {
        return this.schema() != null ? BoxesRunTime.unboxToInt((Object)this.schema().getFieldIndex(name).getOrElse(JoinedSeries::fieldIndex$$anonfun$1)) : -1;
    }

    @Override
    public Object get(int i) {
        return i < this.series1().length() ? this.series1().get(i) : this.series2().get(i - this.series1().length());
    }

    @Override
    public boolean anyNull() {
        return this.series1().anyNull() || this.series2().anyNull();
    }

    @Override
    public boolean anyMissing() {
        return this.series1().anyMissing() || this.series2().anyMissing();
    }

    @Override
    public Series copy() {
        Series copy1 = this.series1().copy();
        Series copy2 = this.series2().copy();
        return new JoinedSeries(copy1, copy2);
    }

    @Override
    public String toString() {
        return this.series1() == null && this.series2() == null ? "[ empty series ]" : (this.series1() == null ? this.series2().toString() : (this.series2() == null ? this.series1().toString() : new StringBuilder(5).append("{").append(this.series1().toString()).append(" + ").append(this.series2().toString()).append("}").toString()));
    }

    private static final int fieldIndex$$anonfun$1() {
        return -1;
    }
}

