/*
 * Decompiled with CFR 0.152.
 */
package org.pmml4s.model;

import java.io.Serializable;
import org.pmml4s.common.DataType$;
import org.pmml4s.common.Extension;
import org.pmml4s.common.ModelExplanation;
import org.pmml4s.common.ModelStats;
import org.pmml4s.common.ModelVerification;
import org.pmml4s.common.OpType$continuous$;
import org.pmml4s.data.Series;
import org.pmml4s.metadata.MiningSchema;
import org.pmml4s.metadata.Output;
import org.pmml4s.metadata.OutputField;
import org.pmml4s.metadata.OutputField$;
import org.pmml4s.metadata.ResultFeature$;
import org.pmml4s.metadata.Targets;
import org.pmml4s.model.AlgorithmType$;
import org.pmml4s.model.AnomalyDetectionAttributes;
import org.pmml4s.model.AnomalyDetectionModel$;
import org.pmml4s.model.AnomalyDetectionOutput;
import org.pmml4s.model.Cluster;
import org.pmml4s.model.ClusteringModel;
import org.pmml4s.model.HasWrappedAnomalyDetectionAttributes;
import org.pmml4s.model.MeanClusterDistances;
import org.pmml4s.model.Model;
import org.pmml4s.model.ModelElement;
import org.pmml4s.model.ModelElement$AnomalyDetectionModel$;
import org.pmml4s.transformations.LocalTransformations;
import org.pmml4s.util.Utils$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public class AnomalyDetectionModel
extends Model
implements HasWrappedAnomalyDetectionAttributes {
    private Model parent;
    private final AnomalyDetectionAttributes attributes;
    private final MiningSchema miningSchema;
    private final Model model;
    private final Option meanClusterDistances;
    private final Option output;
    private final Option localTransformations;
    private final Option modelVerification;
    private final Seq extensions;
    private final int predictedIndex;
    private final int affinityIndex;

    public static Option<MeanClusterDistances> $lessinit$greater$default$5() {
        return AnomalyDetectionModel$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Output> $lessinit$greater$default$6() {
        return AnomalyDetectionModel$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<LocalTransformations> $lessinit$greater$default$7() {
        return AnomalyDetectionModel$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<ModelVerification> $lessinit$greater$default$8() {
        return AnomalyDetectionModel$.MODULE$.$lessinit$greater$default$8();
    }

    public static Seq<Extension> $lessinit$greater$default$9() {
        return AnomalyDetectionModel$.MODULE$.$lessinit$greater$default$9();
    }

    public AnomalyDetectionModel(Model parent, AnomalyDetectionAttributes attributes, MiningSchema miningSchema, Model model, Option<MeanClusterDistances> meanClusterDistances, Option<Output> output, Option<LocalTransformations> localTransformations, Option<ModelVerification> modelVerification, Seq<Extension> extensions) {
        Tuple2 tuple2;
        this.parent = parent;
        this.attributes = attributes;
        this.miningSchema = miningSchema;
        this.model = model;
        this.meanClusterDistances = meanClusterDistances;
        this.output = output;
        this.localTransformations = localTransformations;
        this.modelVerification = modelVerification;
        this.extensions = extensions;
        Enumeration.Value value = this.algorithmType();
        Enumeration.Value value2 = AlgorithmType$.MODULE$.iforest();
        Predef$.MODULE$.require((value != null ? !value.equals(value2) : value2 != null) || this.sampleDataSize().isDefined(), AnomalyDetectionModel::$init$$$anonfun$1);
        Enumeration.Value value3 = this.algorithmType();
        Enumeration.Value value4 = AlgorithmType$.MODULE$.clusterMeanDist();
        Predef$.MODULE$.require((value3 != null ? !value3.equals(value4) : value4 != null) || meanClusterDistances.isDefined(), AnomalyDetectionModel::$init$$$anonfun$2);
        Enumeration.Value value5 = this.algorithmType();
        Enumeration.Value value6 = AlgorithmType$.MODULE$.clusterMeanDist();
        if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
            int affinityIndex;
            int predictedIndex = model.outputIndex(ResultFeature$.MODULE$.predictedValue(), model.outputIndex$default$2());
            if (predictedIndex == -1) {
                predictedIndex = model.outputIndex(ResultFeature$.MODULE$.clusterId(), model.outputIndex$default$2());
            }
            if (predictedIndex == -1) {
                predictedIndex = model.outputIndex(ResultFeature$.MODULE$.entityId(), model.outputIndex$default$2());
            }
            if ((affinityIndex = model.outputIndex(ResultFeature$.MODULE$.affinity(), model.outputIndex$default$2())) == -1) {
                affinityIndex = model.outputIndex(ResultFeature$.MODULE$.clusterAffinity(), model.outputIndex$default$2());
            }
            if (affinityIndex == -1) {
                affinityIndex = model.outputIndex(ResultFeature$.MODULE$.entityAffinity(), model.outputIndex$default$2());
            }
            tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)predictedIndex), (Object)BoxesRunTime.boxToInteger((int)affinityIndex));
        } else {
            tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)model.outputIndex(ResultFeature$.MODULE$.predictedValue(), model.outputIndex$default$2())), (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        Tuple2 tuple22 = tuple2;
        this.predictedIndex = BoxesRunTime.unboxToInt((Object)tuple22._1());
        this.affinityIndex = BoxesRunTime.unboxToInt((Object)tuple22._2());
    }

    @Override
    public Model parent() {
        return this.parent;
    }

    @Override
    public void parent_$eq(Model x$1) {
        this.parent = x$1;
    }

    @Override
    public AnomalyDetectionAttributes attributes() {
        return this.attributes;
    }

    @Override
    public MiningSchema miningSchema() {
        return this.miningSchema;
    }

    public Model model() {
        return this.model;
    }

    public Option<MeanClusterDistances> meanClusterDistances() {
        return this.meanClusterDistances;
    }

    @Override
    public Option<Output> output() {
        return this.output;
    }

    @Override
    public Option<LocalTransformations> localTransformations() {
        return this.localTransformations;
    }

    @Override
    public Option<ModelVerification> modelVerification() {
        return this.modelVerification;
    }

    @Override
    public Seq<Extension> extensions() {
        return this.extensions;
    }

    public int predictedIndex() {
        return this.predictedIndex;
    }

    public int affinityIndex() {
        return this.affinityIndex;
    }

    @Override
    public ModelElement modelElement() {
        return ModelElement$AnomalyDetectionModel$.MODULE$;
    }

    @Override
    public Series predict(Series values) {
        Tuple2<Series, Object> tuple2 = this.prepare(values);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Series series = (Series)tuple2._1();
        boolean returnInvalid = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)series, (Object)BoxesRunTime.boxToBoolean((boolean)returnInvalid));
        Series series2 = (Series)tuple22._1();
        boolean returnInvalid2 = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
        if (returnInvalid2) {
            return this.nullSeries();
        }
        AnomalyDetectionOutput outputs = this.createOutputs();
        Series outSeries = this.model().predict(series2);
        Object predictedValue = outSeries.get(this.predictedIndex());
        if (!Utils$.MODULE$.isMissing(predictedValue)) {
            Object object;
            Enumeration.Value value = this.algorithmType();
            Enumeration.Value value2 = AlgorithmType$.MODULE$.iforest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                long n = BoxesRunTime.unboxToLong((Object)this.sampleDataSize().get());
                double cn = 2.0 * (Math.log((double)n - 1.0) + 0.57721566) - 2.0 * ((double)n - 1.0) / (double)n;
                double b = -(Utils$.MODULE$.toDouble(predictedValue) / cn);
                object = BoxesRunTime.boxToDouble((double)Math.pow(2.0, b));
            } else {
                Enumeration.Value value4 = AlgorithmType$.MODULE$.ocsvm();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    object = predictedValue;
                } else {
                    Enumeration.Value value6 = AlgorithmType$.MODULE$.clusterMeanDist();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        ClusteringModel clusteringModel = (ClusteringModel)this.model();
                        String winner = Utils$.MODULE$.toString(predictedValue);
                        Object object2 = Predef$.MODULE$.refArrayOps((Object[])clusteringModel.clusters());
                        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object2));
                        int winnerIdx = BoxesRunTime.unboxToInt((Object)((Tuple2)ArrayOps$.MODULE$.find$extension(object3, (Function1 & Serializable)x -> {
                            boolean bl;
                            if (((Cluster)x._1()).id().isDefined()) {
                                Object object = ((Cluster)x._1()).id().get();
                                String string = winner;
                                bl = !(object != null ? !object.equals(string) : string != null);
                            } else {
                                String string = BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)x._2()) + 1)).toString();
                                String string2 = winner;
                                bl = !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            return bl;
                        }).get())._2());
                        double affinity = Utils$.MODULE$.toDouble(outSeries.get(this.affinityIndex()));
                        object = BoxesRunTime.boxToDouble((double)(affinity / ((MeanClusterDistances)this.meanClusterDistances().get()).array()[winnerIdx]));
                    } else {
                        Enumeration.Value value8 = AlgorithmType$.MODULE$.other();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            throw Predef$.MODULE$.$qmark$qmark$qmark();
                        }
                        throw new MatchError((Object)value);
                    }
                }
            }
            outputs.predictedValue_$eq(object);
        }
        return this.result(series2, outputs, this.result$default$3());
    }

    @Override
    public OutputField[] defaultOutputFields() {
        return new OutputField[]{OutputField$.MODULE$.predictedValue("anomalyScore", "Anomaly score of detection model", DataType$.MODULE$.double(), OpType$continuous$.MODULE$)};
    }

    @Override
    public AnomalyDetectionOutput createOutputs() {
        return new AnomalyDetectionOutput();
    }

    @Override
    public Option<Targets> targets() {
        return None$.MODULE$;
    }

    @Override
    public Option<ModelStats> modelStats() {
        return None$.MODULE$;
    }

    @Override
    public Option<ModelExplanation> modelExplanation() {
        return None$.MODULE$;
    }

    private static final String $init$$$anonfun$1() {
        return "sampleDataSize is a required parameter for isolation forest models.";
    }

    private static final String $init$$$anonfun$2() {
        return "MeanClusterDistances is required when the algorithm type is clusterMeanDist.";
    }
}

