/*
 * Decompiled with CFR 0.152.
 */
package org.pmml4s.model;

import java.io.Serializable;
import org.pmml4s.common.ContinuousDistribution;
import org.pmml4s.common.HasExtensions;
import org.pmml4s.common.PmmlElement;
import org.pmml4s.data.Series;
import org.pmml4s.metadata.Field;
import org.pmml4s.model.BayesInput$;
import org.pmml4s.model.PairCounts;
import org.pmml4s.model.TargetValueStats;
import org.pmml4s.transformations.DerivedField;
import org.pmml4s.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class BayesInput
implements HasExtensions,
PmmlElement {
    private final Field fieldName;
    private final Option targetValueStats;
    private final PairCounts[] pairCounts;
    private final Option derivedField;
    private ContinuousDistribution[] distributions;
    private double[][] probabilities;

    public static Option<DerivedField> $lessinit$greater$default$4() {
        return BayesInput$.MODULE$.$lessinit$greater$default$4();
    }

    public BayesInput(Field fieldName, Option<TargetValueStats> targetValueStats, PairCounts[] pairCounts, Option<DerivedField> derivedField) {
        this.fieldName = fieldName;
        this.targetValueStats = targetValueStats;
        this.pairCounts = pairCounts;
        this.derivedField = derivedField;
        this.distributions = null;
        this.probabilities = null;
    }

    public Field fieldName() {
        return this.fieldName;
    }

    public Option<TargetValueStats> targetValueStats() {
        return this.targetValueStats;
    }

    public PairCounts[] pairCounts() {
        return this.pairCounts;
    }

    public Option<DerivedField> derivedField() {
        return this.derivedField;
    }

    public void init(Field target, double threshold) {
        Object[] classes = target.validValues();
        int l = classes.length;
        if (this.targetValueStats().isDefined()) {
            this.distributions = new ContinuousDistribution[l];
            for (int i = 0; i < l; ++i) {
                this.distributions[i] = (ContinuousDistribution)((TargetValueStats)this.targetValueStats().get()).getDist(classes[i]).get();
            }
        } else {
            Field f = (Field)this.derivedField().getOrElse(this::$anonfun$3);
            int n = BoxesRunTime.unboxToInt((Object)this.derivedField().map((Function1 & Serializable)_$3 -> _$3.numCategories()).getOrElse(this::$anonfun$5));
            double[] counts = new double[l];
            this.probabilities = new double[n][l];
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.pairCounts());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)pair -> {
                double i = f.encode(pair.value());
                Object object = Predef$.MODULE$.refArrayOps((Object[])pair.targetValueCounts().targetValueCounts());
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)c -> {
                    double j = target.encode(c.value());
                    this.probabilities[(int)i$4][(int)j] = c.count();
                    int n = (int)j;
                    counts$2[n] = counts[n] + c.count();
                });
            });
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < l; ++j) {
                    if (this.probabilities[i][j] > 0.0) {
                        double[] dArray = this.probabilities[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] / counts[j];
                        continue;
                    }
                    this.probabilities[i][j] = threshold;
                }
            }
        }
    }

    public double[] eval(Series series, double threshold) {
        double[] dArray;
        if (this.fieldName().isMissing(series)) {
            dArray = Array$.MODULE$.emptyDoubleArray();
        } else if (this.distributions != null) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.distributions);
            dArray = (double[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x -> Math.max(threshold, x.probability(Utils$.MODULE$.toDouble(this.fieldName().get(series)))), ClassTag$.MODULE$.apply(Double.TYPE));
        } else {
            double v = BoxesRunTime.unboxToDouble((Object)this.derivedField().map((Function1 & Serializable)x -> x.encode(x.eval(series))).getOrElse(() -> this.$anonfun$7(series)));
            dArray = this.probabilities[(int)v];
        }
        return dArray;
    }

    private final Field $anonfun$3() {
        return this.fieldName();
    }

    private final int $anonfun$5() {
        return this.fieldName().numCategories();
    }

    private final double $anonfun$7(Series series$4) {
        return this.fieldName().encode(series$4);
    }
}

