/*
 * Decompiled with CFR 0.152.
 */
package org.pmml4s.model;

import java.io.Serializable;
import org.pmml4s.common.ComparisonMeasure;
import org.pmml4s.common.ComparisonMeasureKind$;
import org.pmml4s.common.Distance;
import org.pmml4s.common.Extension;
import org.pmml4s.common.ModelExplanation;
import org.pmml4s.common.ModelStats;
import org.pmml4s.common.ModelVerification;
import org.pmml4s.common.MutableAffinities;
import org.pmml4s.common.MutableEntityId;
import org.pmml4s.common.OpType$nominal$;
import org.pmml4s.common.StringType$;
import org.pmml4s.data.Series;
import org.pmml4s.metadata.MiningSchema;
import org.pmml4s.metadata.Output;
import org.pmml4s.metadata.OutputField;
import org.pmml4s.metadata.OutputField$;
import org.pmml4s.metadata.Targets;
import org.pmml4s.model.Cluster;
import org.pmml4s.model.ClusteringAttributes;
import org.pmml4s.model.ClusteringField;
import org.pmml4s.model.ClusteringModel$;
import org.pmml4s.model.ClusteringOutputs;
import org.pmml4s.model.HasWrappedClusteringAttributes;
import org.pmml4s.model.MissingValueWeights;
import org.pmml4s.model.Model;
import org.pmml4s.model.ModelClass$;
import org.pmml4s.model.ModelElement;
import org.pmml4s.model.ModelElement$ClusteringModel$;
import org.pmml4s.transformations.LocalTransformations;
import org.pmml4s.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public class ClusteringModel
extends Model
implements HasWrappedClusteringAttributes {
    private Model parent;
    private final ClusteringAttributes attributes;
    private final MiningSchema miningSchema;
    private final ComparisonMeasure comparisonMeasure;
    private final ClusteringField[] clusteringFields;
    private final Option missingValueWeights;
    private final Cluster[] clusters;
    private final Option output;
    private final Option targets;
    private final Option localTransformations;
    private final Option modelStats;
    private final Option modelExplanation;
    private final Option modelVerification;
    private final Seq extensions;
    private final double[] weights;
    private final Enumeration.Value[] compareFunctions;
    private final double[] similarityScales;
    private final double[] Qi;
    private final double sumQi;
    private final Distance dis;

    public static Option<Output> $lessinit$greater$default$8() {
        return ClusteringModel$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Targets> $lessinit$greater$default$9() {
        return ClusteringModel$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<LocalTransformations> $lessinit$greater$default$10() {
        return ClusteringModel$.MODULE$.$lessinit$greater$default$10();
    }

    public static Option<ModelStats> $lessinit$greater$default$11() {
        return ClusteringModel$.MODULE$.$lessinit$greater$default$11();
    }

    public static Option<ModelExplanation> $lessinit$greater$default$12() {
        return ClusteringModel$.MODULE$.$lessinit$greater$default$12();
    }

    public static Option<ModelVerification> $lessinit$greater$default$13() {
        return ClusteringModel$.MODULE$.$lessinit$greater$default$13();
    }

    public static Seq<Extension> $lessinit$greater$default$14() {
        return ClusteringModel$.MODULE$.$lessinit$greater$default$14();
    }

    public ClusteringModel(Model parent, ClusteringAttributes attributes, MiningSchema miningSchema, ComparisonMeasure comparisonMeasure, ClusteringField[] clusteringFields, Option<MissingValueWeights> missingValueWeights, Cluster[] clusters, Option<Output> output, Option<Targets> targets, Option<LocalTransformations> localTransformations, Option<ModelStats> modelStats, Option<ModelExplanation> modelExplanation, Option<ModelVerification> modelVerification, Seq<Extension> extensions) {
        this.parent = parent;
        this.attributes = attributes;
        this.miningSchema = miningSchema;
        this.comparisonMeasure = comparisonMeasure;
        this.clusteringFields = clusteringFields;
        this.missingValueWeights = missingValueWeights;
        this.clusters = clusters;
        this.output = output;
        this.targets = targets;
        this.localTransformations = localTransformations;
        this.modelStats = modelStats;
        this.modelExplanation = modelExplanation;
        this.modelVerification = modelVerification;
        this.extensions = extensions;
        Object object = Predef$.MODULE$.refArrayOps((Object[])clusteringFields);
        this.weights = (double[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.fieldWeight(), ClassTag$.MODULE$.apply(Double.TYPE));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])clusteringFields);
        this.compareFunctions = (Enumeration.Value[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$2 -> (Enumeration.Value)_$2.compareFunction().getOrElse(() -> ClusteringModel.$init$$$anonfun$2$$anonfun$1(comparisonMeasure)), ClassTag$.MODULE$.apply(Enumeration.Value.class));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])clusteringFields);
        this.similarityScales = (double[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$3 -> BoxesRunTime.unboxToDouble((Object)_$3.similarityScale().getOrElse(ClusteringModel::$init$$$anonfun$3$$anonfun$1)), ClassTag$.MODULE$.apply(Double.TYPE));
        this.Qi = (double[])missingValueWeights.map((Function1 & Serializable)_$4 -> _$4.array()).getOrElse(() -> ClusteringModel.$init$$$anonfun$5(clusteringFields));
        this.sumQi = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(this.Qi).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        this.dis = comparisonMeasure.distance();
    }

    @Override
    public Model parent() {
        return this.parent;
    }

    @Override
    public void parent_$eq(Model x$1) {
        this.parent = x$1;
    }

    @Override
    public ClusteringAttributes attributes() {
        return this.attributes;
    }

    @Override
    public MiningSchema miningSchema() {
        return this.miningSchema;
    }

    public ComparisonMeasure comparisonMeasure() {
        return this.comparisonMeasure;
    }

    public ClusteringField[] clusteringFields() {
        return this.clusteringFields;
    }

    public Option<MissingValueWeights> missingValueWeights() {
        return this.missingValueWeights;
    }

    public Cluster[] clusters() {
        return this.clusters;
    }

    @Override
    public Option<Output> output() {
        return this.output;
    }

    @Override
    public Option<Targets> targets() {
        return this.targets;
    }

    @Override
    public Option<LocalTransformations> localTransformations() {
        return this.localTransformations;
    }

    @Override
    public Option<ModelStats> modelStats() {
        return this.modelStats;
    }

    @Override
    public Option<ModelExplanation> modelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public Option<ModelVerification> modelVerification() {
        return this.modelVerification;
    }

    @Override
    public Seq<Extension> extensions() {
        return this.extensions;
    }

    @Override
    public ModelElement modelElement() {
        return ModelElement$ClusteringModel$.MODULE$;
    }

    @Override
    public Series predict(Series values) {
        Tuple3 tuple3;
        Tuple2<Series, Object> tuple2 = this.prepare(values);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Series series = (Series)tuple2._1();
        boolean returnInvalid = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)series, (Object)BoxesRunTime.boxToBoolean((boolean)returnInvalid));
        Series series2 = (Series)tuple22._1();
        boolean returnInvalid2 = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
        if (returnInvalid2) {
            return this.nullSeries();
        }
        double nonMissing = 0.0;
        ArrayBuilder nonMissingIdxBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
        nonMissingIdxBuilder.sizeHint(this.clusteringFields().length);
        double[] xs = new double[this.clusteringFields().length];
        for (int i = 0; i < this.clusteringFields().length; ++i) {
            xs[i] = this.clusteringFields()[i].field().getDouble(series2);
            if (!Utils$.MODULE$.nonMissing(xs[i])) continue;
            nonMissing += this.Qi[i];
            nonMissingIdxBuilder.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
        }
        int[] nonMissingIdx = (int[])nonMissingIdxBuilder.result();
        if (nonMissing == 0.0) {
            return this.nullSeries();
        }
        double adjustM = this.sumQi / nonMissing;
        Enumeration.Value value = this.comparisonMeasure().kind();
        Enumeration.Value value2 = ComparisonMeasureKind$.MODULE$.distance();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            double min = Double.POSITIVE_INFINITY;
            String selected = null;
            Option<String> name = None$.MODULE$;
            Map distances = (Map)Map$.MODULE$.empty();
            IntRef i = IntRef.create((int)0);
            while (i.elem < this.clusters().length) {
                int n;
                double distance = this.dis.distance(nonMissingIdx, this.compareFunctions, xs, (double[])this.clusters()[i.elem].array().get(), this.weights, adjustM, this.similarityScales);
                String id = (String)this.clusters()[i.elem].id().getOrElse(() -> ClusteringModel.$anonfun$1(i));
                if (distance < min) {
                    min = distance;
                    selected = id;
                    name = this.clusters()[i.elem].name();
                }
                distances.put((Object)id, (Object)BoxesRunTime.boxToDouble((double)distance));
                i.elem = n = i.elem + 1;
            }
            tuple3 = Tuple3$.MODULE$.apply(selected, (Object)name, (Object)distances);
        } else {
            Enumeration.Value value4 = ComparisonMeasureKind$.MODULE$.similarity();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                double max = Double.NEGATIVE_INFINITY;
                String selected = null;
                Option<String> name = None$.MODULE$;
                Map similarities = (Map)Map$.MODULE$.empty();
                IntRef i = IntRef.create((int)0);
                while (i.elem < this.clusters().length) {
                    int n;
                    double similarity = this.dis.distance(nonMissingIdx, this.compareFunctions, xs, (double[])this.clusters()[i.elem].array().get(), this.weights, adjustM, this.similarityScales);
                    String id = (String)this.clusters()[i.elem].id().getOrElse(() -> ClusteringModel.$anonfun$2(i));
                    if (similarity > max) {
                        max = similarity;
                        selected = id;
                        name = this.clusters()[i.elem].name();
                    }
                    similarities.put((Object)id, (Object)BoxesRunTime.boxToDouble((double)similarity));
                    i.elem = n = i.elem + 1;
                }
                tuple3 = Tuple3$.MODULE$.apply(selected, (Object)name, (Object)similarities);
            } else {
                throw new MatchError((Object)value);
            }
        }
        Tuple3 tuple32 = tuple3;
        String id = (String)tuple32._1();
        Option name = (Option)tuple32._2();
        Map affinities = (Map)tuple32._3();
        ClusteringOutputs outputs = (ClusteringOutputs)((MutableAffinities)((Object)((MutableEntityId)((Object)this.createOutputs().setPredictedValue(id).setPredictedDisplayValue((String)name.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).setEntityId(id))).setAffinities((scala.collection.immutable.Map<Object, Object>)affinities.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return this.result(series2, outputs, this.result$default$3());
    }

    @Override
    public ClusteringOutputs createOutputs() {
        return new ClusteringOutputs();
    }

    @Override
    public OutputField[] defaultOutputFields() {
        ArrayBuilder res = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(OutputField.class));
        res.sizeHint(3);
        res.$plus$eq((Object)OutputField$.MODULE$.predictedValue("cluster", "Identifier of the winning cluster", StringType$.MODULE$, OpType$nominal$.MODULE$));
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.clusters());
        if (((Cluster)ArrayOps$.MODULE$.head$extension(object)).name().isDefined()) {
            res.$plus$eq((Object)OutputField$.MODULE$.predictedDisplayValue("cluster_name", "Name of the winning cluster"));
        }
        Enumeration.Value value = this.modelClass();
        Enumeration.Value value2 = ModelClass$.MODULE$.centerBased();
        res.$plus$eq((Object)(!(value != null ? !value.equals(value2) : value2 != null) ? OutputField$.MODULE$.affinity("distance", "Distance to the predicted entity") : OutputField$.MODULE$.affinity("similarity", "Similarity to the predicted entity")));
        return (OutputField[])res.result();
    }

    private static final Enumeration.Value $init$$$anonfun$2$$anonfun$1(ComparisonMeasure comparisonMeasure$2) {
        return comparisonMeasure$2.compareFunction();
    }

    private static final double $init$$$anonfun$3$$anonfun$1() {
        return 1.0;
    }

    private static final double $init$$$anonfun$5$$anonfun$1() {
        return 1.0;
    }

    private static final double[] $init$$$anonfun$5(ClusteringField[] clusteringFields$1) {
        return (double[])Array$.MODULE$.fill(clusteringFields$1.length, ClusteringModel::$init$$$anonfun$5$$anonfun$1, ClassTag$.MODULE$.apply(Double.TYPE));
    }

    private static final String $anonfun$1(IntRef i$1) {
        return String.valueOf(BoxesRunTime.boxToInteger((int)(i$1.elem + 1)));
    }

    private static final String $anonfun$2(IntRef i$2) {
        return String.valueOf(BoxesRunTime.boxToInteger((int)(i$2.elem + 1)));
    }
}

