/*
 * Decompiled with CFR 0.152.
 */
package org.pmml4s.model;

import java.io.Serializable;
import org.pmml4s.common.HasExtensions;
import org.pmml4s.common.PmmlElement;
import org.pmml4s.common.Vector;
import org.pmml4s.model.Coefficients;
import org.pmml4s.model.KernelType;
import org.pmml4s.model.SVMRepresentation$;
import org.pmml4s.model.SupportVectors;
import org.pmml4s.model.VectorDictionary;
import org.pmml4s.util.MathUtils$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public class SupportVectorMachine
implements HasExtensions,
PmmlElement {
    private final Option supportVectors;
    private final Coefficients coefficients;
    private final Option targetCategory;
    private final Option alternateTargetCategory;
    private final Option threshold;
    private final double[] coeffs;
    private Vector<Object>[] vectors;

    public SupportVectorMachine(Option<SupportVectors> supportVectors, Coefficients coefficients, Option<Object> targetCategory, Option<Object> alternateTargetCategory, Option<Object> threshold) {
        this.supportVectors = supportVectors;
        this.coefficients = coefficients;
        this.targetCategory = targetCategory;
        this.alternateTargetCategory = alternateTargetCategory;
        this.threshold = threshold;
        Object object = Predef$.MODULE$.refArrayOps((Object[])coefficients.coefficients());
        this.coeffs = (double[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$10 -> _$10.value(), ClassTag$.MODULE$.apply(Double.TYPE));
    }

    public Option<SupportVectors> supportVectors() {
        return this.supportVectors;
    }

    public Coefficients coefficients() {
        return this.coefficients;
    }

    public Option<Object> targetCategory() {
        return this.targetCategory;
    }

    public Option<Object> alternateTargetCategory() {
        return this.alternateTargetCategory;
    }

    public Option<Object> threshold() {
        return this.threshold;
    }

    public void init(VectorDictionary vectorDictionary, Enumeration.Value svmRepresentation) {
        Enumeration.Value value = svmRepresentation;
        Enumeration.Value value2 = SVMRepresentation$.MODULE$.SupportVectors();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])((SupportVectors)this.supportVectors().get()).supportVectors());
            this.vectors = (Vector[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x -> vectorDictionary.apply(x.vectorId()).array(), ClassTag$.MODULE$.apply(Vector.class));
        }
    }

    public double eval(double[] xs, KernelType kernelType) {
        double d;
        if (this.vectors != null) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.vectors);
            d = MathUtils$.MODULE$.product((double[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x -> kernelType.compute(xs, (Vector<Object>)x), ClassTag$.MODULE$.apply(Double.TYPE)), this.coeffs) + this.coefficients().absoluteValue();
        } else {
            d = MathUtils$.MODULE$.product(xs, this.coeffs) + this.coefficients().absoluteValue();
        }
        return d;
    }

    public Object predict(double[] xs, KernelType kernelType, boolean maxWins, double threshold, Option<Object> alternateTargetCategoryInferred) {
        double a = this.eval(xs, kernelType);
        double t = BoxesRunTime.unboxToDouble((Object)this.threshold().getOrElse(() -> SupportVectorMachine.$anonfun$5(threshold)));
        return maxWins && a > t || !maxWins && a < t ? this.targetCategory().get() : this.alternateTargetCategory().getOrElse(() -> SupportVectorMachine.predict$$anonfun$5(alternateTargetCategoryInferred));
    }

    private static final double $anonfun$5(double threshold$1) {
        return threshold$1;
    }

    private static final Object predict$$anonfun$5(Option alternateTargetCategoryInferred$1) {
        return alternateTargetCategoryInferred$1.get();
    }
}

