/*
 * Decompiled with CFR 0.152.
 */
package org.pmml4s.transformations;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.pmml4s.common.HasExtensions;
import org.pmml4s.data.Series;
import org.pmml4s.metadata.Field;
import org.pmml4s.transformations.CountHits$;
import org.pmml4s.transformations.Expression;
import org.pmml4s.transformations.FieldExpression;
import org.pmml4s.transformations.LocalTermWeights$;
import org.pmml4s.transformations.NumericFieldExpression;
import org.pmml4s.transformations.TextIndex$;
import org.pmml4s.transformations.TextIndexNormalization;
import org.pmml4s.transformations.UnaryExpression;
import org.pmml4s.util.Utils$;
import scala.Enumeration;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.control.Breaks$;

public class TextIndex
implements HasExtensions,
Expression,
UnaryExpression,
FieldExpression,
NumericFieldExpression {
    private final Field field;
    private final Expression expression;
    private final TextIndexNormalization[] textIndexNormalizations;
    private final Enumeration.Value localTermWeights;
    private final boolean isCaseSensitive;
    private final int maxLevenshteinDistance;
    private final Enumeration.Value countHits;
    private final String wordSeparatorCharacterRE;
    private final boolean tokenize;

    public static Pattern PUNCTUATION_PATTERN() {
        return TextIndex$.MODULE$.PUNCTUATION_PATTERN();
    }

    public static TextIndexNormalization[] $lessinit$greater$default$3() {
        return TextIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static Enumeration.Value $lessinit$greater$default$4() {
        return TextIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$5() {
        return TextIndex$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$6() {
        return TextIndex$.MODULE$.$lessinit$greater$default$6();
    }

    public static Enumeration.Value $lessinit$greater$default$7() {
        return TextIndex$.MODULE$.$lessinit$greater$default$7();
    }

    public static String $lessinit$greater$default$8() {
        return TextIndex$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean $lessinit$greater$default$9() {
        return TextIndex$.MODULE$.$lessinit$greater$default$9();
    }

    public TextIndex(Field field, Expression expression, TextIndexNormalization[] textIndexNormalizations, Enumeration.Value localTermWeights, boolean isCaseSensitive, int maxLevenshteinDistance, Enumeration.Value countHits, String wordSeparatorCharacterRE, boolean tokenize) {
        this.field = field;
        this.expression = expression;
        this.textIndexNormalizations = textIndexNormalizations;
        this.localTermWeights = localTermWeights;
        this.isCaseSensitive = isCaseSensitive;
        this.maxLevenshteinDistance = maxLevenshteinDistance;
        this.countHits = countHits;
        this.wordSeparatorCharacterRE = wordSeparatorCharacterRE;
        this.tokenize = tokenize;
    }

    @Override
    public Field field() {
        return this.field;
    }

    public Expression expression() {
        return this.expression;
    }

    public TextIndexNormalization[] textIndexNormalizations() {
        return this.textIndexNormalizations;
    }

    public Enumeration.Value localTermWeights() {
        return this.localTermWeights;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public int maxLevenshteinDistance() {
        return this.maxLevenshteinDistance;
    }

    public Enumeration.Value countHits() {
        return this.countHits;
    }

    public String wordSeparatorCharacterRE() {
        return this.wordSeparatorCharacterRE;
    }

    public boolean tokenize() {
        return this.tokenize;
    }

    @Override
    public double eval(Series series) {
        double d;
        Object text = this.field().get(series);
        Object term = this.expression().eval(series);
        if (Utils$.MODULE$.isMissing(text) || Utils$.MODULE$.isMissing(term)) {
            d = Double.NaN;
        } else {
            Object object;
            ObjectRef textValue = ObjectRef.create((Object)text.toString());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.textIndexNormalizations());
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)x -> {
                String string = x.normalize((String)textValue$1.elem, this.isCaseSensitive(), this.maxLevenshteinDistance(), this.wordSeparatorCharacterRE(), this.tokenize());
                textValue$1.elem = string;
                string = null;
            });
            String termValue = term.toString();
            Tuple2 tuple2 = this.tokenize() ? Tuple2$.MODULE$.apply((Object)((String)textValue.elem).split(this.wordSeparatorCharacterRE()), (Object)termValue.split(this.wordSeparatorCharacterRE())) : Tuple2$.MODULE$.apply((Object)new String[]{(String)textValue.elem}, (Object)new String[]{termValue});
            Object[] textTokens = (String[])tuple2._1();
            Object[] termTokens = (String[])tuple2._2();
            Object object3 = Predef$.MODULE$.refArrayOps(textTokens);
            if (ArrayOps$.MODULE$.isEmpty$extension(object3) || ArrayOps$.MODULE$.isEmpty$extension(object = Predef$.MODULE$.refArrayOps(termTokens))) {
                d = 0.0;
            } else {
                Object[] objectArray;
                Object[] textTokensTest;
                Object[] objectArray2;
                Object object4 = Predef$.MODULE$.refArrayOps(textTokens);
                Object[] textTokensPunctuationFree = (String[])ArrayOps$.MODULE$.map$extension(object4, (Function1 & Serializable)x -> TextIndex$.MODULE$.PUNCTUATION_PATTERN().matcher((CharSequence)x).replaceAll(""), ClassTag$.MODULE$.apply(String.class));
                Object object5 = Predef$.MODULE$.refArrayOps(termTokens);
                Object[] termTokensPunctuationFree = (String[])ArrayOps$.MODULE$.map$extension(object5, (Function1 & Serializable)x -> TextIndex$.MODULE$.PUNCTUATION_PATTERN().matcher((CharSequence)x).replaceAll(""), ClassTag$.MODULE$.apply(String.class));
                if (this.isCaseSensitive()) {
                    objectArray2 = textTokensPunctuationFree;
                } else {
                    Object object6 = Predef$.MODULE$.refArrayOps(textTokensPunctuationFree);
                    objectArray2 = textTokensTest = (String[])ArrayOps$.MODULE$.map$extension(object6, (Function1 & Serializable)_$1 -> _$1.toLowerCase(), ClassTag$.MODULE$.apply(String.class));
                }
                if (this.isCaseSensitive()) {
                    objectArray = termTokensPunctuationFree;
                } else {
                    Object object7 = Predef$.MODULE$.refArrayOps(termTokensPunctuationFree);
                    objectArray = (String[])ArrayOps$.MODULE$.map$extension(object7, (Function1 & Serializable)_$2 -> _$2.toLowerCase(), ClassTag$.MODULE$.apply(String.class));
                }
                Object[] termTokensTest = objectArray;
                int frequency = 0;
                int minDistance = Integer.MAX_VALUE;
                IntRef i = IntRef.create((int)0);
                while (i.elem <= textTokensTest.length - termTokensTest.length) {
                    int n;
                    IntRef sumDistance = IntRef.create((int)0);
                    BooleanRef hit = BooleanRef.create((boolean)true);
                    Breaks$.MODULE$.breakable(() -> this.eval$$anonfun$adapted$1((String[])textTokensTest, (String[])termTokensTest, i, sumDistance, hit));
                    if (hit.elem) {
                        Enumeration.Value value = this.countHits();
                        Enumeration.Value value2 = CountHits$.MODULE$.allHits();
                        Enumeration.Value value3 = value;
                        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                            ++frequency;
                        } else {
                            Enumeration.Value value4 = CountHits$.MODULE$.bestHits();
                            Enumeration.Value value5 = value;
                            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                                if (sumDistance.elem < minDistance) {
                                    minDistance = sumDistance.elem;
                                    frequency = 1;
                                } else if (sumDistance.elem == minDistance) {
                                    ++frequency;
                                }
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                    i.elem = n = i.elem + 1;
                }
                Enumeration.Value value = this.localTermWeights();
                Enumeration.Value value6 = LocalTermWeights$.MODULE$.termFrequency();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    d = Int$.MODULE$.int2double(frequency);
                } else {
                    Enumeration.Value value8 = LocalTermWeights$.MODULE$.binary();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        d = frequency > 0 ? 1.0 : 0.0;
                    } else {
                        Enumeration.Value value10 = LocalTermWeights$.MODULE$.logarithmic();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            d = Math.log(Int$.MODULE$.int2double(1 + frequency));
                        } else {
                            Enumeration.Value value12 = LocalTermWeights$.MODULE$.augmentedNormalizedTermFrequency();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                throw Predef$.MODULE$.$qmark$qmark$qmark();
                            }
                            throw new MatchError((Object)value);
                        }
                    }
                }
            }
        }
        return d;
    }

    private final void eval$$anonfun$2(String[] textTokensTest$1, String[] termTokensTest$1, IntRef i$1, IntRef sumDistance$1, BooleanRef hit$1) {
        for (int j = 0; j < termTokensTest$1.length; ++j) {
            int n;
            LevenshteinDistance levenshteinDistance = new LevenshteinDistance(Predef$.MODULE$.int2Integer(this.maxLevenshteinDistance() - sumDistance$1.elem));
            Integer distance = levenshteinDistance.apply((CharSequence)textTokensTest$1[i$1.elem + j], (CharSequence)termTokensTest$1[j]);
            if (BoxesRunTime.equals((Object)distance, (Object)BoxesRunTime.boxToInteger((int)-1))) {
                boolean bl;
                hit$1.elem = bl = false;
                throw Breaks$.MODULE$.break();
            }
            sumDistance$1.elem = n = sumDistance$1.elem + Predef$.MODULE$.Integer2int(distance);
        }
    }
}

