/*
 * Decompiled with CFR 0.152.
 */
package org.pmml4s.transformations;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pmml4s.common.HasExtensions;
import org.pmml4s.common.PmmlElement;
import org.pmml4s.common.Row;
import org.pmml4s.common.Table;
import org.pmml4s.transformations.TextIndexNormalization$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.Breaks$;

public class TextIndexNormalization
implements HasExtensions,
PmmlElement {
    private final Table table;
    private final Option isCaseSensitive;
    private final Option maxLevenshteinDistance;
    private final Option wordSeparatorCharacterRE;
    private final Option tokenize;
    private final String inField;
    private final String outField;
    private final String regexField;
    private final boolean recursive;

    public static String $lessinit$greater$default$6() {
        return TextIndexNormalization$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$7() {
        return TextIndexNormalization$.MODULE$.$lessinit$greater$default$7();
    }

    public static String $lessinit$greater$default$8() {
        return TextIndexNormalization$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean $lessinit$greater$default$9() {
        return TextIndexNormalization$.MODULE$.$lessinit$greater$default$9();
    }

    public TextIndexNormalization(Table table, Option<Object> isCaseSensitive, Option<Object> maxLevenshteinDistance, Option<String> wordSeparatorCharacterRE, Option<Object> tokenize, String inField, String outField, String regexField, boolean recursive) {
        this.table = table;
        this.isCaseSensitive = isCaseSensitive;
        this.maxLevenshteinDistance = maxLevenshteinDistance;
        this.wordSeparatorCharacterRE = wordSeparatorCharacterRE;
        this.tokenize = tokenize;
        this.inField = inField;
        this.outField = outField;
        this.regexField = regexField;
        this.recursive = recursive;
    }

    public Table table() {
        return this.table;
    }

    public Option<Object> isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public Option<Object> maxLevenshteinDistance() {
        return this.maxLevenshteinDistance;
    }

    public Option<String> wordSeparatorCharacterRE() {
        return this.wordSeparatorCharacterRE;
    }

    public Option<Object> tokenize() {
        return this.tokenize;
    }

    public String inField() {
        return this.inField;
    }

    public String outField() {
        return this.outField;
    }

    public String regexField() {
        return this.regexField;
    }

    public boolean recursive() {
        return this.recursive;
    }

    public String normalize(String text, boolean isCaseSensitive, int maxLevenshteinDistance, String wordSeparatorCharacterRE, boolean tokenize) {
        Tuple2<Object, Object> tuple2 = this.table().dim();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int rowNum = BoxesRunTime.unboxToInt((Object)tuple2._1());
        int rowNum2 = rowNum;
        ObjectRef result = ObjectRef.create((Object)text);
        boolean isCaseSensitiveUsed = BoxesRunTime.unboxToBoolean((Object)this.isCaseSensitive().getOrElse(() -> TextIndexNormalization.$anonfun$5(isCaseSensitive)));
        if (this.recursive()) {
            BooleanRef stop = BooleanRef.create((boolean)false);
            Breaks$.MODULE$.breakable((Function0 & Serializable)() -> {
                this.normalize$$anonfun$1(rowNum2, result, isCaseSensitiveUsed, stop);
                return BoxedUnit.UNIT;
            });
        } else {
            for (int i = 0; i < rowNum2; ++i) {
                Row row = this.table().apply(i);
                String in = row.apply(this.inField()).toString();
                String out = row.apply(this.outField()).toString();
                Option<Object> option = row.get(this.regexField());
                String string = option instanceof Some && "true".equals(((Some)option).value()) ? ((String)result.elem).replaceAll(in, out) : Pattern.compile(in, isCaseSensitiveUsed ? 16 : 18).matcher((String)result.elem).replaceAll(Matcher.quoteReplacement(out));
                result.elem = string;
                string = null;
            }
        }
        return (String)result.elem;
    }

    private static final boolean $anonfun$5(boolean isCaseSensitive$1) {
        return isCaseSensitive$1;
    }

    private final void normalize$$anonfun$1(int rowNum$1, ObjectRef result$1, boolean isCaseSensitiveUsed$1, BooleanRef stop$1) {
        while (!stop$1.elem) {
            for (int i = 0; i < rowNum$1; ++i) {
                boolean bl;
                String previous = (String)result$1.elem;
                Row row = this.table().apply(i);
                String in = row.apply(this.inField()).toString();
                String out = row.apply(this.outField()).toString();
                Option<Object> option = row.get(this.regexField());
                String string = option instanceof Some && "true".equals(((Some)option).value()) ? previous.replaceAll(in, out) : Pattern.compile(in, isCaseSensitiveUsed$1 ? 16 : 18).matcher(previous).replaceAll(Matcher.quoteReplacement(out));
                result$1.elem = string;
                string = null;
                String string2 = (String)result$1.elem;
                String string3 = previous;
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) continue;
                stop$1.elem = bl = true;
                throw Breaks$.MODULE$.break();
            }
        }
    }
}

