/*
 * Decompiled with CFR 0.152.
 */
package org.polyfillservice.api.components;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Polyfill {
    private String name;
    private String rawSource;
    private String minSource;
    private String detectSource;
    private String testsSource;
    private String license;
    private String repository;
    private boolean isTestable;
    private List<String> aliases;
    private List<String> dependencies;
    private Map<String, String> browserRequirements;

    private Polyfill() {
    }

    private Polyfill(Polyfill polyfill) {
        this.name = polyfill.name;
        this.rawSource = polyfill.rawSource;
        this.minSource = polyfill.minSource;
        this.detectSource = polyfill.detectSource;
        this.testsSource = polyfill.testsSource;
        this.license = polyfill.license;
        this.repository = polyfill.repository;
        this.isTestable = polyfill.isTestable;
        this.aliases = polyfill.aliases;
        this.dependencies = polyfill.dependencies;
        this.browserRequirements = polyfill.browserRequirements;
    }

    public String toString() {
        return "{ name:" + this.name + ", aliases: " + this.aliases.toString() + ", browsers: " + this.browserRequirements.toString() + ", dependencies: " + this.dependencies.toString() + ", license: " + this.license + ", repository: " + this.repository + ", rawSource: " + this.rawSource + ", minSource: " + this.minSource + ", detectSource: " + this.detectSource + ", testsSource: " + this.testsSource + ", isTestable: " + this.isTestable + "}";
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public Map<String, String> getAllBrowserRequirements() {
        return this.browserRequirements;
    }

    @Nullable
    public String getBrowserRequirement(String browserName) {
        Map<String, String> allBrowserRequirements = this.getAllBrowserRequirements();
        return allBrowserRequirements.get(browserName);
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    @Nullable
    public String getDetectSource() {
        return this.detectSource;
    }

    @Nullable
    public String getMinSource() {
        return this.minSource;
    }

    @Nullable
    public String getRawSource() {
        return this.rawSource;
    }

    @Nullable
    public String getLicense() {
        return this.license;
    }

    @Nullable
    public String getRepository() {
        return this.repository;
    }

    @Nullable
    public String getTestsSource() {
        return this.testsSource;
    }

    public boolean isTestable() {
        return this.isTestable;
    }

    public static class Builder {
        private Polyfill polyfill = new Polyfill();

        public Builder(String name) {
            this.polyfill.name = name;
            this.polyfill.isTestable = false;
            this.polyfill.aliases = Collections.emptyList();
            this.polyfill.dependencies = Collections.emptyList();
            this.polyfill.browserRequirements = Collections.emptyMap();
        }

        public Polyfill build() {
            return new Polyfill(this.polyfill);
        }

        public Builder rawSource(String rawSource) {
            this.polyfill.rawSource = rawSource;
            return this;
        }

        public Builder minSource(String minSource) {
            this.polyfill.minSource = minSource;
            return this;
        }

        public Builder detectSource(String detectSource) {
            this.polyfill.detectSource = detectSource;
            return this;
        }

        public Builder testsSource(String testsSource) {
            this.polyfill.testsSource = testsSource;
            return this;
        }

        public Builder license(String license) {
            this.polyfill.license = license;
            return this;
        }

        public Builder repository(String repository) {
            this.polyfill.repository = repository;
            return this;
        }

        public Builder isTestable(boolean testable) {
            this.polyfill.isTestable = testable;
            return this;
        }

        public Builder aliases(List<String> aliases) {
            if (aliases != null && !aliases.isEmpty()) {
                this.polyfill.aliases = Collections.unmodifiableList(aliases);
            }
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            if (dependencies != null && !dependencies.isEmpty()) {
                this.polyfill.dependencies = Collections.unmodifiableList(dependencies);
            }
            return this;
        }

        public Builder browserRequirements(Map<String, String> browserRequirements) {
            if (browserRequirements != null && !browserRequirements.isEmpty()) {
                this.polyfill.browserRequirements = Collections.unmodifiableMap(browserRequirements);
            }
            return this;
        }
    }
}

