/*
 * Decompiled with CFR 0.152.
 */
package org.polyfillservice.api.components;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.polyfillservice.api.components.Feature;

public class Query {
    private List<Feature> features;
    private Set<String> excludes = new HashSet<String>();
    private boolean loadOnUnknownUA = true;
    private boolean minify = true;
    private boolean gatedForAll = true;
    private boolean alwaysForAll = false;
    private boolean includeDependencies = true;

    private Query() {
    }

    private Query(Query query) {
        this.features = query.features;
        this.excludes = query.excludes;
        this.loadOnUnknownUA = query.loadOnUnknownUA;
        this.minify = query.minify;
        this.gatedForAll = query.gatedForAll;
        this.alwaysForAll = query.alwaysForAll;
        this.includeDependencies = query.includeDependencies;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public boolean shouldLoadOnUnknownUA() {
        return this.loadOnUnknownUA;
    }

    public boolean shouldIncludeDependencies() {
        return this.includeDependencies;
    }

    public boolean shouldMinify() {
        return this.minify;
    }

    public boolean isGatedForAll() {
        return this.gatedForAll;
    }

    public boolean isAlwaysForAll() {
        return this.alwaysForAll;
    }

    public static class Builder {
        private Query query = new Query();

        public Builder(List<Feature> features) {
            this.query.features = features;
        }

        public Query build() {
            return new Query(this.query);
        }

        public Builder excludeFeatures(String ... features) {
            return this.excludeFeatures(Arrays.asList(features));
        }

        public Builder excludeFeatures(List<String> features) {
            this.query.excludes.addAll(features);
            return this;
        }

        public Builder setLoadOnUnknownUA(boolean loadOnUnknownUA) {
            this.query.loadOnUnknownUA = loadOnUnknownUA;
            return this;
        }

        public Builder setMinify(boolean minify) {
            this.query.minify = minify;
            return this;
        }

        public Builder setAlwaysForAll(boolean alwaysForAll) {
            this.query.alwaysForAll = alwaysForAll;
            return this;
        }

        public Builder setGatedForAll(boolean gatedForAll) {
            this.query.gatedForAll = gatedForAll;
            return this;
        }

        public Builder setIncludeDependencies(boolean includeDependencies) {
            this.query.includeDependencies = includeDependencies;
            return this;
        }
    }
}

