/*
 * Decompiled with CFR 0.152.
 */
package org.polyfillservice.api.configurations;

import java.util.List;
import java.util.stream.Collectors;
import org.polyfillservice.api.components.Feature;
import org.polyfillservice.api.components.Query;
import org.polyfillservice.api.components.ServiceConfig;
import org.polyfillservice.api.interfaces.PolyfillServiceConfigLocation;
import org.polyfillservice.api.interfaces.ServiceConfigLoaderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:config.properties"})
@ComponentScan(basePackages={"org.polyfillservice.api"})
public class PolyfillApiConfig {
    @Autowired
    ServiceConfigLoaderService serviceConfigLoaderService;
    @Autowired(required=false)
    private PolyfillServiceConfigLocation serviceConfigLocation;

    @Bean
    @Value(value="${project.version}")
    public String projectVersion(String projectVersion) {
        return projectVersion;
    }

    @Bean
    @Value(value="${project.url}")
    public String projectUrl(String projectUrl) {
        return projectUrl;
    }

    @Bean
    public ServiceConfig serviceConfig() {
        return this.serviceConfigLoaderService.loadConfig(this.serviceConfigLocation);
    }

    @Bean
    @Autowired
    public Query defaultQuery(ServiceConfig serviceConfig) {
        List<Feature> polyfillRequestList = serviceConfig.getPolyfills().stream().map(Feature::new).collect(Collectors.toList());
        return new Query.Builder(polyfillRequestList).setMinify(serviceConfig.shouldMinify()).setLoadOnUnknownUA(serviceConfig.shouldLoadOnUnknownUA()).setGatedForAll(serviceConfig.shouldGate()).build();
    }
}

