/*
 * Decompiled with CFR 0.152.
 */
package org.polyfillservice.api.configurations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.polyfillservice.api.components.Polyfill;
import org.polyfillservice.api.components.PolyfillLocationString;
import org.polyfillservice.api.interfaces.PolyfillConfigLoaderService;
import org.polyfillservice.api.interfaces.PolyfillLoaderService;
import org.polyfillservice.api.interfaces.PolyfillLocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PolyfillSourceConfig {
    private static final String DEFAULT_POLYFILLS_LOCATION = "polyfills";
    @Autowired(required=false)
    private List<PolyfillLocation> customPolyfillLocations;
    @Autowired
    private PolyfillConfigLoaderService polyfillConfigLoaderService;
    @Autowired
    private PolyfillLoaderService polyfillLoaderService;

    @Bean
    public Map<String, List<String>> aliases() throws IOException, ClassCastException {
        return this.polyfillConfigLoaderService.getConfig(DEFAULT_POLYFILLS_LOCATION, "aliases.json");
    }

    @Bean
    public Map<String, String> browserBaselines() throws IOException, ClassCastException {
        return this.polyfillConfigLoaderService.getConfig(DEFAULT_POLYFILLS_LOCATION, "browserBaselines.json");
    }

    @Bean
    public Map<String, Polyfill> polyfills() {
        ArrayList<PolyfillLocation> polyfillLocationList = new ArrayList<PolyfillLocation>();
        if (this.customPolyfillLocations != null && !this.customPolyfillLocations.isEmpty()) {
            polyfillLocationList.addAll(this.customPolyfillLocations);
        }
        polyfillLocationList.add(new PolyfillLocationString(DEFAULT_POLYFILLS_LOCATION));
        return this.polyfillLoaderService.loadPolyfills(polyfillLocationList);
    }
}

