/*
 * Decompiled with CFR 0.152.
 */
package org.polyfillservice.api.interfaces;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public interface ResourceLoaderService {
    default public String resourceToString(Resource resource) throws IOException {
        try (InputStream is = resource.getInputStream();){
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String string = result.toString(StandardCharsets.UTF_8.name());
            return string;
        }
    }

    default public Resource getResource(String first, String ... more) throws IOException {
        String filePattern = Paths.get(first, more).toString();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        return resolver.getResource("classpath:" + filePattern);
    }

    default public List<Resource> getResources(String first, String ... more) throws IOException {
        String filePattern = Paths.get(first, more).toString();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources("classpath:" + filePattern);
        if (resources.length == 0) {
            throw new IOException("No matching resources are found in:" + filePattern);
        }
        return Arrays.asList(resources);
    }
}

