/*
 * Decompiled with CFR 0.152.
 */
package org.polyfillservice.api.services;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.polyfillservice.api.components.Polyfill;
import org.polyfillservice.api.components.ServiceConfig;
import org.polyfillservice.api.interfaces.PolyfillConfigLoaderService;
import org.polyfillservice.api.interfaces.PolyfillLoaderService;
import org.polyfillservice.api.interfaces.PolyfillLocation;
import org.polyfillservice.api.interfaces.ResourceLoaderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="all")
class FinancialTimesPolyfillLoaderService
implements PolyfillLoaderService,
ResourceLoaderService {
    private static final String ALIASES_KEY = "aliases";
    private static final String BROWSER_REQUIREMENTS_KEY = "browsers";
    private static final String DETECT_SOURCE_KEY = "detectSource";
    private static final String DEPENDENCIES_KEY = "dependencies";
    private static final String LICENSE_KEY = "license";
    private static final String REPO_KEY = "repo";
    private static final String TEST_KEY = "test";
    private static final String TESTS_SOURCE_KEY = "testsSource";
    private static final String META_FILENAME = "meta.json";
    private static final String MIN_FILENAME = "min.js";
    private static final String RAW_FILENAME = "raw.js";
    @Resource(name="aliases")
    private Map<String, List<String>> aliases;
    @Autowired
    private ServiceConfig serviceConfig;
    @Autowired
    private PolyfillConfigLoaderService configLoader;

    FinancialTimesPolyfillLoaderService() {
    }

    @Override
    public Map<String, Polyfill> loadPolyfills(List<PolyfillLocation> polyfillLocations) {
        if (polyfillLocations == null || polyfillLocations.isEmpty()) {
            return Collections.emptyMap();
        }
        List<String> activePolyfills = this.serviceConfig.getPolyfills();
        if (!activePolyfills.isEmpty()) {
            return this.loadPartialPolyfills(polyfillLocations, activePolyfills);
        }
        return this.loadAllPolyfills(polyfillLocations);
    }

    private Map<String, Polyfill> loadPartialPolyfills(List<PolyfillLocation> polyfillLocations, List<String> activePolyfills) {
        HashMap<String, Polyfill> polyfills = new HashMap<String, Polyfill>();
        LinkedList<String> processQueue = new LinkedList<String>(activePolyfills);
        while (!processQueue.isEmpty()) {
            String polyfillName = (String)processQueue.remove();
            if (polyfills.containsKey(polyfillName)) continue;
            List<String> polyfillGroup = this.aliases.get(polyfillName);
            if (polyfillGroup != null) {
                processQueue.addAll(polyfillGroup);
                continue;
            }
            Polyfill polyfill = this.loadPolyfill(polyfillLocations, polyfillName);
            if (polyfill == null) continue;
            polyfills.put(polyfillName, polyfill);
            processQueue.addAll(polyfill.getDependencies());
        }
        return Collections.unmodifiableMap(polyfills);
    }

    private Map<String, Polyfill> loadAllPolyfills(List<PolyfillLocation> polyfillLocations) {
        HashMap polyfills = new HashMap();
        for (PolyfillLocation location : polyfillLocations) {
            String polyfillsPath = location.getPath();
            try {
                this.getResources(polyfillsPath, "*", META_FILENAME).forEach(polyfillResource -> {
                    try {
                        String polyfillName = this.getBaseDirectoryName((org.springframework.core.io.Resource)polyfillResource);
                        if (!polyfills.containsKey(polyfillName)) {
                            Polyfill polyfill = this.loadPolyfill(polyfillsPath, polyfillName);
                            polyfills.put(polyfill.getName(), polyfill);
                        }
                    }
                    catch (IOException e) {
                        System.err.println("[Warning] Unable to load polyfill from resource: " + polyfillResource.toString());
                    }
                });
            }
            catch (IOException e) {
                System.err.println("[Warning] Unable to load polyfills from " + polyfillsPath);
            }
        }
        return Collections.unmodifiableMap(polyfills);
    }

    private Polyfill loadPolyfill(List<PolyfillLocation> polyfillLocationList, String polyfillName) {
        Polyfill polyfill = null;
        for (PolyfillLocation location : polyfillLocationList) {
            try {
                polyfill = this.loadPolyfill(location.getPath(), polyfillName);
                break;
            }
            catch (IOException iOException) {
            }
        }
        if (polyfill == null) {
            System.err.println("[Warning] Unable to load polyfill: " + polyfillName);
        }
        return polyfill;
    }

    private Polyfill loadPolyfill(String polyfillsPath, String polyfillName) throws IOException {
        String polyfillDir = Paths.get(polyfillsPath, polyfillName).toString();
        Map<String, Object> meta = this.configLoader.getConfig(polyfillDir, META_FILENAME);
        String rawSource = this.resourceToString(this.getResource(polyfillDir, RAW_FILENAME));
        String minSource = this.resourceToString(this.getResource(polyfillDir, MIN_FILENAME));
        return new Polyfill.Builder(polyfillName).rawSource(rawSource).minSource(minSource).aliases(this.getList(meta, ALIASES_KEY)).browserRequirements(this.getMap(meta, BROWSER_REQUIREMENTS_KEY)).dependencies(this.getList(meta, DEPENDENCIES_KEY)).license(this.getString(meta, LICENSE_KEY)).repository(this.getString(meta, REPO_KEY)).detectSource(this.getString(meta, DETECT_SOURCE_KEY)).testsSource(this.getString(meta, TESTS_SOURCE_KEY)).isTestable(this.getIsTestable(meta)).build();
    }

    private boolean getIsTestable(Map<String, Object> meta) {
        Map testMap = this.getMap(meta, TEST_KEY);
        String testsSource = this.getString(meta, TESTS_SOURCE_KEY);
        return testsSource != null && !testsSource.isEmpty() && testMap.getOrDefault("ci", true) != false;
    }

    private String getString(Map<String, Object> map, String key) {
        Object value = map.get(key);
        return value instanceof String ? (String)value : null;
    }

    private List<String> getList(Map<String, Object> map, String key) {
        return map.getOrDefault(key, Collections.emptyList());
    }

    private Map getMap(Map<String, Object> map, String key) {
        return map.getOrDefault(key, Collections.emptyMap());
    }

    private String getBaseDirectoryName(org.springframework.core.io.Resource resource) throws IOException {
        Path path = FileSystems.getDefault().getPath(resource.getURI().toString(), new String[0]);
        return path.getParent().getFileName().toString();
    }
}

