/*
 * Decompiled with CFR 0.152.
 */
package org.polyfillservice.api.services;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.polyfillservice.api.components.Feature;
import org.polyfillservice.api.components.Polyfill;
import org.polyfillservice.api.components.Query;
import org.springframework.stereotype.Service;

@Service
class PolyfillsOutputService {
    private static final String NO_POLYFILLS_MESSAGE = "No polyfills found for current settings";
    private static final String MIN_MESSAGE = "Disable minification (remove `.min` from URL path) for more info";
    @Resource(name="projectVersion")
    private String projectVersion;
    @Resource(name="projectUrl")
    private String projectUrl;

    PolyfillsOutputService() {
    }

    public String getPolyfillsSource(String uaString, Query query, List<Feature> featuresLoaded, boolean isDebugMode) {
        String debugInfo = isDebugMode ? this.getDebugInfo(uaString, query, featuresLoaded) : "";
        String sources = this.getSources(featuresLoaded, query.shouldMinify());
        String separator = !debugInfo.isEmpty() && !sources.isEmpty() ? "\n\n" : "";
        return debugInfo + separator + sources;
    }

    private String getSources(List<Feature> features, boolean minify) {
        String sources = features.stream().map(feature -> this.getSource((Feature)feature, minify)).collect(Collectors.joining());
        return sources.isEmpty() ? "" : this.wrapInClosure(sources, minify);
    }

    private String getSource(Feature feature, boolean minify) {
        boolean wrapInDetect;
        Polyfill polyfill = feature.getPolyfill();
        String detectSource = polyfill.getDetectSource();
        String source = minify ? polyfill.getMinSource() : polyfill.getRawSource();
        source = source == null ? "" : source;
        boolean bl = wrapInDetect = feature.isGated() && detectSource != null;
        if (wrapInDetect && !"".equals(detectSource)) {
            String lf = minify ? "" : "\n";
            return "if(!(" + detectSource + ")){" + lf + source + lf + "}" + lf + lf;
        }
        return source;
    }

    private String wrapInClosure(String source, boolean minify) {
        String lf = minify ? "" : "\n";
        return "(function(undefined) {" + lf + source + "})" + lf + ".call('object' === typeof window && window || 'object' === typeof self && self || 'object' === typeof global && global || {});";
    }

    private String getDebugInfo(String uaString, Query query, List<Feature> featuresLoaded) {
        if (query.shouldMinify()) {
            return this.buildCommentBlock(MIN_MESSAGE);
        }
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Polyfill service v" + this.projectVersion);
        headers.add("For detailed credits and licence information see " + this.projectUrl);
        if (uaString != null) {
            headers.add("");
            headers.add("UA detected: " + uaString);
        }
        if (!query.getFeatures().isEmpty()) {
            String featuresRequestedLine = query.getFeatures().stream().map(Feature::getName).collect(Collectors.joining(","));
            headers.add("Features requested: " + featuresRequestedLine);
        }
        headers.add("");
        if (featuresLoaded.isEmpty()) {
            headers.add(NO_POLYFILLS_MESSAGE);
        } else {
            List featuresLoadedLines = featuresLoaded.stream().map(this::formatFeatureLoaded).collect(Collectors.toList());
            headers.addAll(featuresLoadedLines);
        }
        return this.buildCommentBlock(headers);
    }

    private String buildCommentBlock(List<String> lines) {
        return this.buildCommentBlock(lines.stream().collect(Collectors.joining("\n * ")));
    }

    private String buildCommentBlock(String line) {
        return "/* " + line + " */";
    }

    private String formatFeatureLoaded(Feature feature) {
        String license = "";
        Polyfill polyfill = feature.getPolyfill();
        if (polyfill.getLicense() != null) {
            license = ", License: " + polyfill.getLicense();
        }
        String relatedFeatures = "";
        if (!feature.getRequiredBys().isEmpty()) {
            relatedFeatures = feature.getRequiredBys().stream().map(featureName -> "\"" + featureName + "\"").collect(Collectors.joining(", "));
            relatedFeatures = " (required by " + relatedFeatures + ")";
        }
        return "- " + feature.getName() + license + relatedFeatures;
    }
}

