/*
 * Decompiled with CFR 0.152.
 */
package org.polyfillservice.api.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.polyfillservice.api.components.Feature;
import org.polyfillservice.api.components.Polyfill;
import org.polyfillservice.api.components.Query;
import org.polyfillservice.api.components.TSort;
import org.polyfillservice.api.interfaces.PolyfillService;
import org.polyfillservice.api.interfaces.UserAgent;
import org.polyfillservice.api.interfaces.UserAgentParserService;
import org.polyfillservice.api.interfaces.VersionUtilService;
import org.polyfillservice.api.services.PolyfillsOutputService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="presort")
class PreSortPolyfillService
implements PolyfillService {
    @Resource(name="polyfills")
    private Map<String, Polyfill> polyfills;
    @Resource(name="browserBaselines")
    private Map<String, String> browserBaselines;
    @Resource(name="aliases")
    private Map<String, List<String>> aliases;
    @Resource(name="defaultQuery")
    private Query defaultQuery;
    @Autowired
    private VersionUtilService versionChecker;
    @Autowired
    private UserAgentParserService userAgentParserService;
    @Autowired
    private PolyfillsOutputService polyfillsOutputService;
    private List<String> sortedPolyfills;

    PreSortPolyfillService() {
    }

    @PostConstruct
    public void init() {
        this.sortedPolyfills = this.getDependencySortedPolyfills(this.polyfills);
    }

    @Override
    public Map<String, Polyfill> getAllPolyfills() {
        return this.polyfills;
    }

    @Override
    public Polyfill getPolyfill(String name) {
        return this.polyfills.get(name);
    }

    @Override
    public List<Polyfill> getPolyfills(String uaString) {
        return this.getPolyfills(uaString, this.defaultQuery);
    }

    @Override
    public List<Polyfill> getPolyfills(String uaString, Query query) {
        UserAgent userAgent = uaString == null ? null : this.userAgentParserService.parse(uaString);
        return this.getFeatures(userAgent, query).stream().map(feature -> feature.getPolyfill()).collect(Collectors.toList());
    }

    @Override
    public String getPolyfillsSource(String uaString) {
        return this.getPolyfillsSource(uaString, this.defaultQuery, false);
    }

    @Override
    public String getPolyfillsSource(String uaString, Query query) {
        return this.getPolyfillsSource(uaString, query, false);
    }

    @Override
    public String getPolyfillsSource(String uaString, Query query, boolean isDebugMode) {
        UserAgent userAgent = uaString == null ? null : this.userAgentParserService.parse(uaString);
        List<Feature> featuresLoaded = this.getFeatures(userAgent, query);
        return this.polyfillsOutputService.getPolyfillsSource(userAgent.toString(), query, featuresLoaded, isDebugMode);
    }

    private List<Feature> getFeatures(UserAgent userAgent, Query query) {
        if (userAgent != null && !this.isUserAgentSupported(userAgent) && !query.shouldLoadOnUnknownUA() || query.getFeatures().isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Feature> featureSet = new HashMap<String, Feature>();
        for (Feature feature : query.getFeatures()) {
            if (query.isAlwaysForAll()) {
                feature.setAlways(true);
            }
            if (query.isGatedForAll()) {
                feature.setGated(true);
            }
            featureSet.put(feature.getName(), feature);
        }
        this.resolveAlias(featureSet);
        this.filterForTargetingUA(featureSet, userAgent, query.shouldLoadOnUnknownUA());
        if (query.shouldIncludeDependencies()) {
            this.resolveDependencies(featureSet);
            this.filterForTargetingUA(featureSet, userAgent, query.shouldLoadOnUnknownUA());
        }
        this.filterExcludes(featureSet, query.getExcludes());
        this.attachPolyfills(featureSet);
        return this.sortByDependency(featureSet);
    }

    private void attachPolyfills(Map<String, Feature> featureSet) {
        for (Feature feature : featureSet.values()) {
            feature.setPolyfill(this.polyfills.get(feature.getName()));
        }
    }

    private List<Feature> sortByDependency(Map<String, Feature> featureSet) {
        return this.sortedPolyfills.stream().filter(featureSet::containsKey).map(featureSet::get).collect(Collectors.toList());
    }

    private List<String> getDependencySortedPolyfills(Map<String, Polyfill> polyfillMap) {
        TSort dependencyGraph = new TSort();
        for (Polyfill polyfill : polyfillMap.values()) {
            String polyfillName = polyfill.getName();
            dependencyGraph.addRelation(polyfillName, null);
            polyfill.getDependencies().stream().filter(polyfillMap::containsKey).forEach(dependency -> dependencyGraph.addRelation((String)dependency, polyfillName));
        }
        return dependencyGraph.sort();
    }

    private boolean isUserAgentSupported(UserAgent userAgent) {
        if (userAgent == null) {
            return false;
        }
        String baselineVersion = this.browserBaselines.get(userAgent.getFamily());
        return baselineVersion != null && this.versionChecker.isVersionInRange(userAgent.getVersion(), baselineVersion);
    }

    private void filterForTargetingUA(Map<String, Feature> featureSet, UserAgent userAgent, boolean doLoadOnUnknownUA) {
        if (userAgent == null) {
            return;
        }
        String clientBrowser = userAgent.getFamily();
        String clientUAVersion = userAgent.getVersion();
        boolean unknownUALoadPolyfill = !this.isUserAgentSupported(userAgent) && doLoadOnUnknownUA;
        featureSet.values().removeIf(feature -> {
            boolean isFeatureNeededForUA = false;
            Polyfill polyfill = this.polyfills.get(feature.getName());
            if (polyfill != null) {
                String requiredVersion = polyfill.getBrowserRequirement(clientBrowser);
                boolean versionIsInRange = requiredVersion != null && this.versionChecker.isVersionInRange(clientUAVersion, requiredVersion);
                isFeatureNeededForUA = feature.isAlways() || versionIsInRange || unknownUALoadPolyfill;
            }
            return !isFeatureNeededForUA;
        });
    }

    private void filterExcludes(Map<String, Feature> featureSet, Set<String> excludes) {
        featureSet.keySet().removeIf(excludes::contains);
    }

    private List<Feature> getAllFeatures(Feature featureAll) {
        return this.polyfills.keySet().stream().map(featureName -> new Feature((String)featureName, featureAll)).collect(Collectors.toList());
    }

    private List<Feature> getFromAlias(Feature feature) {
        if ("all".equals(feature.getName())) {
            return this.getAllFeatures(feature);
        }
        List<String> featureGroup = this.aliases.get(feature.getName());
        if (featureGroup != null) {
            return featureGroup.stream().map(featureName -> new Feature((String)featureName, feature)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<Feature> getDependencies(Feature feature) {
        Polyfill polyfill = this.polyfills.get(feature.getName());
        if (polyfill != null) {
            return polyfill.getDependencies().stream().map(featureName -> new Feature((String)featureName, feature)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void resolveAlias(Map<String, Feature> featureSet) {
        this.resolveFeatures(featureSet, this::getFromAlias, true);
    }

    private void resolveDependencies(Map<String, Feature> featureSet) {
        this.resolveFeatures(featureSet, this::getDependencies, false);
    }

    private void resolveFeatures(Map<String, Feature> featureSet, Function<Feature, List<Feature>> resolveFn, boolean removeResolvedFeature) {
        LinkedList<String> featuresQueue = new LinkedList<String>(featureSet.keySet());
        while (!featuresQueue.isEmpty()) {
            String name = (String)featuresQueue.remove();
            List<Feature> resolvedFeatures = resolveFn.apply(featureSet.get(name));
            for (Feature newFeature : resolvedFeatures) {
                String newName = newFeature.getName();
                if (featureSet.containsKey(newName)) {
                    Feature existingFeature = featureSet.get(newName);
                    existingFeature.copyFlags(newFeature);
                    existingFeature.copyRequiredBys(newFeature);
                    continue;
                }
                featureSet.put(newName, newFeature);
                featuresQueue.add(newName);
            }
            if (resolvedFeatures.isEmpty() || !removeResolvedFeature) continue;
            featureSet.remove(name);
        }
    }
}

