/*
 * Decompiled with CFR 0.152.
 */
package org.polyfillservice.api.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.polyfillservice.api.interfaces.VersionUtilService;
import org.springframework.stereotype.Service;

@Service(value="semver")
class SemVerUtilService
implements VersionUtilService {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)((\\.\\d+)+)?");
    private static final Pattern RANGE_PATTERN = Pattern.compile("(\\d+|\\*)\\s*-\\s*(\\d+|\\*)");
    private static final Pattern BOUNDARY_PATTERN = Pattern.compile("((<|>)(=)?)((\\d+)((\\.\\d+)+)?)");
    private static final int MAX_VERSION_GROUPS = 3;
    private static final String VERSION_DELIMITER_REGEX = "\\.";

    SemVerUtilService() {
    }

    @Override
    public boolean isVersionInRange(String checkVersion, String range) {
        if (this.isAnyVersionAllowed(range = range.replace(" ", ""))) {
            return true;
        }
        Matcher matcher = RANGE_PATTERN.matcher(range);
        if (matcher.find()) {
            String rangeMin = matcher.group(1);
            String rangeMax = matcher.group(2);
            return this.compareVersionRange(checkVersion, ">=", rangeMin) && this.compareVersionRange(checkVersion, "<=", rangeMax);
        }
        matcher = BOUNDARY_PATTERN.matcher(range);
        if (matcher.find()) {
            String comparator = matcher.group(1);
            String upperOrLowerBound = matcher.group(4);
            return this.compareVersionRange(checkVersion, comparator, upperOrLowerBound);
        }
        matcher = VERSION_PATTERN.matcher(range);
        if (matcher.find()) {
            return this.compareVersionRange(checkVersion, "==", range);
        }
        return false;
    }

    private boolean isAnyVersionAllowed(String range) {
        return range.equals("*");
    }

    private boolean compareVersionRange(String checkVersion, String comparator, String range) {
        List<String> checkGroups = this.parseVersionToList(checkVersion, "0");
        List<String> rangeGroups = this.parseVersionToList(range);
        if (rangeGroups.size() > checkGroups.size()) {
            return false;
        }
        char mainComparator = comparator.charAt(0);
        for (int i = 0; i < rangeGroups.size(); ++i) {
            if (this.isAnyVersionAllowed(rangeGroups.get(i))) {
                return true;
            }
            int diff = Integer.parseInt(checkGroups.get(i)) - Integer.parseInt(rangeGroups.get(i));
            if (mainComparator == '<') {
                if (diff < 0) {
                    return true;
                }
                if (diff <= 0) continue;
                return false;
            }
            if (mainComparator == '>') {
                if (diff > 0) {
                    return true;
                }
                if (diff >= 0) continue;
                return false;
            }
            if (mainComparator != '=' || diff == 0) continue;
            return false;
        }
        return comparator.length() == 2;
    }

    private List<String> parseVersionToList(String version, String filler) {
        List<String> versionGroups = Arrays.asList(version.split(VERSION_DELIMITER_REGEX));
        if (filler != null && 3 > versionGroups.size()) {
            versionGroups = new ArrayList<String>(versionGroups);
            for (int missingGroups = 3 - versionGroups.size(); missingGroups > 0; --missingGroups) {
                versionGroups.add(filler);
            }
        }
        return versionGroups;
    }

    private List<String> parseVersionToList(String version) {
        return this.parseVersionToList(version, null);
    }
}

