/*
 * Decompiled with CFR 0.152.
 */
package org.polyfillservice.api.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.uadetector.ReadableUserAgent;
import net.sf.uadetector.UserAgentStringParser;
import net.sf.uadetector.VersionNumber;
import net.sf.uadetector.service.UADetectorServiceFactory;
import org.polyfillservice.api.components.LRUCache;
import org.polyfillservice.api.interfaces.UserAgent;
import org.polyfillservice.api.interfaces.UserAgentParserService;
import org.springframework.stereotype.Service;

@Service(value="uadetector")
class UADetectorAdapterParserService
implements UserAgentParserService {
    private static final int MAX_UA_STRING_LENGTH = 300;
    private static final int MAX_NORMALIZED_UA_LENGTH = 22;
    private final LRUCache<String, UserAgent> cache = new LRUCache(5000);
    private final UserAgentStringParser uaParser = UADetectorServiceFactory.getResourceModuleParser();
    private final Pattern normalizePattern = Pattern.compile("^(\\w+)\\/(\\d+(\\.\\d+(\\.\\d+)?)?)$");
    private final Pattern simpleVersion = Pattern.compile("Version/([0-9a-z\\+\\-\\.]+)");
    private final UserAgent unknownUA = new UserAgentImpl("unknown", "0.0.0");
    private final UserAgentMapper uaMapper = new UserAgentMapper();

    UADetectorAdapterParserService() {
    }

    @Override
    public UserAgent parse(String uaString) {
        String simpleVersion;
        if (uaString == null) {
            return this.unknownUA;
        }
        UserAgent normalizedUA = this.parseNormalized(uaString = uaString.trim());
        if (normalizedUA != null) {
            return normalizedUA;
        }
        if (this.cache.containsKey(uaString = this.preprocessUserAgentString(uaString))) {
            return (UserAgent)this.cache.get(uaString);
        }
        ReadableUserAgent readableUA = this.uaParser.parse(uaString);
        String uaVersion = this.getVersionString(readableUA.getVersionNumber());
        String osVersion = this.getVersionString(readableUA.getOperatingSystem().getVersionNumber());
        if ("0.0".equals(uaVersion) && (simpleVersion = this.getSimpleVersion(uaString)) != null) {
            uaVersion = simpleVersion;
        }
        UserAgent userAgent = this.uaMapper.resolve(readableUA.getName(), uaVersion, osVersion);
        this.cache.put(uaString, userAgent);
        return userAgent;
    }

    private UserAgent parseNormalized(String uaString) {
        Matcher uaMatcher;
        if (uaString.length() < 22 && (uaMatcher = this.normalizePattern.matcher(uaString)).find()) {
            String family = uaMatcher.group(1);
            String versionString = uaMatcher.group(2);
            return new UserAgentImpl(family, versionString);
        }
        return null;
    }

    private String preprocessUserAgentString(String uaString) {
        uaString = uaString.substring(0, Math.min(300, uaString.length()));
        uaString = uaString.replaceAll("((CriOS|OPiOS)\\/(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)|(FxiOS\\/(\\d+)\\.(\\d+)))", "");
        uaString = uaString.replaceAll("Chrome.+Edge/", "msie ");
        return uaString;
    }

    private String getVersionString(VersionNumber vn) {
        String major = vn.getMajor().isEmpty() ? "0" : vn.getMajor();
        String minor = vn.getMinor().isEmpty() ? "0" : vn.getMinor();
        return major + "." + minor;
    }

    private String getSimpleVersion(String uaString) {
        Matcher matcher = this.simpleVersion.matcher(uaString);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private class UserAgentMapper {
        private Map<String, Object> aliases = ImmutableMap.builder().put((Object)"blackberry webkit", (Object)"bb").put((Object)"blackberry", (Object)"bb").put((Object)"blackberry os", (Object)"bb").put((Object)"blackberry browser", (Object)"bb").put((Object)"pale moon (firefox variant)", (Object)"firefox").put((Object)"firefox mobile", (Object)"firefox_mob").put((Object)"firefox (namoroka)", (Object)"firefox").put((Object)"firefox shiretoko", (Object)"firefox").put((Object)"firefox minefield", (Object)"firefox").put((Object)"firefox alpha", (Object)"firefox").put((Object)"firefox beta", (Object)"firefox").put((Object)"microb", (Object)"firefox").put((Object)"mozilladeveloperpreview", (Object)"firefox").put((Object)"iceweasel", (Object)"firefox").put((Object)"opera tablet", (Object)"opera").put((Object)"opera mobile", (Object)"op_mob").put((Object)"opera mini", (Object)"op_mini").put((Object)"chrome mobile", (Object)"chrome").put((Object)"chrome frame", (Object)"chrome").put((Object)"chromium", (Object)"chrome").put((Object)"ie mobile", (Object)"ie_mob").put((Object)"ie large screen", (Object)"ie").put((Object)"internet explorer", (Object)"ie").put((Object)"chrome mobile ios", (Object)"ios_chr").put((Object)"mobile safari", (Object)"ios_saf").put((Object)"iphone", (Object)"ios_saf").put((Object)"iphone simulator", (Object)"ios_saf").put((Object)"mobile safari uiwebview", (Object)"ios_saf").put((Object)"samsung internet", (Object)"samsung_mob").put((Object)"uc browser", (Object)ImmutableMap.builder().put((Object)"9.9", (Object)ImmutableList.of((Object)"ie", (Object)"10")).build()).put((Object)"yandex.browser", (Object)ImmutableMap.builder().put((Object)"14.10", (Object)ImmutableList.of((Object)"chrome", (Object)"37.0")).put((Object)"14.8", (Object)ImmutableList.of((Object)"chrome", (Object)"36.0")).put((Object)"14.7", (Object)ImmutableList.of((Object)"chrome", (Object)"35.0")).put((Object)"14.5", (Object)ImmutableList.of((Object)"chrome", (Object)"34.0")).put((Object)"14.4", (Object)ImmutableList.of((Object)"chrome", (Object)"33.0")).put((Object)"14.2", (Object)ImmutableList.of((Object)"chrome", (Object)"32.0")).put((Object)"13.12", (Object)ImmutableList.of((Object)"chrome", (Object)"30.0")).put((Object)"13.10", (Object)ImmutableList.of((Object)"chrome", (Object)"28.0")).build()).build();

        private UserAgentMapper() {
        }

        public UserAgent resolve(String family, String version, String osVersion) {
            Object mapObject = this.aliases.get(family = family.toLowerCase());
            if (mapObject instanceof Map) {
                Map aliasMap = (Map)mapObject;
                if ((mapObject = aliasMap.get(version)) instanceof List) {
                    List uaGroups = (List)mapObject;
                    family = (String)uaGroups.get(0);
                    version = (String)uaGroups.get(1);
                }
            } else if (mapObject instanceof String && "ios_saf".equals(family = (String)mapObject)) {
                version = osVersion;
            }
            return new UserAgentImpl(family, version);
        }
    }

    private class UserAgentImpl
    implements UserAgent {
        private String family;
        private VersionNumber version;

        private UserAgentImpl(String family, String versionString) {
            this.family = family;
            this.version = VersionNumber.parseVersion((String)this.zeroPatchVersion(versionString));
        }

        @Override
        public String getFamily() {
            return this.family;
        }

        @Override
        public String getVersion() {
            return this.version.toVersionString();
        }

        @Override
        public String getMajorVersion() {
            return this.version.getMajor();
        }

        @Override
        public String getMinorVersion() {
            return this.version.getMinor();
        }

        @Override
        public String toString() {
            return this.getFamily() + "/" + this.getVersion();
        }

        private String zeroPatchVersion(String versionString) {
            versionString = versionString.isEmpty() ? "0.0.0" : versionString + ".0.0";
            VersionNumber versionNumber = VersionNumber.parseVersion((String)versionString);
            return versionNumber.getMajor() + "." + versionNumber.getMinor() + ".0";
        }
    }
}

