/*
 * Decompiled with CFR 0.152.
 */
package org.polyfillservice.api.services;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import org.polyfillservice.api.components.ServiceConfig;
import org.polyfillservice.api.interfaces.PolyfillServiceConfigLocation;
import org.polyfillservice.api.interfaces.ServiceConfigLoaderService;
import org.springframework.stereotype.Service;

@Service(value="xml")
public class XmlServiceConfigLoaderService
implements ServiceConfigLoaderService {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ServiceConfig loadConfig(PolyfillServiceConfigLocation serviceConfigLocation) {
        if (serviceConfigLocation == null) return new ServiceConfig.Builder().build();
        XStream xStream = this.getConfiguredXStream();
        try (InputStream is = serviceConfigLocation.getInputStream();){
            ServiceConfig serviceConfig = (ServiceConfig)xStream.fromXML(is);
            return serviceConfig;
        }
        catch (IOException e) {
            System.err.println("Error trying to load service configuration file! Will use default configurations.");
            e.printStackTrace();
        }
        return new ServiceConfig.Builder().build();
    }

    private XStream getConfiguredXStream() {
        XStream xstream = new XStream();
        xstream.alias("configurations", ServiceConfig.class);
        xstream.alias("polyfill", String.class);
        xstream.aliasField("load-on-unknown-ua", ServiceConfig.class, "loadOnUnknownUA");
        return xstream;
    }
}

