/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.polypheny.jdbc.BidirectionalScrollable;
import org.polypheny.jdbc.PrismInterfaceClient;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.ResultFetcher;
import org.polypheny.jdbc.dependency.prism.Frame;
import org.polypheny.jdbc.properties.PolyphenyResultSetProperties;
import org.polypheny.jdbc.types.TypedValue;
import org.polypheny.jdbc.utils.TypedValueUtils;

public class BidirectionalScroller
implements BidirectionalScrollable<List<TypedValue>> {
    private static final int INDEX_BEFORE_FIRST = -1;
    private static final int DEFAULT_PREFETCH_COUNT = 20;
    private List<List<TypedValue>> values;
    private List<TypedValue> currentRow;
    private ResultFetcher resultFetcher;
    private PolyphenyResultSetProperties properties;
    private Thread fetcherThread;
    int currentIndex;

    public BidirectionalScroller(Frame frame, PrismInterfaceClient client, int statementId, PolyphenyResultSetProperties properties, int fetchTimeout) {
        this.values = new ArrayList<List<TypedValue>>(TypedValueUtils.buildRows(frame.getRelationalFrame().getRowsList()));
        if (properties.getLargeMaxRows() != 0L && (long)this.values.size() > properties.getLargeMaxRows()) {
            this.values.subList(this.longToInt(properties.getLargeMaxRows()), this.values.size()).clear();
        }
        this.resultFetcher = new ResultFetcher(client, statementId, properties, this.values.size(), fetchTimeout);
        this.resultFetcher.setLast(frame.getIsLast());
        this.currentIndex = -1;
        this.properties = properties;
    }

    protected int longToInt(long longNumber) {
        return Math.toIntExact(longNumber);
    }

    private boolean fetchUpTo(int rowIndex) throws InterruptedException {
        while (this.values.size() < rowIndex) {
            if (this.resultFetcher.isLast()) {
                return false;
            }
            this.fetcherThread = new Thread(this.resultFetcher);
            this.fetcherThread.start();
            this.fetcherThread.join();
        }
        return true;
    }

    @Override
    public void fetchAllAndSync() throws InterruptedException {
        this.fetchAll();
        this.syncFetch();
    }

    private void fetchAll() throws InterruptedException {
        while (!this.resultFetcher.isLast()) {
            this.fetcherThread = new Thread(this.resultFetcher);
            this.fetcherThread.start();
            this.fetcherThread.join();
        }
    }

    @Override
    public boolean absolute(int rowIndex) throws PrismInterfaceServiceException {
        try {
            if (this.rowToIndex(rowIndex) == this.currentIndex) {
                return true;
            }
            if (rowIndex < 0) {
                this.fetchAll();
                this.currentIndex = this.values.size() + rowIndex;
                if (this.currentIndex < 1) {
                    this.currentIndex = -1;
                    this.currentRow = null;
                    return false;
                }
                this.currentRow = this.values.get(this.currentIndex);
                return true;
            }
            if (rowIndex == 0) {
                this.currentIndex = -1;
                this.currentRow = null;
                return true;
            }
            if (rowIndex <= this.values.size()) {
                this.currentIndex = this.rowToIndex(rowIndex);
                this.currentRow = this.values.get(this.currentIndex);
                return true;
            }
            if (this.fetchUpTo(rowIndex)) {
                this.currentIndex = this.rowToIndex(rowIndex);
                this.currentRow = this.values.get(this.currentIndex);
                this.considerPrefetch();
                return true;
            }
            this.currentIndex = this.values.size();
            this.currentRow = null;
            return false;
        }
        catch (InterruptedException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DRIVER_THREADING_ERROR, "Fetching of more rows failed", (Throwable)e);
        }
    }

    private int rowToIndex(int rowIndex) {
        return rowIndex - 1;
    }

    private int indexToRow(int index) {
        return index + 1;
    }

    @Override
    public boolean relative(int offset) throws PrismInterfaceServiceException {
        try {
            if (offset == 0) {
                return this.currentRow != null;
            }
            if (this.currentIndex + offset < 0) {
                this.currentIndex = -1;
                this.currentRow = null;
                return false;
            }
            if (this.currentIndex + offset < this.values.size()) {
                this.currentIndex += offset;
                this.currentRow = this.values.get(this.currentIndex);
                return true;
            }
            if (this.currentIndex + offset >= this.values.size()) {
                if (this.fetchUpTo(this.indexToRow(this.currentIndex + offset))) {
                    this.currentIndex += offset;
                    this.currentRow = this.values.get(this.currentIndex);
                    this.considerPrefetch();
                    return true;
                }
                this.currentIndex = this.values.size();
                this.currentRow = null;
                return false;
            }
        }
        catch (InterruptedException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DRIVER_THREADING_ERROR, "Fetching more rows failed.", (Throwable)e);
        }
        throw new PrismInterfaceServiceException("Should never be thrown!");
    }

    @Override
    public boolean previous() throws PrismInterfaceServiceException {
        return this.relative(-1);
    }

    @Override
    public void beforeFirst() throws PrismInterfaceServiceException {
        this.absolute(0);
    }

    @Override
    public void afterLast() {
        this.currentIndex = this.values.size();
        this.currentRow = null;
    }

    @Override
    public boolean first() {
        this.currentRow = null;
        this.currentIndex = -1;
        if (this.values.isEmpty()) {
            return false;
        }
        this.currentIndex = 0;
        this.currentRow = this.values.get(this.currentIndex);
        return true;
    }

    @Override
    public boolean last() throws InterruptedException {
        this.currentRow = null;
        if (this.resultFetcher.isLast()) {
            this.currentIndex = this.values.size() - 1;
            this.currentRow = this.values.get(this.currentIndex);
            return true;
        }
        this.fetchAll();
        this.currentIndex = this.values.size() - 1;
        this.currentRow = this.values.get(this.currentIndex);
        return true;
    }

    @Override
    public boolean next() throws PrismInterfaceServiceException {
        try {
            this.considerPrefetch();
            this.syncFetch();
            ++this.currentIndex;
            this.currentRow = this.values.get(this.currentIndex);
            return this.currentRow != null;
        }
        catch (InterruptedException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DRIVER_THREADING_ERROR, "Fetching more rows from server failed.", (Throwable)e);
        }
    }

    private void considerPrefetch() {
        int prefetch_count = Math.min(20, this.properties.getStatementFetchSize());
        if (this.values.size() > prefetch_count) {
            return;
        }
        if (this.resultFetcher.isLast()) {
            return;
        }
        if (this.fetcherThread != null) {
            return;
        }
        this.fetcherThread = new Thread(this.resultFetcher);
        this.fetcherThread.start();
    }

    private void syncFetch() throws InterruptedException {
        if (this.fetcherThread == null) {
            return;
        }
        if (this.currentIndex != this.values.size() - 1) {
            return;
        }
        this.fetcherThread.join();
        this.fetcherThread = null;
        this.values.addAll(this.resultFetcher.getFetchedValues());
    }

    @Override
    public List<TypedValue> current() {
        return this.currentRow;
    }

    @Override
    public void close() {
        if (this.fetcherThread == null) {
            return;
        }
        this.fetcherThread.interrupt();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.currentIndex == -1;
    }

    @Override
    public boolean isAfterLast() {
        return this.values.isEmpty() || this.currentIndex == this.values.size();
    }

    @Override
    public boolean isFirst() {
        return this.currentIndex == 0;
    }

    @Override
    public boolean isLast() {
        return this.currentIndex == this.values.size() - 1;
    }

    @Override
    public int getRow() {
        return this.indexToRow(this.currentIndex);
    }

    @Override
    public boolean hasCurrent() {
        return this.currentRow != null;
    }
}

