/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.org.slf4j.Logger;
import org.polypheny.jdbc.dependency.org.slf4j.LoggerFactory;
import org.polypheny.jdbc.properties.DriverProperties;
import org.polypheny.jdbc.properties.PropertyUtils;

public class ConnectionString {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionString.class);
    private String host;
    private int port;
    private final Map<String, String> parameters;

    public ConnectionString(String url) throws SQLException {
        this.parameters = new HashMap<String, String>();
        this.parseUrl(url);
    }

    public ConnectionString(String url, Properties parameters) throws SQLException {
        this.parameters = this.importPropertiesMap(parameters);
        this.parseUrl(url);
    }

    public String getUser() {
        return this.parameters.get(PropertyUtils.getUSERNAME_KEY());
    }

    private Map<String, String> importPropertiesMap(Properties properties) {
        if (properties == null) {
            return new HashMap<String, String>();
        }
        return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
    }

    private void parseUrl(String url) throws SQLException {
        int schemeSpecificPartStartIndex;
        if (url == null) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.URL_PARSING_INVALID, "URL must no be null.");
        }
        if (!url.startsWith(DriverProperties.getDRIVER_URL_SCHEMA())) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.URL_PARSING_INVALID, "Invalid driver schema.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Parsing url: \"{}\"", (Object)url);
        }
        if ((schemeSpecificPartStartIndex = url.indexOf("//")) == -1) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.URL_PARSING_INVALID, "Invalid url format.");
        }
        this.host = PropertyUtils.getDEFAULT_HOST();
        this.port = PropertyUtils.getDEFAULT_PORT();
        if ((url = url.substring(schemeSpecificPartStartIndex)).equals("//")) {
            return;
        }
        try {
            URI uri = new URI(url);
            if (uri.getQuery() != null) {
                this.parseParameters(uri.getQuery());
            }
            if (uri.getHost() != null) {
                this.host = uri.getHost();
            }
            if (uri.getPort() != -1) {
                this.port = uri.getPort();
            }
            if (uri.getUserInfo() != null) {
                String[] userAndPassword = uri.getUserInfo().split(":", 2);
                this.parameters.put(PropertyUtils.getUSERNAME_KEY(), userAndPassword[0]);
                if (userAndPassword.length > 1) {
                    this.parameters.put(PropertyUtils.getPASSWORD_KEY(), userAndPassword[1]);
                }
            }
            if (!uri.getPath().isEmpty() && uri.getPath().length() > 1) {
                this.parameters.put(PropertyUtils.getNAMESPACE_KEY(), uri.getPath().substring(1));
            }
        }
        catch (URISyntaxException e) {
            throw new PrismInterfaceServiceException(e);
        }
    }

    private void parseParameters(String parameters) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("Parsing url parameters: \"{}\"", (Object)parameters);
        }
        StringTokenizer tokenizer = new StringTokenizer(parameters, "&");
        while (tokenizer.hasMoreTokens()) {
            String[] keyValuePair = tokenizer.nextToken().split("=");
            if (keyValuePair.length != 2) {
                throw new PrismInterfaceServiceException(PrismInterfaceErrors.URL_PARSING_INVALID, "Invalid parameter format.");
            }
            if (keyValuePair[0].isEmpty() || keyValuePair[1].isEmpty()) {
                throw new PrismInterfaceServiceException(PrismInterfaceErrors.URL_PARSING_INVALID, "Invalid parameter format.");
            }
            try {
                String value = URLDecoder.decode(keyValuePair[1], StandardCharsets.UTF_8.name());
                this.parameters.put(keyValuePair[0], value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
    }

    public String getTarget() {
        return this.host + ":" + this.port;
    }

    public Map<String, String> getParameters() {
        String property = this.parameters.get(PropertyUtils.getPASSWORD_KEY());
        if (property != null && property.equals(DriverProperties.getBACKDOR_STRING()) && DriverProperties.isBACKDOOR_ENABLED()) {
            this.parameters.put(PropertyUtils.getPASSWORD_KEY(), "");
        }
        return this.parameters;
    }

    public String getParameter(String parameterName) {
        return this.parameters.get(parameterName);
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }
}

