/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.polypheny.jdbc.PrismInterfaceClient;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.ResultFetcher;
import org.polypheny.jdbc.Scrollable;
import org.polypheny.jdbc.dependency.prism.Frame;
import org.polypheny.jdbc.properties.PolyphenyResultSetProperties;
import org.polypheny.jdbc.types.TypedValue;
import org.polypheny.jdbc.utils.TypedValueUtils;

public class ForwardOnlyScroller
implements Scrollable<List<TypedValue>> {
    private static final int DEFAULT_PREFETCH_COUNT = 20;
    private static final int INDEX_BEFORE_FIRST = -1;
    private LinkedList<List<TypedValue>> values;
    private List<TypedValue> currentRow;
    private ResultFetcher resultFetcher;
    private Thread fetcherThread;
    private PolyphenyResultSetProperties properties;
    private int baseIndex;

    public ForwardOnlyScroller(Frame frame, PrismInterfaceClient client, int statementId, PolyphenyResultSetProperties properties, int fetchTimeout) {
        this.values = new LinkedList<List<TypedValue>>(TypedValueUtils.buildRows(frame.getRelationalFrame().getRowsList()));
        if (properties.getLargeMaxRows() != 0L && (long)this.values.size() > properties.getLargeMaxRows()) {
            this.values.subList(this.longToInt(properties.getLargeMaxRows()), this.values.size()).clear();
        }
        this.resultFetcher = new ResultFetcher(client, statementId, properties, this.values.size(), fetchTimeout);
        this.resultFetcher.setLast(frame.getIsLast());
        this.properties = properties;
        this.baseIndex = -1;
    }

    protected int longToInt(long longNumber) {
        return Math.toIntExact(longNumber);
    }

    @Override
    public void fetchAllAndSync() throws InterruptedException {
        if (this.resultFetcher.isLast()) {
            return;
        }
        if (this.fetcherThread != null) {
            return;
        }
        while (!this.resultFetcher.isLast()) {
            this.fetcherThread = new Thread(this.resultFetcher);
            this.fetcherThread.start();
            this.syncFetch();
        }
    }

    @Override
    public boolean next() throws PrismInterfaceServiceException {
        try {
            this.considerPrefetch();
            this.syncFetchIfEmpty();
            this.currentRow = this.values.poll();
            if (this.currentRow == null) {
                return false;
            }
            ++this.baseIndex;
            return true;
        }
        catch (InterruptedException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DRIVER_THREADING_ERROR, "Fetching more columns from server filed.", (Throwable)e);
        }
    }

    private void considerPrefetch() {
        int prefetch_count = Math.min(20, this.properties.getStatementFetchSize());
        if (this.values.size() > prefetch_count) {
            return;
        }
        if (this.resultFetcher.isLast()) {
            return;
        }
        if (this.fetcherThread != null) {
            return;
        }
        this.fetcherThread = new Thread(this.resultFetcher);
        this.fetcherThread.start();
    }

    private void syncFetchIfEmpty() throws InterruptedException {
        if (!this.values.isEmpty()) {
            return;
        }
        this.syncFetch();
    }

    private void syncFetch() throws InterruptedException {
        if (this.fetcherThread == null) {
            return;
        }
        this.fetcherThread.join();
        this.fetcherThread = null;
        this.values.addAll(this.resultFetcher.getFetchedValues());
    }

    @Override
    public List<TypedValue> current() {
        if (this.currentRow == null) {
            throw new NoSuchElementException("Illegal cursor position.");
        }
        return this.currentRow;
    }

    @Override
    public void close() {
        if (this.fetcherThread == null) {
            return;
        }
        this.fetcherThread.interrupt();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.baseIndex == -1;
    }

    @Override
    public boolean isAfterLast() {
        return this.values.isEmpty() && this.currentRow == null;
    }

    @Override
    public boolean isFirst() {
        return this.baseIndex == 0;
    }

    @Override
    public boolean isLast() {
        return this.values.isEmpty() && this.currentRow != null;
    }

    @Override
    public int getRow() {
        if (this.isBeforeFirst() || this.isAfterLast()) {
            return 0;
        }
        return this.baseIndex + 1;
    }

    @Override
    public boolean hasCurrent() {
        return this.currentRow != null;
    }
}

