/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import org.polypheny.jdbc.PolyphenyPreparedStatement;
import org.polypheny.jdbc.PolyphenyStatement;
import org.polypheny.jdbc.PrismInterfaceClient;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.prism.PreparedStatementSignature;
import org.polypheny.jdbc.meta.PolyphenyDatabaseMetadata;
import org.polypheny.jdbc.multimodel.PolyStatement;
import org.polypheny.jdbc.properties.PolyphenyConnectionProperties;
import org.polypheny.jdbc.properties.PolyphenyStatementProperties;
import org.polypheny.jdbc.properties.PropertyUtils;
import org.polypheny.jdbc.types.PolyArray;
import org.polypheny.jdbc.types.PolyBlob;
import org.polypheny.jdbc.types.PolyClob;
import org.polypheny.jdbc.types.PolyStruct;

public class PolyConnection
implements Connection {
    private PolyphenyConnectionProperties properties;
    private PolyphenyDatabaseMetadata databaseMetaData;
    private boolean isClosed;
    private boolean hasRunningTransaction;
    private Set<Statement> openStatements;
    private Map<String, Class<?>> typeMap;

    private void throwIfClosed() throws SQLException {
        if (this.isClosed) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.CONNECTION_LOST, "Illegal operation on closed connection.");
        }
    }

    private void throwIfAutoCommit() throws SQLException {
        if (!this.isStrict()) {
            return;
        }
        if (this.properties.isAutoCommit()) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Illegal operation on auto committing connection.");
        }
    }

    private void throwIfRunningTransaction() throws SQLException {
        if (this.hasRunningTransaction) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Illegal operation during running transaction.");
        }
    }

    public PolyConnection(PolyphenyConnectionProperties connectionProperties, PolyphenyDatabaseMetadata databaseMetaData) {
        this.properties = connectionProperties;
        databaseMetaData.setConnection(this);
        this.databaseMetaData = databaseMetaData;
        this.openStatements = new HashSet<Statement>();
        this.typeMap = new HashMap();
        this.isClosed = false;
    }

    public boolean isStrict() {
        return this.properties.isStrict();
    }

    public void startTracking(Statement statement) {
        this.openStatements.add(statement);
    }

    public void endTracking(Statement statement) {
        if (!this.openStatements.contains(statement)) {
            return;
        }
        this.openStatements.remove(statement);
    }

    public int getTimeout() {
        return this.properties.getNetworkTimeout();
    }

    public PrismInterfaceClient getPrismInterfaceClient() {
        return this.properties.getPrismInterfaceClient();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.throwIfClosed();
        PolyphenyStatement statement = new PolyphenyStatement(this, this.properties.toStatementProperties());
        this.startTracking(statement);
        return statement;
    }

    public PolyStatement createPolyStatement() {
        return new PolyStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatementSignature signature = this.getPrismInterfaceClient().prepareIndexedStatement(this.properties.getNamespaceName(), PropertyUtils.getSQL_LANGUAGE_NAME(), sql, this.getTimeout());
        PolyphenyPreparedStatement statement = new PolyphenyPreparedStatement(this, this.properties.toStatementProperties(), signature);
        this.startTracking(statement);
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.throwIfClosed();
        if (this.hasRunningTransaction) {
            this.commit();
        }
        this.properties.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.throwIfClosed();
        return this.properties.isAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.throwIfClosed();
        this.throwIfAutoCommit();
        this.getPrismInterfaceClient().commitTransaction(this.getNetworkTimeout());
        this.hasRunningTransaction = false;
    }

    @Override
    public void rollback() throws SQLException {
        this.throwIfClosed();
        this.throwIfAutoCommit();
        this.getPrismInterfaceClient().rollbackTransaction(this.getNetworkTimeout());
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        for (Statement openStatement : new HashSet<Statement>(this.openStatements)) {
            openStatement.close();
        }
        this.getPrismInterfaceClient().unregister(this.properties.getNetworkTimeout());
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.throwIfClosed();
        return this.databaseMetaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.throwIfClosed();
        this.throwIfRunningTransaction();
        this.properties.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.throwIfClosed();
        return this.properties.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.throwIfClosed();
        this.properties.setCatalogName(catalog);
    }

    @Override
    public String getCatalog() {
        return this.properties.getCatalogName();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.throwIfClosed();
        this.properties.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.throwIfClosed();
        return this.properties.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwIfClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfClosed();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwIfClosed();
        PropertyUtils.throwIfInvalid(resultSetType, resultSetConcurrency);
        PolyphenyStatementProperties statementProperties = this.properties.toStatementProperties(resultSetType, resultSetConcurrency);
        return new PolyphenyStatement(this, statementProperties);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwIfClosed();
        PropertyUtils.throwIfInvalid(resultSetType, resultSetConcurrency);
        PolyphenyStatementProperties statementProperties = this.properties.toStatementProperties(resultSetType, resultSetConcurrency);
        PreparedStatementSignature signature = this.getPrismInterfaceClient().prepareIndexedStatement(this.properties.getNamespaceName(), PropertyUtils.getSQL_LANGUAGE_NAME(), sql, this.getTimeout());
        return new PolyphenyPreparedStatement(this, statementProperties, signature);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwIfClosed();
        PropertyUtils.throwIfInvalid(resultSetType, resultSetConcurrency);
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.typeMap = map;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.throwIfClosed();
        this.properties.setResultSetHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.throwIfClosed();
        return this.properties.getResultSetHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfClosed();
        PropertyUtils.throwIfInvalid(resultSetType, resultSetConcurrency, resultSetHoldability);
        PolyphenyStatementProperties statementProperties = this.properties.toStatementProperties(resultSetType, resultSetConcurrency, resultSetHoldability);
        PolyphenyStatement statement = new PolyphenyStatement(this, statementProperties);
        this.openStatements.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfClosed();
        PropertyUtils.throwIfInvalid(resultSetType, resultSetConcurrency, resultSetHoldability);
        PolyphenyStatementProperties statementProperties = this.properties.toStatementProperties(resultSetType, resultSetConcurrency, resultSetHoldability);
        PreparedStatementSignature signature = this.getPrismInterfaceClient().prepareIndexedStatement(this.properties.getNamespaceName(), PropertyUtils.getSQL_LANGUAGE_NAME(), sql, this.getTimeout());
        PolyphenyPreparedStatement statement = new PolyphenyPreparedStatement(this, statementProperties, signature);
        this.openStatements.add(statement);
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfClosed();
        PropertyUtils.throwIfInvalid(resultSetType, resultSetConcurrency, resultSetHoldability);
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwIfClosed();
        if (!PropertyUtils.isValidAutogeneratedKeys(autoGeneratedKeys)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal argument for autogenerated keys");
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.throwIfClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.throwIfClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        return new PolyClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new PolyBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return new PolyClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal argument for timeout");
        }
        return this.getPrismInterfaceClient().checkConnection(timeout * 1000);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Properties clientInfoProperties = this.getClientInfo();
        clientInfoProperties.setProperty(name, value);
        try {
            this.getPrismInterfaceClient().setClientInfoProperties(clientInfoProperties, this.properties.getNetworkTimeout());
        }
        catch (PrismInterfaceServiceException e) {
            throw new SQLClientInfoException(e.getMessage(), e.getSQLState(), e.getErrorCode(), new HashMap<String, ClientInfoStatus>(), e);
        }
    }

    @Override
    public void setClientInfo(Properties clientInfoProperties) throws SQLClientInfoException {
        try {
            this.getPrismInterfaceClient().setClientInfoProperties(clientInfoProperties, this.properties.getNetworkTimeout());
        }
        catch (PrismInterfaceServiceException e) {
            HashMap failedOptions = new HashMap();
            throw new SQLClientInfoException(e.getMessage(), e.getSQLState(), e.getErrorCode(), new HashMap<String, ClientInfoStatus>(), e);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.getClientInfo().getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLClientInfoException {
        try {
            Properties properties = new Properties();
            properties.putAll(this.getPrismInterfaceClient().getClientInfoProperties(this.getNetworkTimeout()));
            return properties;
        }
        catch (SQLException e) {
            throw new SQLClientInfoException();
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.throwIfClosed();
        return new PolyArray(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.throwIfClosed();
        return new PolyStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.throwIfClosed();
        this.properties.setNamespaceName(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.throwIfClosed();
        return this.properties.getNamespaceName();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.throwIfClosed();
        if (milliseconds < 0) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal argument for timeout");
        }
        this.properties.setNetworkTimeout(milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.throwIfClosed();
        return this.properties.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return aClass.cast(this);
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.WRAPPER_INCORRECT_TYPE, "Not a wrapper for " + aClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) {
        return aClass.isInstance(this);
    }
}

