/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.polypheny.jdbc.PolyConnection;
import org.polypheny.jdbc.PolyphenyResultSet;
import org.polypheny.jdbc.PolyphenyStatement;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.prism.Frame;
import org.polypheny.jdbc.dependency.prism.PreparedStatementSignature;
import org.polypheny.jdbc.dependency.prism.StatementBatchResponse;
import org.polypheny.jdbc.dependency.prism.StatementResult;
import org.polypheny.jdbc.meta.PolyphenyParameterMetaData;
import org.polypheny.jdbc.properties.PolyphenyStatementProperties;
import org.polypheny.jdbc.types.TypedValue;

public class PolyphenyPreparedStatement
extends PolyphenyStatement
implements PreparedStatement {
    private TypedValue[] parameters;
    private List<List<TypedValue>> parameterBatch = new LinkedList<List<TypedValue>>();
    private final PolyphenyParameterMetaData parameterMetaData;

    public PolyphenyPreparedStatement(PolyConnection connection, PolyphenyStatementProperties properties, PreparedStatementSignature statementSignature) throws SQLException {
        super(connection, properties);
        this.statementId = statementSignature.getStatementId();
        this.parameterMetaData = new PolyphenyParameterMetaData(statementSignature);
        this.parameters = this.createParameterList(statementSignature.getParameterMetasCount());
    }

    private void prepareForReExecution() throws SQLException {
        if (this.currentResult != null) {
            this.currentResult.close();
        }
        this.currentUpdateCount = -1L;
    }

    private TypedValue[] createParameterList(int parameterCount) {
        return new TypedValue[parameterCount];
    }

    @Override
    public ResultSet executeQuery(String statement) throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Method should not be called on a prepared statement.");
    }

    @Override
    public int executeUpdate(String statement) throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Method should not be called on a prepared statement.");
    }

    @Override
    public boolean execute(String statement) throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Method should not be called on a prepared statement.");
    }

    @Override
    public long executeLargeUpdate(String sql, int autogeneratedKeys) throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Method should not be called on a prepared statement.");
    }

    @Override
    public int executeUpdate(String sql, int autogeneratedKeys) throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Method should not be called on a prepared statement.");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Method should not be called on a prepared statement.");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Method should not be called on a prepared statement.");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Method should not be called on a prepared statement.");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Method should not be called on a prepared statement.");
    }

    @Override
    public boolean execute(String s, int i) throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Method should not be called on a prepared statement.");
    }

    @Override
    public boolean execute(String s, int[] ints) throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Method should not be called on a prepared statement.");
    }

    @Override
    public boolean execute(String s, String[] strings) throws SQLException {
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Method should not be called on a prepared statement.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            this.throwIfClosed();
            this.prepareForReExecution();
            StatementResult result = this.getClient().executeIndexedStatement(this.statementId, Arrays.asList(this.parameters), this.properties.getFetchSize(), this.getTimeout());
            if (!result.hasFrame()) {
                throw new PrismInterfaceServiceException(PrismInterfaceErrors.RESULT_TYPE_INVALID, "Statement must produce a single ResultSet");
            }
            Frame frame = result.getFrame();
            this.throwIfNotRelational(frame);
            ResultSet resultSet = this.currentResult = new PolyphenyResultSet(this, frame, this.properties.toResultSetProperties());
            return resultSet;
        }
        finally {
            this.clearParameters();
            this.clearParameterBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate() throws SQLException {
        try {
            this.throwIfClosed();
            this.prepareForReExecution();
            StatementResult result = this.getClient().executeIndexedStatement(this.statementId, Arrays.asList(this.parameters), this.properties.getFetchSize(), this.getTimeout());
            if (result.hasFrame()) {
                throw new PrismInterfaceServiceException(PrismInterfaceErrors.RESULT_TYPE_INVALID, "Statement must not produce a ResultSet");
            }
            long l = this.currentUpdateCount = result.getScalar();
            return l;
        }
        finally {
            this.clearParameters();
            this.clearParameterBatch();
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.longToInt(this.executeLargeUpdate());
    }

    private void throwIfOutOfBounds(int parameterIndex) throws SQLException {
        if (parameterIndex < 1) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Index out of bounds.");
        }
        if (parameterIndex > this.parameterMetaData.getParameterCount()) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Index out of bounds.");
        }
    }

    private int indexFromParameterIndex(int parameterIndex) {
        return parameterIndex - 1;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromNull();
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromBoolean(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromByte(x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromShort(x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromInteger(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromLong(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromFloat(x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromDouble(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromBigDecimal(x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromString(x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromBytes(x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromDate(x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromTime(x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromTimestamp(x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromAsciiStream(x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromUnicodeStream(x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromBinaryStream(x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.throwIfClosed();
        this.parameters = this.createParameterList(this.parameterMetaData.getParameterCount());
    }

    private void clearParameterBatch() {
        this.parameterBatch = new LinkedList<List<TypedValue>>();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromObject(x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromObject(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        try {
            this.throwIfClosed();
            this.prepareForReExecution();
            StatementResult result = this.getClient().executeIndexedStatement(this.statementId, Arrays.asList(this.parameters), this.properties.getFetchSize(), this.getTimeout());
            if (!result.hasFrame()) {
                this.currentUpdateCount = result.getScalar();
                boolean bl = false;
                return bl;
            }
            Frame frame = result.getFrame();
            this.throwIfNotRelational(frame);
            this.currentResult = new PolyphenyResultSet(this, frame, this.properties.toResultSetProperties());
            boolean bl = true;
            return bl;
        }
        finally {
            this.clearParameters();
            this.clearParameterBatch();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.throwIfClosed();
        this.parameterBatch.add(Arrays.asList((Object[])this.parameters.clone()));
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        List<Long> scalars = this.executeParameterizedBatch();
        long[] updateCounts = new long[scalars.size()];
        for (int i = 0; i < scalars.size(); ++i) {
            updateCounts[i] = scalars.get(i);
        }
        return updateCounts;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        List<Long> scalars = this.executeParameterizedBatch();
        int[] updateCounts = new int[scalars.size()];
        for (int i = 0; i < scalars.size(); ++i) {
            updateCounts[i] = this.longToInt(scalars.get(i));
        }
        return updateCounts;
    }

    private List<Long> executeParameterizedBatch() throws SQLException {
        this.throwIfClosed();
        try {
            if (this.parameterBatch.isEmpty()) {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                return arrayList;
            }
            StatementBatchResponse status = this.getClient().executeIndexedStatementBatch(this.statementId, this.parameterBatch, this.getTimeout());
            List<Long> list = status.getScalarsList();
            return list;
        }
        finally {
            this.clearParameters();
            this.clearParameterBatch();
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromRef(x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromBlob(x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromClob(x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromArray(x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromDate(x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromTime(x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromTimestamp(x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromNull();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromUrl(x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.parameterMetaData;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromRowId(x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromNString(value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromNCharacterStream(value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromNClob(value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromClob(reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromBlob(inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromNClob(reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromSQLXML(xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromObject(x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromAsciiStream(x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromBinaryStream(x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromCharacterStream(reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromAsciiStream(x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromBinaryStream(x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromCharacterStream(reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromNCharacterStream(value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromClob(reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromBlob(inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.throwIfClosed();
        this.throwIfOutOfBounds(parameterIndex);
        this.parameters[this.indexFromParameterIndex((int)parameterIndex)] = TypedValue.fromNClob(reader);
    }
}

