/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.polypheny.jdbc.BidirectionalScroller;
import org.polypheny.jdbc.ForwardOnlyScroller;
import org.polypheny.jdbc.PolyphenyStatement;
import org.polypheny.jdbc.PrismInterfaceClient;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.Scrollable;
import org.polypheny.jdbc.dependency.prism.Frame;
import org.polypheny.jdbc.meta.MetaScroller;
import org.polypheny.jdbc.meta.MetaUtils;
import org.polypheny.jdbc.meta.PolyphenyColumnMeta;
import org.polypheny.jdbc.meta.PolyphenyResultSetMetadata;
import org.polypheny.jdbc.properties.PolyphenyResultSetProperties;
import org.polypheny.jdbc.types.TypedValue;

public class PolyphenyResultSet
implements ResultSet {
    private boolean isMeta = false;
    private final PolyphenyStatement statement;
    private PolyphenyResultSetMetadata metadata;
    private Scrollable<List<TypedValue>> resultScroller;
    private Class<BidirectionalScroller> bidirectionScrollerClass;
    private TypedValue lastRead;
    private boolean isClosed;
    private Map<Integer, TypedValue> rowUpdates;
    private boolean isInInsertMode;
    PolyphenyResultSetProperties properties;

    public PolyphenyResultSet(PolyphenyStatement statement, Frame frame, PolyphenyResultSetProperties properties) throws SQLException {
        if (frame.getResultCase() != Frame.ResultCase.RELATIONAL_FRAME) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.RESULT_TYPE_INVALID, "Invalid frame type " + frame.getResultCase().name());
        }
        this.statement = statement;
        this.metadata = new PolyphenyResultSetMetadata(MetaUtils.buildColumnMetas(frame.getRelationalFrame().getColumnMetaList()));
        this.resultScroller = properties.getResultSetType() == 1003 ? new ForwardOnlyScroller(frame, this.getClient(), statement.getStatementId(), properties, statement.getConnection().getNetworkTimeout()) : new BidirectionalScroller(frame, this.getClient(), statement.getStatementId(), properties, statement.getConnection().getNetworkTimeout());
        this.bidirectionScrollerClass = BidirectionalScroller.class;
        this.properties = properties;
        this.lastRead = null;
        this.isClosed = false;
        this.isInInsertMode = false;
    }

    public PolyphenyResultSet(List<PolyphenyColumnMeta> columnMetas, List<List<TypedValue>> rows) {
        this.resultScroller = new MetaScroller<List<TypedValue>>(rows);
        this.metadata = new PolyphenyResultSetMetadata(columnMetas);
        this.statement = null;
        this.properties = PolyphenyResultSetProperties.forMetaResultSet();
        this.lastRead = null;
        this.isClosed = false;
        this.isInInsertMode = false;
        this.isMeta = true;
    }

    private TypedValue accessValue(int column) throws SQLException {
        if (!this.isInInsertMode) {
            try {
                if (!this.resultScroller.hasCurrent()) {
                    throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "No current row to read from.");
                }
                this.lastRead = this.resultScroller.current().get(column - 1);
                if (this.properties.getMaxFieldSize() > 0 && this.lastRead.getLength() > this.properties.getMaxFieldSize()) {
                    return this.lastRead.getTrimmed(this.properties.getMaxFieldSize());
                }
                return this.lastRead;
            }
            catch (IndexOutOfBoundsException e) {
                throw new PrismInterfaceServiceException(PrismInterfaceErrors.COLUMN_NOT_EXISTS, "Column index out of bounds.");
            }
        }
        TypedValue value = this.rowUpdates.get(column);
        if (value == null) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.COLUMN_ACCESS_ILLEGAL, "Can't access unset colum");
        }
        return value;
    }

    private void throwIfClosed() throws SQLException {
        if (this.isClosed) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "This operation cannot be applied to a closed result set.");
        }
    }

    private void throwIfColumnIndexOutOfBounds(int columnIndex) throws SQLException {
        if (columnIndex < 1) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.COLUMN_NOT_EXISTS, "Column index must be greater than 0");
        }
        if (columnIndex > this.metadata.getColumnCount()) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.COLUMN_NOT_EXISTS, "Column index out of bounds");
        }
    }

    private void throwIfReadOnly() throws SQLException {
        if (this.properties.isReadOnly()) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.MODIFICATION_NOT_PERMITTED, "Modification of result sets in read only mode is not permitted");
        }
    }

    private void discardRowUpdates() {
        if (this.rowUpdates == null) {
            return;
        }
        this.rowUpdates = null;
    }

    private Map<Integer, TypedValue> getOrCreateRowUpdate() {
        if (this.rowUpdates == null) {
            this.rowUpdates = new LinkedHashMap<Integer, TypedValue>();
        }
        return this.rowUpdates;
    }

    public void fetchAll() throws SQLException {
        try {
            this.resultScroller.fetchAllAndSync();
        }
        catch (InterruptedException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DRIVER_THREADING_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.throwIfClosed();
        this.discardRowUpdates();
        return this.resultScroller.next();
    }

    private PrismInterfaceClient getClient() {
        return this.statement.getClient();
    }

    private BidirectionalScroller getBidirectionalScrollerOrThrow() throws SQLException {
        if (this.resultScroller instanceof BidirectionalScroller) {
            return this.bidirectionScrollerClass.cast(this.resultScroller);
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Illegal operation on resultset of type TYPE_FORWARD_ONLY");
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.statement != null) {
            this.statement.notifyResultClosure();
        }
        this.isClosed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.throwIfClosed();
        return this.lastRead.isNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asBoolean();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asByte();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asShort();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asInt();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asLong();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asFloat();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asDouble();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asBigDecimal(scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asDate(this.properties.getCalendar());
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asTime(this.properties.getCalendar());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asTimestamp(this.properties.getCalendar());
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asAsciiStream();
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asUnicodeStream();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asBinaryStream();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.metadata.getColumnIndexFromLabel(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.throwIfClosed();
        TypedValue typedValue = this.accessValue(columnIndex);
        if (typedValue.isUdt()) {
            return typedValue.asObject(this.getStatement().getConnection().getTypeMap());
        }
        return typedValue.asObject(this.properties.getCalendar());
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return this.metadata.getColumnIndexFromLabel(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asBigDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.resultScroller.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.resultScroller.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.resultScroller.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.resultScroller.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.throwIfClosed();
        this.discardRowUpdates();
        this.getBidirectionalScrollerOrThrow().beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.throwIfClosed();
        this.discardRowUpdates();
        this.getBidirectionalScrollerOrThrow().afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        this.throwIfClosed();
        this.discardRowUpdates();
        return this.getBidirectionalScrollerOrThrow().first();
    }

    @Override
    public boolean last() throws SQLException {
        this.throwIfClosed();
        this.discardRowUpdates();
        try {
            return this.getBidirectionalScrollerOrThrow().last();
        }
        catch (InterruptedException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DRIVER_THREADING_ERROR, "Fetching more rows from server failed.", (Throwable)e);
        }
    }

    @Override
    public int getRow() throws SQLException {
        return this.resultScroller.getRow();
    }

    @Override
    public boolean absolute(int i) throws SQLException {
        this.throwIfClosed();
        this.discardRowUpdates();
        return this.getBidirectionalScrollerOrThrow().absolute(i);
    }

    @Override
    public boolean relative(int i) throws SQLException {
        this.throwIfClosed();
        this.discardRowUpdates();
        return this.getBidirectionalScrollerOrThrow().relative(i);
    }

    @Override
    public boolean previous() throws SQLException {
        this.throwIfClosed();
        this.discardRowUpdates();
        return this.getBidirectionalScrollerOrThrow().previous();
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        this.throwIfClosed();
        if (this.properties.getResultSetType() == 1003 && fetchDirection != 1000) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Illegal fetch direction for resultset of TYPE_FORWARD_ONLY.");
        }
        this.properties.setFetchDirection(fetchDirection);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.throwIfClosed();
        return this.properties.getFetchDirection();
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.throwIfClosed();
        if (fetchSize < 0) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal value for fetch size. fetchSize >= 0 must hold.");
        }
        this.properties.setFetchSize(fetchSize);
        this.getStatement().setFetchSize(fetchSize);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.throwIfClosed();
        return this.properties.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        this.throwIfClosed();
        return this.properties.getResultSetType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.throwIfClosed();
        return this.properties.getResultSetConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromNull());
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromBoolean(x));
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromByte(x));
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromShort(x));
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromInteger(x));
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromLong(x));
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromFloat(x));
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromDouble(x));
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromBigDecimal(x));
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromString(x));
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromBytes(x));
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromDate(x));
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromTime(x));
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromTimestamp(x));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.throwIfColumnIndexOutOfBounds(columnIndex);
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromAsciiStream(x, length));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromBinaryStream(x, length));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromCharacterStream(x, length));
    }

    @Override
    public void updateObject(int columnIndex, Object x, int saleOrLength) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromObject(x));
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.updateNull(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.updateBoolean(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.updateByte(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.updateShort(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.updateInt(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.updateLong(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.updateFloat(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.updateDouble(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.updateString(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.updateBytes(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.updateDate(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.updateTime(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.updateTimestamp(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.metadata.getColumnIndexFromLabel(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.metadata.getColumnIndexFromLabel(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        this.updateCharacterStream(this.metadata.getColumnIndexFromLabel(columnLabel), x, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.updateObject(this.metadata.getColumnIndexFromLabel(columnLabel), x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.updateObject(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.throwIfClosed();
        if (this.isMeta) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "This operation cannot be applied to a dummy result set of a meta request.");
        }
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asRef();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asBlob();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asClob();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asArray();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.metadata.getColumnIndexFromLabel(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asDate(calendar);
    }

    @Override
    public Date getDate(String columnLabel, Calendar calendar) throws SQLException {
        return this.getDate(this.metadata.getColumnIndexFromLabel(columnLabel), calendar);
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return this.accessValue(columnIndex).asTime(calendar);
    }

    @Override
    public Time getTime(String columnLabel, Calendar calendar) throws SQLException {
        return this.getTime(this.metadata.getColumnIndexFromLabel(columnLabel), calendar);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asTimestamp(calendar);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.metadata.getColumnIndexFromLabel(columnLabel), calendar);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asUrl();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromRef(x));
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.updateRef(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromBlob(x));
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.updateBlob(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromClob(x));
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.updateClob(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromArray(x));
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.updateArray(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asRowId();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromRowId(x));
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.updateRowId(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.throwIfClosed();
        return this.properties.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromNString(x));
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        this.updateNString(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromNClob(x));
    }

    @Override
    public void updateNClob(String columnLabel, NClob x) throws SQLException {
        this.updateNClob(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asNClob();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asSQLXML();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromSQLXML(x));
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        this.updateSQLXML(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asNString();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asNCharacterStream();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.metadata.getColumnIndexFromLabel(columnLabel));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromNCharacterStream(x, length));
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        this.updateNCharacterStream(this.metadata.getColumnIndexFromLabel(columnLabel), x, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromAsciiStream(x, length));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromBinaryStream(x, length));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromCharacterStream(x, length));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.metadata.getColumnIndexFromLabel(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.metadata.getColumnIndexFromLabel(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        this.updateCharacterStream(this.metadata.getColumnIndexFromLabel(columnLabel), x, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromBlob(x));
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBlob(this.metadata.getColumnIndexFromLabel(columnLabel), x, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromClob(x, length));
    }

    @Override
    public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        this.updateClob(this.metadata.getColumnIndexFromLabel(columnLabel), x, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromNClob(x, length));
    }

    @Override
    public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        this.updateNClob(this.metadata.getColumnIndexFromLabel(columnLabel), x, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromNCharacterStream(x));
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        this.updateNCharacterStream(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromAsciiStream(x));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromBinaryStream(x));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromCharacterStream(x));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateAsciiStream(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        this.updateCharacterStream(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromBlob(x));
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        this.updateBlob(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromClob(x));
    }

    @Override
    public void updateClob(String columnLabel, Reader x) throws SQLException {
        this.updateClob(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x) throws SQLException {
        this.throwIfClosed();
        this.throwIfReadOnly();
        this.getOrCreateRowUpdate().put(columnIndex, TypedValue.fromNClob(x));
    }

    @Override
    public void updateNClob(String columnLabel, Reader x) throws SQLException {
        this.updateNClob(this.metadata.getColumnIndexFromLabel(columnLabel), x);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> aClass) throws SQLException {
        this.throwIfClosed();
        return this.accessValue(columnIndex).asObject(aClass);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> aClass) throws SQLException {
        return this.getObject(this.metadata.getColumnIndexFromLabel(columnLabel), aClass);
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return aClass.cast(this);
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.WRAPPER_INCORRECT_TYPE, "Not a wrapper for " + aClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) {
        return aClass.isInstance(this);
    }
}

