/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.polypheny.jdbc.PolyConnection;
import org.polypheny.jdbc.PolyphenyResultSet;
import org.polypheny.jdbc.PrismInterfaceClient;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.prism.ExecuteUnparameterizedStatementRequest;
import org.polypheny.jdbc.dependency.prism.Frame;
import org.polypheny.jdbc.dependency.prism.Response;
import org.polypheny.jdbc.dependency.prism.StatementBatchResponse;
import org.polypheny.jdbc.dependency.prism.StatementResponse;
import org.polypheny.jdbc.properties.PolyphenyStatementProperties;
import org.polypheny.jdbc.properties.PropertyUtils;
import org.polypheny.jdbc.utils.CallbackQueue;

public class PolyphenyStatement
implements Statement {
    private PolyConnection polyConnection;
    protected ResultSet currentResult;
    protected long currentUpdateCount;
    protected int statementId;
    private boolean isClosed;
    protected PolyphenyStatementProperties properties;
    protected static final int NO_UPDATE_COUNT = -1;
    protected static final int NO_STATEMENT_ID = -1;
    protected List<String> statementBatch;

    public PolyphenyStatement(PolyConnection connection, PolyphenyStatementProperties properties) throws SQLException {
        this.polyConnection = connection;
        this.properties = properties;
        this.isClosed = false;
        this.statementBatch = new LinkedList<String>();
        this.properties.setPolyphenyStatement(this);
        this.statementId = -1;
        this.currentResult = null;
    }

    public boolean hasStatementId() {
        return this.statementId != -1;
    }

    protected PrismInterfaceClient getClient() {
        return this.polyConnection.getPrismInterfaceClient();
    }

    protected int longToInt(long longNumber) {
        return Math.toIntExact(longNumber);
    }

    private void prepareForReExecution() throws SQLException {
        if (this.currentResult != null) {
            this.currentResult.close();
        }
        this.currentUpdateCount = -1L;
        if (this.statementId != -1) {
            this.getClient().closeStatement(this.statementId, this.getTimeout());
            this.statementId = -1;
        }
    }

    public void notifyResultClosure() throws SQLException {
        this.currentResult = null;
        this.getClient().closeResult(this.statementId, this.getTimeout());
        if (this.isCloseOnCompletion()) {
            this.close();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.polyConnection.endTracking(this);
        this.prepareForReExecution();
        this.isClosed = true;
    }

    protected int getTimeout() throws SQLException {
        return Math.min(this.getConnection().getNetworkTimeout(), this.properties.getQueryTimeoutSeconds() * 1000);
    }

    protected void throwIfClosed() throws SQLException {
        if (this.isClosed) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Illegal operation for a closed statement");
        }
    }

    protected void throwIfNotRelational(Frame frame) throws SQLException {
        if (frame.getResultCase() == Frame.ResultCase.RELATIONAL_FRAME) {
            return;
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.RESULT_TYPE_INVALID, "Statement must produce a relational result");
    }

    @Override
    public ResultSet executeQuery(String statement) throws SQLException {
        StatementResponse response;
        this.throwIfClosed();
        this.clearBatch();
        this.prepareForReExecution();
        CallbackQueue<StatementResponse> callback = new CallbackQueue<StatementResponse>(Response::getStatementResponse);
        String namespaceName = this.getConnection().getSchema();
        this.getClient().executeUnparameterizedStatement(namespaceName, PropertyUtils.getSQL_LANGUAGE_NAME(), statement, callback, this.getTimeout());
        do {
            response = callback.takeNext();
            if (this.hasStatementId()) continue;
            this.statementId = response.getStatementId();
        } while (!response.hasResult());
        try {
            callback.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DRIVER_THREADING_ERROR, "Awaiting completion of api call failed.", (Throwable)e);
        }
        if (!response.getResult().hasFrame()) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.RESULT_TYPE_INVALID, "Statement must produce a single ResultSet");
        }
        Frame frame = response.getResult().getFrame();
        this.throwIfNotRelational(frame);
        this.currentResult = new PolyphenyResultSet(this, frame, this.properties.toResultSetProperties());
        return this.currentResult;
    }

    @Override
    public int executeUpdate(String statement) throws SQLException {
        StatementResponse response;
        this.throwIfClosed();
        this.clearBatch();
        this.prepareForReExecution();
        CallbackQueue<StatementResponse> callback = new CallbackQueue<StatementResponse>(Response::getStatementResponse);
        String namespaceName = this.getConnection().getSchema();
        this.getClient().executeUnparameterizedStatement(namespaceName, PropertyUtils.getSQL_LANGUAGE_NAME(), statement, callback, this.getTimeout());
        do {
            response = callback.takeNext();
            if (this.hasStatementId()) continue;
            this.statementId = response.getStatementId();
        } while (!response.hasResult());
        try {
            callback.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DRIVER_THREADING_ERROR, "Awaiting completion of api call failed.", (Throwable)e);
        }
        if (response.getResult().hasFrame()) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.RESULT_TYPE_INVALID, "Statement must not produce a ResultSet");
        }
        this.currentUpdateCount = response.getResult().getScalar();
        return this.longToInt(this.currentUpdateCount);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.throwIfClosed();
        return this.properties.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.throwIfClosed();
        this.properties.setMaxFieldSize(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.throwIfClosed();
        return this.properties.getLargeMaxRows();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.throwIfClosed();
        return this.longToInt(this.getLargeMaxRows());
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.throwIfClosed();
        this.properties.setLargeMaxRows(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.throwIfClosed();
        this.properties.setDoesEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.throwIfClosed();
        return this.properties.getQueryTimeoutSeconds();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.throwIfClosed();
        if (seconds < 0) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal argument for max");
        }
        this.properties.setQueryTimeoutSeconds(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.throwIfClosed();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfClosed();
    }

    @Override
    public void setCursorName(String s) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String statement) throws SQLException {
        StatementResponse response;
        this.throwIfClosed();
        this.clearBatch();
        this.prepareForReExecution();
        CallbackQueue<StatementResponse> callback = new CallbackQueue<StatementResponse>(Response::getStatementResponse);
        String namespaceName = this.getConnection().getSchema();
        this.getClient().executeUnparameterizedStatement(namespaceName, PropertyUtils.getSQL_LANGUAGE_NAME(), statement, callback, this.getTimeout());
        do {
            response = callback.takeNext();
            if (this.hasStatementId()) continue;
            this.statementId = response.getStatementId();
        } while (!response.hasResult());
        try {
            callback.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DRIVER_THREADING_ERROR, "Awaiting completion of api call failed.", (Throwable)e);
        }
        if (!response.getResult().hasFrame()) {
            this.currentUpdateCount = this.longToInt(response.getResult().getScalar());
            return false;
        }
        Frame frame = response.getResult().getFrame();
        this.throwIfNotRelational(frame);
        this.currentResult = new PolyphenyResultSet(this, frame, this.properties.toResultSetProperties());
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.throwIfClosed();
        return this.currentResult;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.throwIfClosed();
        return this.currentUpdateCount;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.longToInt(this.getLargeUpdateCount());
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.throwIfClosed();
        this.prepareForReExecution();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.throwIfClosed();
        this.properties.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.throwIfClosed();
        return this.properties.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.throwIfClosed();
        this.properties.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.throwIfClosed();
        return this.properties.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.throwIfClosed();
        return this.properties.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.throwIfClosed();
        return this.properties.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.throwIfClosed();
        this.statementBatch.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.statementBatch.isEmpty()) {
            return;
        }
        this.statementBatch.clear();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        List<Long> scalars = this.executeUnparameterizedBatch();
        long[] updateCounts = new long[scalars.size()];
        for (int i = 0; i < scalars.size(); ++i) {
            updateCounts[i] = scalars.get(i);
        }
        return updateCounts;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        List<Long> scalars = this.executeUnparameterizedBatch();
        int[] updateCounts = new int[scalars.size()];
        for (int i = 0; i < scalars.size(); ++i) {
            updateCounts[i] = this.longToInt(scalars.get(i));
        }
        return updateCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> executeUnparameterizedBatch() throws SQLException {
        try {
            StatementBatchResponse status;
            this.throwIfClosed();
            this.prepareForReExecution();
            CallbackQueue<StatementBatchResponse> callback = new CallbackQueue<StatementBatchResponse>(Response::getStatementBatchResponse);
            List<ExecuteUnparameterizedStatementRequest> requests = this.buildBatchRequest();
            this.clearBatch();
            this.getClient().executeUnparameterizedStatementBatch(requests, callback, this.getTimeout());
            do {
                status = callback.takeNext();
                if (this.hasStatementId()) continue;
                this.statementId = status.getBatchId();
            } while (status.getScalarsCount() == 0);
            try {
                callback.awaitCompletion();
            }
            catch (InterruptedException e) {
                throw new PrismInterfaceServiceException(PrismInterfaceErrors.DRIVER_THREADING_ERROR, "Awaiting completion of api call failed.", (Throwable)e);
            }
            List<Long> list = status.getScalarsList();
            return list;
        }
        finally {
            this.clearBatch();
        }
    }

    List<ExecuteUnparameterizedStatementRequest> buildBatchRequest() throws SQLException {
        String namespaceName = this.getConnection().getSchema();
        return this.statementBatch.stream().map(s -> {
            ExecuteUnparameterizedStatementRequest.Builder builder = ExecuteUnparameterizedStatementRequest.newBuilder().setStatement((String)s).setFetchSize(this.properties.getFetchSize()).setLanguageName(PropertyUtils.getSQL_LANGUAGE_NAME());
            if (namespaceName != null) {
                builder.setNamespaceName(namespaceName);
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.throwIfClosed();
        return this.polyConnection;
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        if (i == 2 || i == 3) {
            throw new SQLFeatureNotSupportedException();
        }
        if (i != 1) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal value for closing behaviour: " + i);
        }
        this.throwIfClosed();
        this.prepareForReExecution();
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public long executeLargeUpdate(String sql, int autogeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autogeneratedKeys) throws SQLException {
        return this.longToInt(this.executeLargeUpdate(sql, autogeneratedKeys));
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.longToInt(this.executeLargeUpdate(sql, columnIndexes));
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.longToInt(this.executeLargeUpdate(sql, columnNames));
    }

    @Override
    public boolean execute(String s, int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String s, int[] ints) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String s, String[] strings) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.throwIfClosed();
        return this.properties.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.throwIfClosed();
        this.properties.setIsPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.throwIfClosed();
        return this.properties.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.throwIfClosed();
        this.properties.setCloseOnCompletion(true);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.throwIfClosed();
        return this.properties.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return aClass.cast(this);
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.WRAPPER_INCORRECT_TYPE, "Not a wrapper for " + aClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) {
        return aClass.isInstance(this);
    }

    @Generated
    public PolyConnection getPolyConnection() {
        return this.polyConnection;
    }

    @Generated
    public int getStatementId() {
        return this.statementId;
    }
}

