/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.RpcService;
import org.polypheny.jdbc.dependency.prism.ClientInfoProperties;
import org.polypheny.jdbc.dependency.prism.ClientInfoPropertiesRequest;
import org.polypheny.jdbc.dependency.prism.CloseResultRequest;
import org.polypheny.jdbc.dependency.prism.CloseStatementRequest;
import org.polypheny.jdbc.dependency.prism.CommitRequest;
import org.polypheny.jdbc.dependency.prism.ConnectionCheckRequest;
import org.polypheny.jdbc.dependency.prism.ConnectionProperties;
import org.polypheny.jdbc.dependency.prism.ConnectionPropertiesUpdateRequest;
import org.polypheny.jdbc.dependency.prism.ConnectionRequest;
import org.polypheny.jdbc.dependency.prism.ConnectionResponse;
import org.polypheny.jdbc.dependency.prism.DbmsVersionRequest;
import org.polypheny.jdbc.dependency.prism.DbmsVersionResponse;
import org.polypheny.jdbc.dependency.prism.DefaultNamespaceRequest;
import org.polypheny.jdbc.dependency.prism.DisconnectRequest;
import org.polypheny.jdbc.dependency.prism.EntitiesRequest;
import org.polypheny.jdbc.dependency.prism.Entity;
import org.polypheny.jdbc.dependency.prism.ExecuteIndexedStatementBatchRequest;
import org.polypheny.jdbc.dependency.prism.ExecuteIndexedStatementRequest;
import org.polypheny.jdbc.dependency.prism.ExecuteUnparameterizedStatementBatchRequest;
import org.polypheny.jdbc.dependency.prism.ExecuteUnparameterizedStatementRequest;
import org.polypheny.jdbc.dependency.prism.FetchRequest;
import org.polypheny.jdbc.dependency.prism.Frame;
import org.polypheny.jdbc.dependency.prism.Function;
import org.polypheny.jdbc.dependency.prism.FunctionsRequest;
import org.polypheny.jdbc.dependency.prism.IndexedParameters;
import org.polypheny.jdbc.dependency.prism.Namespace;
import org.polypheny.jdbc.dependency.prism.NamespacesRequest;
import org.polypheny.jdbc.dependency.prism.PrepareStatementRequest;
import org.polypheny.jdbc.dependency.prism.PreparedStatementSignature;
import org.polypheny.jdbc.dependency.prism.Procedure;
import org.polypheny.jdbc.dependency.prism.ProceduresRequest;
import org.polypheny.jdbc.dependency.prism.ProtoValue;
import org.polypheny.jdbc.dependency.prism.RollbackRequest;
import org.polypheny.jdbc.dependency.prism.SqlKeywordsRequest;
import org.polypheny.jdbc.dependency.prism.SqlNumericFunctionsRequest;
import org.polypheny.jdbc.dependency.prism.SqlStringFunctionsRequest;
import org.polypheny.jdbc.dependency.prism.SqlSystemFunctionsRequest;
import org.polypheny.jdbc.dependency.prism.SqlTimeDateFunctionsRequest;
import org.polypheny.jdbc.dependency.prism.StatementBatchResponse;
import org.polypheny.jdbc.dependency.prism.StatementResponse;
import org.polypheny.jdbc.dependency.prism.StatementResult;
import org.polypheny.jdbc.dependency.prism.TableType;
import org.polypheny.jdbc.dependency.prism.TableTypesRequest;
import org.polypheny.jdbc.dependency.prism.Type;
import org.polypheny.jdbc.dependency.prism.TypesRequest;
import org.polypheny.jdbc.properties.PolyphenyConnectionProperties;
import org.polypheny.jdbc.transport.PlainTransport;
import org.polypheny.jdbc.transport.Transport;
import org.polypheny.jdbc.types.TypedValue;
import org.polypheny.jdbc.utils.CallbackQueue;
import org.polypheny.jdbc.utils.ProtoUtils;
import org.polypheny.jdbc.utils.VersionUtil;

public class PrismInterfaceClient {
    private final Transport con;
    private final RpcService rpc;

    public PrismInterfaceClient(String host, int port, Map<String, String> parameters) throws PrismInterfaceServiceException {
        try {
            String transport = parameters.getOrDefault("transport", "plain");
            if (!transport.equals("plain")) {
                throw new PrismInterfaceServiceException("Unknown transport " + transport);
            }
            this.con = new PlainTransport(host, port);
            this.rpc = new RpcService(this.con);
        }
        catch (IOException e) {
            throw new PrismInterfaceServiceException(e);
        }
    }

    public boolean checkConnection(int timeout) {
        ConnectionCheckRequest request = ConnectionCheckRequest.newBuilder().build();
        try {
            this.rpc.checkConnection(request, timeout);
            return true;
        }
        catch (PrismInterfaceServiceException e) {
            return false;
        }
    }

    public ConnectionResponse register(PolyphenyConnectionProperties connectionProperties, int timeout) throws PrismInterfaceServiceException {
        ConnectionRequest.Builder requestBuilder = ConnectionRequest.newBuilder();
        Optional.ofNullable(connectionProperties.getUsername()).ifPresent(requestBuilder::setUsername);
        Optional.ofNullable(connectionProperties.getPassword()).ifPresent(requestBuilder::setPassword);
        requestBuilder.setMajorApiVersion(VersionUtil.MAJOR_API_VERSION).setMinorApiVersion(VersionUtil.MINOR_API_VERSION).setConnectionProperties(this.buildConnectionProperties(connectionProperties));
        ConnectionResponse connectionResponse = this.rpc.connect(requestBuilder.build(), timeout);
        if (!connectionResponse.getIsCompatible()) {
            throw new PrismInterfaceServiceException("client version " + PrismInterfaceClient.getClientApiVersionString() + " not compatible with server version " + this.getServerApiVersionString(connectionResponse) + ".");
        }
        return connectionResponse;
    }

    private ConnectionProperties buildConnectionProperties(PolyphenyConnectionProperties properties) {
        ConnectionProperties.Builder propertiesBuilder = ConnectionProperties.newBuilder();
        Optional.ofNullable(properties.getNamespaceName()).ifPresent(propertiesBuilder::setNamespaceName);
        return propertiesBuilder.setIsAutoCommit(properties.isAutoCommit()).build();
    }

    public void unregister(int timeout) throws PrismInterfaceServiceException {
        DisconnectRequest request = DisconnectRequest.newBuilder().build();
        try {
            this.rpc.disconnect(request, timeout);
        }
        finally {
            this.rpc.close();
        }
    }

    public void executeUnparameterizedStatement(String namespaceName, String languageName, String statement, CallbackQueue<StatementResponse> callback, int timeout) throws PrismInterfaceServiceException {
        ExecuteUnparameterizedStatementRequest.Builder requestBuilder = ExecuteUnparameterizedStatementRequest.newBuilder();
        if (namespaceName != null) {
            requestBuilder.setNamespaceName(namespaceName);
        }
        ExecuteUnparameterizedStatementRequest request = requestBuilder.setLanguageName(languageName).setStatement(statement).build();
        this.rpc.executeUnparameterizedStatement(request, callback);
    }

    public void executeUnparameterizedStatementBatch(List<ExecuteUnparameterizedStatementRequest> requests, CallbackQueue<StatementBatchResponse> updateCallback, int timeout) throws PrismInterfaceServiceException {
        ExecuteUnparameterizedStatementBatchRequest request = ExecuteUnparameterizedStatementBatchRequest.newBuilder().addAllStatements(requests).build();
        this.rpc.executeUnparameterizedStatementBatch(request, updateCallback);
    }

    public PreparedStatementSignature prepareIndexedStatement(String namespaceName, String languageName, String statement, int timeout) throws PrismInterfaceServiceException {
        PrepareStatementRequest.Builder requestBuilder = PrepareStatementRequest.newBuilder();
        if (namespaceName != null) {
            requestBuilder.setNamespaceName(namespaceName);
        }
        PrepareStatementRequest request = requestBuilder.setStatement(statement).setLanguageName(languageName).build();
        return this.rpc.prepareIndexedStatement(request, timeout);
    }

    public StatementResult executeIndexedStatement(int statementId, List<TypedValue> values, int fetchSize, int timeout) throws PrismInterfaceServiceException {
        IndexedParameters parameters = IndexedParameters.newBuilder().addAllParameters(ProtoUtils.serializeParameterList(values)).build();
        ExecuteIndexedStatementRequest request = ExecuteIndexedStatementRequest.newBuilder().setStatementId(statementId).setParameters(parameters).setFetchSize(fetchSize).build();
        return this.rpc.executeIndexedStatement(request, timeout);
    }

    public StatementBatchResponse executeIndexedStatementBatch(int statementId, List<List<TypedValue>> parameterBatch, int timeout) throws PrismInterfaceServiceException {
        List parameters = parameterBatch.stream().map(ProtoUtils::serializeParameterList).map(p -> IndexedParameters.newBuilder().addAllParameters((Iterable<? extends ProtoValue>)p).build()).collect(Collectors.toList());
        ExecuteIndexedStatementBatchRequest request = ExecuteIndexedStatementBatchRequest.newBuilder().setStatementId(statementId).addAllParameters(parameters).build();
        return this.rpc.executeIndexedStatementBatch(request, timeout);
    }

    public void commitTransaction(int timeout) throws PrismInterfaceServiceException {
        CommitRequest commitRequest = CommitRequest.newBuilder().build();
        this.rpc.commit(commitRequest, timeout);
    }

    public void rollbackTransaction(int timeout) throws PrismInterfaceServiceException {
        RollbackRequest rollbackRequest = RollbackRequest.newBuilder().build();
        this.rpc.rollback(rollbackRequest, timeout);
    }

    public void closeStatement(int statementId, int timeout) throws PrismInterfaceServiceException {
        CloseStatementRequest request = CloseStatementRequest.newBuilder().setStatementId(statementId).build();
        this.rpc.closeStatement(request, timeout);
    }

    public void closeResult(int statementId, int timeout) throws PrismInterfaceServiceException {
        CloseResultRequest resultCloseRequest = CloseResultRequest.newBuilder().setStatementId(statementId).build();
        this.rpc.closeResult(resultCloseRequest, timeout);
    }

    public Frame fetchResult(int statementId, int fetchSize, int timeout) throws PrismInterfaceServiceException {
        FetchRequest fetchRequest = FetchRequest.newBuilder().setFetchSize(fetchSize).setStatementId(statementId).build();
        return this.rpc.fetchResult(fetchRequest, timeout);
    }

    private String getServerApiVersionString(ConnectionResponse response) {
        return response.getMajorApiVersion() + "." + response.getMinorApiVersion();
    }

    private static String getClientApiVersionString() {
        return VersionUtil.MAJOR + "." + VersionUtil.MINOR;
    }

    public DbmsVersionResponse getDbmsVersion(int timeout) throws PrismInterfaceServiceException {
        DbmsVersionRequest dbmsVersionRequest = DbmsVersionRequest.newBuilder().build();
        return this.rpc.getDbmsVersion(dbmsVersionRequest, timeout);
    }

    public String getDefaultNamespace(int timeout) throws PrismInterfaceServiceException {
        return this.rpc.defaultNamespaceRequest(DefaultNamespaceRequest.newBuilder().build(), timeout).getDefaultNamespace();
    }

    public List<Type> getTypes(int timeout) throws PrismInterfaceServiceException {
        return this.rpc.getTypes(TypesRequest.newBuilder().build(), timeout).getTypesList();
    }

    public String getSqlStringFunctions(int timeout) throws PrismInterfaceServiceException {
        return this.rpc.getSqlStringFunctions(SqlStringFunctionsRequest.newBuilder().build(), timeout).getString();
    }

    public String getSqlSystemFunctions(int timeout) throws PrismInterfaceServiceException {
        return this.rpc.getSqlSystemFunctions(SqlSystemFunctionsRequest.newBuilder().build(), timeout).getString();
    }

    public String getSqlTimeDateFunctions(int timeout) throws PrismInterfaceServiceException {
        return this.rpc.getSqlTimeDateFunctions(SqlTimeDateFunctionsRequest.newBuilder().build(), timeout).getString();
    }

    public String getSqlNumericFunctions(int timeout) throws PrismInterfaceServiceException {
        return this.rpc.getSqlNumericFunctions(SqlNumericFunctionsRequest.newBuilder().build(), timeout).getString();
    }

    public String getSqlKeywords(int timeout) throws PrismInterfaceServiceException {
        return this.rpc.getSqlKeywords(SqlKeywordsRequest.newBuilder().build(), timeout).getString();
    }

    public void setConnectionProperties(PolyphenyConnectionProperties connectionProperties, int timeout) throws PrismInterfaceServiceException {
        ConnectionPropertiesUpdateRequest request = ConnectionPropertiesUpdateRequest.newBuilder().setConnectionProperties(this.buildConnectionProperties(connectionProperties)).build();
        this.rpc.updateConnectionProperties(request, timeout);
    }

    public List<Procedure> searchProcedures(String languageName, String procedureNamePattern, int timeout) throws PrismInterfaceServiceException {
        ProceduresRequest.Builder requestBuilder = ProceduresRequest.newBuilder();
        requestBuilder.setLanguage(languageName);
        Optional.ofNullable(procedureNamePattern).ifPresent(requestBuilder::setProcedureNamePattern);
        return this.rpc.searchProcedures(requestBuilder.build(), timeout).getProceduresList();
    }

    public Map<String, String> getClientInfoProperties(int timeout) throws PrismInterfaceServiceException {
        return this.rpc.getClientInfoProperties(ClientInfoPropertiesRequest.newBuilder().build(), timeout).getPropertiesMap();
    }

    public List<Namespace> searchNamespaces(String schemaPattern, String protoNamespaceType, int timeout) throws PrismInterfaceServiceException {
        NamespacesRequest.Builder requestBuilder = NamespacesRequest.newBuilder();
        Optional.ofNullable(schemaPattern).ifPresent(requestBuilder::setNamespacePattern);
        Optional.ofNullable(protoNamespaceType).ifPresent(requestBuilder::setNamespaceType);
        return this.rpc.searchNamespaces(requestBuilder.build(), timeout).getNamespacesList();
    }

    public List<Entity> searchEntities(String namespace, String entityNamePattern, int timeout) throws PrismInterfaceServiceException {
        EntitiesRequest.Builder requestBuilder = EntitiesRequest.newBuilder();
        requestBuilder.setNamespaceName(namespace);
        Optional.ofNullable(entityNamePattern).ifPresent(requestBuilder::setEntityPattern);
        return this.rpc.searchEntities(requestBuilder.build(), timeout).getEntitiesList();
    }

    public List<TableType> getTablesTypes(int timeout) throws PrismInterfaceServiceException {
        return this.rpc.getTableTypes(TableTypesRequest.newBuilder().build(), timeout).getTableTypesList();
    }

    public void setClientInfoProperties(Properties properties, int timeout) throws PrismInterfaceServiceException {
        ClientInfoProperties.Builder requestBuilder = ClientInfoProperties.newBuilder();
        properties.stringPropertyNames().forEach(s -> requestBuilder.putProperties((String)s, properties.getProperty((String)s)));
        this.rpc.setClientInfoProperties(requestBuilder.build(), timeout);
    }

    public List<Function> searchFunctions(String languageName, String functionCategory, int timeout) throws PrismInterfaceServiceException {
        FunctionsRequest functionsRequest = FunctionsRequest.newBuilder().setQueryLanguage(languageName).setFunctionCategory(functionCategory).build();
        return this.rpc.searchFunctions(functionsRequest, timeout).getFunctionsList();
    }
}

