/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc;

import java.util.List;
import lombok.Generated;
import org.polypheny.jdbc.PrismInterfaceClient;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.prism.Frame;
import org.polypheny.jdbc.dependency.prism.Row;
import org.polypheny.jdbc.properties.PolyphenyResultSetProperties;
import org.polypheny.jdbc.types.TypedValue;
import org.polypheny.jdbc.utils.TypedValueUtils;

public class ResultFetcher
implements Runnable {
    private PrismInterfaceClient client;
    private int statementId;
    private PolyphenyResultSetProperties properties;
    private int fetchTimeout;
    private long totalFetched;
    private boolean isLast;
    private List<List<TypedValue>> fetchedValues;

    public ResultFetcher(PrismInterfaceClient client, int statementId, PolyphenyResultSetProperties properties, long totalFetched, int fetchTimeout) {
        this.fetchTimeout = fetchTimeout;
        this.client = client;
        this.statementId = statementId;
        this.properties = properties;
        this.totalFetched = totalFetched;
        this.isLast = false;
    }

    @Override
    public void run() {
        Frame nextFrame;
        long fetchEnd = this.totalFetched + (long)this.properties.getStatementFetchSize();
        try {
            nextFrame = this.client.fetchResult(this.statementId, this.properties.getFetchSize(), this.fetchTimeout);
        }
        catch (PrismInterfaceServiceException e) {
            throw new RuntimeException(e);
        }
        if (nextFrame.getResultCase() != Frame.ResultCase.RELATIONAL_FRAME) {
            throw new RuntimeException(new PrismInterfaceServiceException("Illegal result type."));
        }
        List<Row> rows = nextFrame.getRelationalFrame().getRowsList();
        if (this.properties.getLargeMaxRows() != 0L && fetchEnd > this.properties.getLargeMaxRows()) {
            long rowEndIndex = this.properties.getLargeMaxRows() - this.totalFetched;
            if (rowEndIndex > Integer.MAX_VALUE) {
                throw new RuntimeException("Should never be thrown");
            }
            rows = rows.subList(0, (int)rowEndIndex);
        }
        this.fetchedValues = TypedValueUtils.buildRows(rows);
        this.totalFetched += (long)rows.size();
        this.isLast = nextFrame.getIsLast();
    }

    @Generated
    public void setProperties(PolyphenyResultSetProperties properties) {
        this.properties = properties;
    }

    @Generated
    public PolyphenyResultSetProperties getProperties() {
        return this.properties;
    }

    @Generated
    public void setLast(boolean isLast) {
        this.isLast = isLast;
    }

    @Generated
    public boolean isLast() {
        return this.isLast;
    }

    @Generated
    public List<List<TypedValue>> getFetchedValues() {
        return this.fetchedValues;
    }
}

