/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.org.slf4j.Logger;
import org.polypheny.jdbc.dependency.org.slf4j.LoggerFactory;
import org.polypheny.jdbc.dependency.prism.ClientInfoProperties;
import org.polypheny.jdbc.dependency.prism.ClientInfoPropertiesRequest;
import org.polypheny.jdbc.dependency.prism.ClientInfoPropertiesResponse;
import org.polypheny.jdbc.dependency.prism.CloseResultRequest;
import org.polypheny.jdbc.dependency.prism.CloseResultResponse;
import org.polypheny.jdbc.dependency.prism.CloseStatementRequest;
import org.polypheny.jdbc.dependency.prism.CloseStatementResponse;
import org.polypheny.jdbc.dependency.prism.CommitRequest;
import org.polypheny.jdbc.dependency.prism.CommitResponse;
import org.polypheny.jdbc.dependency.prism.ConnectionCheckRequest;
import org.polypheny.jdbc.dependency.prism.ConnectionCheckResponse;
import org.polypheny.jdbc.dependency.prism.ConnectionPropertiesUpdateRequest;
import org.polypheny.jdbc.dependency.prism.ConnectionPropertiesUpdateResponse;
import org.polypheny.jdbc.dependency.prism.ConnectionRequest;
import org.polypheny.jdbc.dependency.prism.ConnectionResponse;
import org.polypheny.jdbc.dependency.prism.DbmsVersionRequest;
import org.polypheny.jdbc.dependency.prism.DbmsVersionResponse;
import org.polypheny.jdbc.dependency.prism.DefaultNamespaceRequest;
import org.polypheny.jdbc.dependency.prism.DefaultNamespaceResponse;
import org.polypheny.jdbc.dependency.prism.DisconnectRequest;
import org.polypheny.jdbc.dependency.prism.DisconnectResponse;
import org.polypheny.jdbc.dependency.prism.EntitiesRequest;
import org.polypheny.jdbc.dependency.prism.EntitiesResponse;
import org.polypheny.jdbc.dependency.prism.ExecuteIndexedStatementBatchRequest;
import org.polypheny.jdbc.dependency.prism.ExecuteIndexedStatementRequest;
import org.polypheny.jdbc.dependency.prism.ExecuteUnparameterizedStatementBatchRequest;
import org.polypheny.jdbc.dependency.prism.ExecuteUnparameterizedStatementRequest;
import org.polypheny.jdbc.dependency.prism.FetchRequest;
import org.polypheny.jdbc.dependency.prism.Frame;
import org.polypheny.jdbc.dependency.prism.FunctionsRequest;
import org.polypheny.jdbc.dependency.prism.FunctionsResponse;
import org.polypheny.jdbc.dependency.prism.MetaStringResponse;
import org.polypheny.jdbc.dependency.prism.NamespacesRequest;
import org.polypheny.jdbc.dependency.prism.NamespacesResponse;
import org.polypheny.jdbc.dependency.prism.PrepareStatementRequest;
import org.polypheny.jdbc.dependency.prism.PreparedStatementSignature;
import org.polypheny.jdbc.dependency.prism.ProceduresRequest;
import org.polypheny.jdbc.dependency.prism.ProceduresResponse;
import org.polypheny.jdbc.dependency.prism.Request;
import org.polypheny.jdbc.dependency.prism.Response;
import org.polypheny.jdbc.dependency.prism.RollbackRequest;
import org.polypheny.jdbc.dependency.prism.RollbackResponse;
import org.polypheny.jdbc.dependency.prism.SqlKeywordsRequest;
import org.polypheny.jdbc.dependency.prism.SqlNumericFunctionsRequest;
import org.polypheny.jdbc.dependency.prism.SqlStringFunctionsRequest;
import org.polypheny.jdbc.dependency.prism.SqlSystemFunctionsRequest;
import org.polypheny.jdbc.dependency.prism.SqlTimeDateFunctionsRequest;
import org.polypheny.jdbc.dependency.prism.StatementBatchResponse;
import org.polypheny.jdbc.dependency.prism.StatementResponse;
import org.polypheny.jdbc.dependency.prism.StatementResult;
import org.polypheny.jdbc.dependency.prism.TableTypesRequest;
import org.polypheny.jdbc.dependency.prism.TableTypesResponse;
import org.polypheny.jdbc.dependency.prism.TypesRequest;
import org.polypheny.jdbc.dependency.prism.TypesResponse;
import org.polypheny.jdbc.transport.Transport;
import org.polypheny.jdbc.utils.CallbackQueue;

public class RpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RpcService.class);
    private final AtomicLong idCounter = new AtomicLong(1L);
    private final Transport con;
    private final Thread service;
    private boolean closed = false;
    private boolean disconnectSent = false;
    private IOException error = null;
    private final Map<Long, CompletableFuture<Response>> callbacks = new ConcurrentHashMap<Long, CompletableFuture<Response>>();
    private final Map<Long, CallbackQueue<?>> callbackQueues = new ConcurrentHashMap();

    RpcService(Transport con) {
        this.con = con;
        this.service = new Thread(this::readResponses, "PrismInterfaceResponseHandler");
        this.service.start();
    }

    void close() {
        this.closed = true;
        this.con.close();
        try {
            this.service.join();
        }
        catch (InterruptedException e) {
            log.warn("Could not join response handler", e);
        }
    }

    private Request.Builder newMessage() {
        long id = this.idCounter.getAndIncrement();
        return Request.newBuilder().setId(id);
    }

    private void sendMessage(Request req) throws IOException {
        if (this.error != null) {
            RpcService rpcService = this;
            synchronized (rpcService) {
                IOException e = this.error;
                this.error = null;
                throw e;
            }
        }
        if (this.closed) {
            throw new IOException("Connection is closed");
        }
        this.con.sendMessage(req.toByteArray());
    }

    private Response receiveMessage() throws IOException {
        return Response.parseFrom(this.con.receiveMessage());
    }

    private void readResponses() {
        try {
            while (true) {
                Response resp;
                if ((resp = this.receiveMessage()).getId() == 0L) {
                    throw new RuntimeException("Invalid message id");
                }
                CompletableFuture<Response> c2 = this.callbacks.get(resp.getId());
                if (c2 == null) {
                    CallbackQueue<?> cq2 = this.callbackQueues.get(resp.getId());
                    if (cq2 != null) {
                        if (resp.hasErrorResponse()) {
                            this.callbackQueues.remove(resp.getId());
                            cq2.onError(new PrismInterfaceServiceException(resp.getErrorResponse().getMessage()));
                            continue;
                        }
                        cq2.onNext(resp);
                        if (!resp.getLast()) continue;
                        this.callbackQueues.remove(resp.getId());
                        cq2.onCompleted();
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.info("No callback for response of type {}", (Object)resp.getTypeCase());
                    continue;
                }
                if (resp.getLast()) {
                    this.callbacks.remove(resp.getId());
                }
                c2.complete(resp);
            }
        }
        catch (EOFException | ClosedChannelException e) {
            this.closed = true;
            this.callbacks.forEach((id, c) -> c.completeExceptionally(e));
            this.callbackQueues.forEach((id, cq) -> cq.onError(e));
        }
        catch (IOException e) {
            this.closed = true;
            this.callbacks.forEach((id, c) -> c.completeExceptionally(e));
            this.callbackQueues.forEach((id, cq) -> cq.onError(e));
            if (e.getMessage().contains("An existing connection was forcibly closed by the remote host") && this.disconnectSent) {
                return;
            }
            if (e instanceof SocketException && e.getMessage().contains("Connection reset") && this.disconnectSent) {
                return;
            }
            this.error = e;
            throw new RuntimeException(e);
        }
        catch (Throwable t) {
            this.closed = true;
            this.callbacks.forEach((id, c) -> c.completeExceptionally(t));
            this.callbackQueues.forEach((id, cq) -> cq.onError(t));
            log.error("Unhandled exception", t);
            throw t;
        }
    }

    private Response waitForCompletion(CompletableFuture<Response> f, int timeout) throws PrismInterfaceServiceException {
        try {
            if (timeout == 0) {
                return f.get();
            }
            return f.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new PrismInterfaceServiceException(e);
        }
    }

    private Response completeSynchronously(Request.Builder req, int timeout) throws PrismInterfaceServiceException {
        try {
            CompletableFuture<Response> f = new CompletableFuture<Response>();
            this.callbacks.put(req.getId(), f);
            if (req.getTypeCase() == Request.TypeCase.DISCONNECT_REQUEST) {
                this.disconnectSent = true;
            }
            this.sendMessage(req.build());
            Response resp = this.waitForCompletion(f, timeout);
            if (resp.hasErrorResponse()) {
                throw new PrismInterfaceServiceException(resp.getErrorResponse().getMessage());
            }
            return resp;
        }
        catch (IOException e) {
            throw new PrismInterfaceServiceException(e);
        }
    }

    ConnectionResponse connect(ConnectionRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setConnectionRequest(msg);
        return this.completeSynchronously(req, timeout).getConnectionResponse();
    }

    ConnectionCheckResponse checkConnection(ConnectionCheckRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setConnectionCheckRequest(msg);
        return this.completeSynchronously(req, timeout).getConnectionCheckResponse();
    }

    ConnectionPropertiesUpdateResponse updateConnectionProperties(ConnectionPropertiesUpdateRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setConnectionPropertiesUpdateRequest(msg);
        return this.completeSynchronously(req, timeout).getConnectionPropertiesUpdateResponse();
    }

    DbmsVersionResponse getDbmsVersion(DbmsVersionRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setDbmsVersionRequest(msg);
        return this.completeSynchronously(req, timeout).getDbmsVersionResponse();
    }

    DefaultNamespaceResponse defaultNamespaceRequest(DefaultNamespaceRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setDefaultNamespaceRequest(msg);
        return this.completeSynchronously(req, timeout).getDefaultNamespaceResponse();
    }

    TableTypesResponse getTableTypes(TableTypesRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setTableTypesRequest(msg);
        return this.completeSynchronously(req, timeout).getTableTypesResponse();
    }

    TypesResponse getTypes(TypesRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setTypesRequest(msg);
        return this.completeSynchronously(req, timeout).getTypesResponse();
    }

    ProceduresResponse searchProcedures(ProceduresRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setProceduresRequest(msg);
        return this.completeSynchronously(req, timeout).getProceduresResponse();
    }

    FunctionsResponse searchFunctions(FunctionsRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setFunctionsRequest(msg);
        return this.completeSynchronously(req, timeout).getFunctionsResponse();
    }

    NamespacesResponse searchNamespaces(NamespacesRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setNamespacesRequest(msg);
        return this.completeSynchronously(req, timeout).getNamespacesResponse();
    }

    EntitiesResponse searchEntities(EntitiesRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setEntitiesRequest(msg);
        return this.completeSynchronously(req, timeout).getEntitiesResponse();
    }

    ClientInfoPropertiesResponse setClientInfoProperties(ClientInfoProperties msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setSetClientInfoPropertiesRequest(msg);
        return this.completeSynchronously(req, timeout).getSetClientInfoPropertiesResponse();
    }

    ClientInfoProperties getClientInfoProperties(ClientInfoPropertiesRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setClientInfoPropertiesRequest(msg);
        return this.completeSynchronously(req, timeout).getClientInfoPropertiesResponse();
    }

    MetaStringResponse getSqlStringFunctions(SqlStringFunctionsRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setSqlStringFunctionsRequest(msg);
        return this.completeSynchronously(req, timeout).getSqlStringFunctionsResponse();
    }

    MetaStringResponse getSqlSystemFunctions(SqlSystemFunctionsRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setSqlSystemFunctionsRequest(msg);
        return this.completeSynchronously(req, timeout).getSqlSystemFunctionsResponse();
    }

    MetaStringResponse getSqlTimeDateFunctions(SqlTimeDateFunctionsRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setSqlTimeDateFunctionsRequest(msg);
        return this.completeSynchronously(req, timeout).getSqlTimeDateFunctionsResponse();
    }

    MetaStringResponse getSqlNumericFunctions(SqlNumericFunctionsRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setSqlNumericFunctionsRequest(msg);
        return this.completeSynchronously(req, timeout).getSqlNumericFunctionsResponse();
    }

    MetaStringResponse getSqlKeywords(SqlKeywordsRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setSqlKeywordsRequest(msg);
        return this.completeSynchronously(req, timeout).getSqlKeywordsResponse();
    }

    DisconnectResponse disconnect(DisconnectRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setDisconnectRequest(msg);
        try {
            return this.completeSynchronously(req, timeout).getDisconnectResponse();
        }
        catch (PrismInterfaceServiceException e) {
            if (e.getMessage().contains("An existing connection was forcibly closed by the remote host")) {
                return DisconnectResponse.newBuilder().build();
            }
            throw e;
        }
    }

    CommitResponse commit(CommitRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setCommitRequest(msg);
        return this.completeSynchronously(req, timeout).getCommitResponse();
    }

    RollbackResponse rollback(RollbackRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setRollbackRequest(msg);
        return this.completeSynchronously(req, timeout).getRollbackResponse();
    }

    void executeUnparameterizedStatement(ExecuteUnparameterizedStatementRequest msg, CallbackQueue<StatementResponse> callback) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setExecuteUnparameterizedStatementRequest(msg);
        try {
            this.callbackQueues.put(req.getId(), callback);
            this.sendMessage(req.build());
        }
        catch (IOException e) {
            throw new PrismInterfaceServiceException(e);
        }
    }

    void executeUnparameterizedStatementBatch(ExecuteUnparameterizedStatementBatchRequest msg, CallbackQueue<StatementBatchResponse> callback) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setExecuteUnparameterizedStatementBatchRequest(msg);
        try {
            this.callbackQueues.put(req.getId(), callback);
            this.sendMessage(req.build());
        }
        catch (IOException e) {
            throw new PrismInterfaceServiceException(e);
        }
    }

    PreparedStatementSignature prepareIndexedStatement(PrepareStatementRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setPrepareIndexedStatementRequest(msg);
        return this.completeSynchronously(req, timeout).getPreparedStatementSignature();
    }

    StatementResult executeIndexedStatement(ExecuteIndexedStatementRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setExecuteIndexedStatementRequest(msg);
        return this.completeSynchronously(req, timeout).getStatementResult();
    }

    StatementBatchResponse executeIndexedStatementBatch(ExecuteIndexedStatementBatchRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setExecuteIndexedStatementBatchRequest(msg);
        return this.completeSynchronously(req, timeout).getStatementBatchResponse();
    }

    Frame fetchResult(FetchRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setFetchRequest(msg);
        return this.completeSynchronously(req, timeout).getFrame();
    }

    CloseStatementResponse closeStatement(CloseStatementRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setCloseStatementRequest(msg);
        return this.completeSynchronously(req, timeout).getCloseStatementResponse();
    }

    CloseResultResponse closeResult(CloseResultRequest msg, int timeout) throws PrismInterfaceServiceException {
        Request.Builder req = this.newMessage();
        req.setCloseResultRequest(msg);
        return this.completeSynchronously(req, timeout).getCloseResultResponse();
    }
}

