/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.meta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.polypheny.jdbc.PolyphenyResultSet;
import org.polypheny.jdbc.dependency.prism.ClientInfoPropertyMeta;
import org.polypheny.jdbc.dependency.prism.Column;
import org.polypheny.jdbc.dependency.prism.ForeignKey;
import org.polypheny.jdbc.dependency.prism.Function;
import org.polypheny.jdbc.dependency.prism.Index;
import org.polypheny.jdbc.dependency.prism.Namespace;
import org.polypheny.jdbc.dependency.prism.PrimaryKey;
import org.polypheny.jdbc.dependency.prism.Procedure;
import org.polypheny.jdbc.dependency.prism.Table;
import org.polypheny.jdbc.dependency.prism.TableType;
import org.polypheny.jdbc.dependency.prism.Type;
import org.polypheny.jdbc.dependency.prism.UserDefinedType;
import org.polypheny.jdbc.meta.GenericMetaContainer;
import org.polypheny.jdbc.meta.MetaResultSetComparators;
import org.polypheny.jdbc.meta.MetaResultSetParameter;
import org.polypheny.jdbc.meta.MetaResultSetSignatures;
import org.polypheny.jdbc.meta.PolyphenyColumnMeta;
import org.polypheny.jdbc.types.TypedValue;

public class MetaResultSetBuilder {
    private static <T> PolyphenyResultSet buildEmptyResultSet(String entityName, List<MetaResultSetParameter<T>> metaResultSetParameters) throws SQLException {
        List<PolyphenyColumnMeta> columnMetas = MetaResultSetBuilder.buildMetas(entityName, metaResultSetParameters);
        ArrayList<List<TypedValue>> rows = new ArrayList<List<TypedValue>>();
        return new PolyphenyResultSet(columnMetas, rows);
    }

    private static <T> PolyphenyResultSet buildResultSet(String entityName, List<T> messages, List<MetaResultSetParameter<T>> metaResultSetParameters) throws SQLException {
        List<PolyphenyColumnMeta> columnMetas = MetaResultSetBuilder.buildMetas(entityName, metaResultSetParameters);
        List<List<TypedValue>> rows = MetaResultSetBuilder.buildRows(messages, metaResultSetParameters);
        return new PolyphenyResultSet(columnMetas, rows);
    }

    private static <T> List<PolyphenyColumnMeta> buildMetas(String entityName, List<MetaResultSetParameter<T>> metaResultSetParameters) {
        AtomicInteger ordinal = new AtomicInteger();
        return metaResultSetParameters.stream().map(p -> PolyphenyColumnMeta.fromSpecification(ordinal.getAndIncrement(), p.getName(), entityName, p.getJdbcType())).collect(Collectors.toList());
    }

    private static <T> List<List<TypedValue>> buildRows(List<T> messages, List<MetaResultSetParameter<T>> metaResultSetParameters) throws SQLException {
        ArrayList<List<TypedValue>> arrayLists = new ArrayList<List<TypedValue>>();
        for (T p : messages) {
            arrayLists.add(MetaResultSetBuilder.buildRow(p, metaResultSetParameters));
        }
        return arrayLists;
    }

    private static <T> List<TypedValue> buildRow(T message, List<MetaResultSetParameter<T>> metaResultSetParameters) throws SQLException {
        ArrayList<TypedValue> typedValues = new ArrayList<TypedValue>();
        for (MetaResultSetParameter<T> p : metaResultSetParameters) {
            TypedValue typedValue = p.retrieveFrom(message);
            typedValues.add(typedValue);
        }
        return typedValues;
    }

    public static ResultSet buildFromTables(List<Table> tables) throws SQLException {
        tables = tables.stream().sorted(MetaResultSetComparators.TABLE_COMPARATOR).collect(Collectors.toList());
        return MetaResultSetBuilder.buildResultSet("TABLES", tables, MetaResultSetSignatures.TABLE_SIGNATURE);
    }

    public static ResultSet buildFromTableTypes(List<TableType> tableTypes) throws SQLException {
        return MetaResultSetBuilder.buildResultSet("TABLE_TYPES", tableTypes, MetaResultSetSignatures.TABLE_TYPE_SIGNATURE);
    }

    public static ResultSet buildFromNamespaces(List<Namespace> namespaces) throws SQLException {
        namespaces = namespaces.stream().sorted(MetaResultSetComparators.NAMESPACE_COMPARATOR).collect(Collectors.toList());
        return MetaResultSetBuilder.buildResultSet("NAMESPACES", namespaces, MetaResultSetSignatures.NAMESPACE_SIGNATURE);
    }

    public static ResultSet buildFromColumns(List<Column> columns) throws SQLException {
        columns = columns.stream().sorted(MetaResultSetComparators.COLUMN_COMPARATOR).collect(Collectors.toList());
        return MetaResultSetBuilder.buildResultSet("COLUMNS", columns, MetaResultSetSignatures.COLUMN_SIGNATURE);
    }

    public static ResultSet buildFromPrimaryKeys(List<PrimaryKey> primaryKeys) throws SQLException {
        List metaColumns = primaryKeys.stream().map(MetaResultSetBuilder::expandPrimaryKey).flatMap(Collection::stream).sorted(MetaResultSetComparators.PRIMARY_KEY_COMPARATOR).collect(Collectors.toList());
        return MetaResultSetBuilder.buildResultSet("PRIMARY_KEYS", metaColumns, MetaResultSetSignatures.PRIMARY_KEY_GMC_SIGNATURE);
    }

    private static List<GenericMetaContainer> expandPrimaryKey(PrimaryKey primaryKey) {
        AtomicInteger sequenceIndex = new AtomicInteger(1);
        return primaryKey.getColumnsList().stream().map(c -> new GenericMetaContainer(c.getNamespaceName(), c.getTableName(), c.getColumnName(), sequenceIndex.getAndIncrement(), null)).collect(Collectors.toList());
    }

    public static ResultSet buildFromDatabases(String defaultNamespace) throws SQLException {
        return MetaResultSetBuilder.buildResultSet("CATALOGS", Collections.singletonList(defaultNamespace), MetaResultSetSignatures.CATALOG_SIGNATURE);
    }

    public static ResultSet buildFromImportedKeys(List<ForeignKey> foreignKeys) throws SQLException {
        return MetaResultSetBuilder.buildFromForeignKeys(foreignKeys, "IMPORTED_KEYS", MetaResultSetComparators.IMPORTED_KEYS_COMPARATOR);
    }

    public static ResultSet buildFromExportedKeys(List<ForeignKey> foreignKeys) throws SQLException {
        return MetaResultSetBuilder.buildFromForeignKeys(foreignKeys, "EXPORTED_KEYS", MetaResultSetComparators.EXPORTED_KEYS_COMPARATOR);
    }

    public static ResultSet buildFromCrossReference(List<ForeignKey> foreignKeys) throws SQLException {
        return MetaResultSetBuilder.buildFromForeignKeys(foreignKeys, "CROSS_REFERENCE", MetaResultSetComparators.CROSS_REFERENCE_COMPARATOR);
    }

    private static ResultSet buildFromForeignKeys(List<ForeignKey> foreignKeys, String entityName, Comparator<GenericMetaContainer> comparator) throws SQLException {
        List metaColumns = foreignKeys.stream().map(MetaResultSetBuilder::expandForeignKey).flatMap(Collection::stream).sorted(comparator).collect(Collectors.toList());
        return MetaResultSetBuilder.buildResultSet(entityName, metaColumns, MetaResultSetSignatures.FOREIGN_KEY_GMC_SIGNATURE);
    }

    private static List<GenericMetaContainer> expandForeignKey(ForeignKey foreignKey) {
        AtomicInteger sequenceIndex = new AtomicInteger(1);
        return foreignKey.getForeignColumnsList().stream().map(c -> new GenericMetaContainer(foreignKey.getReferencedNamespaceName(), foreignKey.getReferencedTableName(), c.getNamespaceName(), c.getTableName(), c.getColumnName(), sequenceIndex.getAndIncrement(), foreignKey.getUpdateRule(), foreignKey.getDeleteRule(), foreignKey.getKeyName())).collect(Collectors.toList());
    }

    public static ResultSet buildFromTypes(List<Type> types) throws SQLException {
        types = types.stream().sorted(MetaResultSetComparators.TYPE_INFO_COMPARATOR).collect(Collectors.toList());
        return MetaResultSetBuilder.buildResultSet("TYPE_INFO", types, MetaResultSetSignatures.TYPE_SIGNATURE);
    }

    public static ResultSet buildFromIndexes(List<Index> indexes) throws SQLException {
        List metaColumns = indexes.stream().map(MetaResultSetBuilder::expandIndex).flatMap(Collection::stream).sorted(MetaResultSetComparators.INDEX_COMPARATOR).collect(Collectors.toList());
        return MetaResultSetBuilder.buildResultSet("INDEX_INFO", metaColumns, MetaResultSetSignatures.INDEX_GMC_SIGNATURE);
    }

    private static List<GenericMetaContainer> expandIndex(Index index) {
        AtomicInteger ordinalPosition = new AtomicInteger(1);
        return index.getColumnsList().stream().map(c -> new GenericMetaContainer(index.getNamespaceName(), index.getTableName(), !index.getUnique(), index.getIndexName(), ordinalPosition.getAndIncrement(), c.getColumnName(), index.getLocation(), index.getIndexType())).collect(Collectors.toList());
    }

    public static ResultSet buildFromProcedures(List<Procedure> procedures) throws SQLException {
        return MetaResultSetBuilder.buildEmptyResultSet("PROCEDURES", MetaResultSetSignatures.PROCEDURE_SIGNATURE);
    }

    public static ResultSet buildFromProcedureColumns() throws SQLException {
        return MetaResultSetBuilder.buildEmptyResultSet("PROCEDURE_COLUMNS", MetaResultSetSignatures.PROCEDURE_COLUMN_EMPTY_SIGNATURE);
    }

    public static ResultSet buildFromColumnPrivileges(List<Column> columns, String userName) throws SQLException {
        List columnPrivileges = columns.stream().map(c -> MetaResultSetBuilder.createDummyColumnPrivileges(c, userName)).flatMap(Collection::stream).sorted(MetaResultSetComparators.COLUMN_PRIVILEGE_COMPARATOR).collect(Collectors.toList());
        return MetaResultSetBuilder.buildResultSet("COLUMN_PRIVILEGES", columnPrivileges, MetaResultSetSignatures.COLUMN_PRIVILEGES_GMC_SIGNATURE);
    }

    private static List<GenericMetaContainer> createDummyColumnPrivileges(Column colum, String userName) {
        List<String> accessRights = Arrays.asList("INSERT", "REFERENCE", "SELECT", "UPDATE");
        return accessRights.stream().map(a -> new GenericMetaContainer(colum.getNamespaceName(), colum.getTableName(), colum.getColumnName(), null, userName, a, "NO")).collect(Collectors.toList());
    }

    public static ResultSet buildFromTablePrivileges(List<Table> tables, String userName) throws SQLException {
        List tablePrivileges = tables.stream().map(t -> MetaResultSetBuilder.createDummyTablePrivileges(t, userName)).flatMap(Collection::stream).sorted(MetaResultSetComparators.TABLE_PRIVILEGE_COMPARATOR).collect(Collectors.toList());
        return MetaResultSetBuilder.buildResultSet("TABLE_PRIVILEGES", tablePrivileges, MetaResultSetSignatures.TABLE_PRIVILEGES_GMC_SIGNATURE);
    }

    private static List<GenericMetaContainer> createDummyTablePrivileges(Table table, String userName) {
        List<String> accessRights = Arrays.asList("SELECT", "INSERT", "UPDATE", "DELETE", "REFERENCE");
        return accessRights.stream().map(a -> new GenericMetaContainer(table.getNamespaceName(), table.getTableName(), null, userName, a, "NO")).collect(Collectors.toList());
    }

    public static ResultSet buildFromVersionColumns(List<Column> columns) throws SQLException {
        return MetaResultSetBuilder.buildResultSet("VERSION_COLUMNS", columns, MetaResultSetSignatures.VERSION_COLUMN_SIGNATURE);
    }

    public static ResultSet buildFromSuperTypes() throws SQLException {
        return MetaResultSetBuilder.buildEmptyResultSet("SUPER_TYPES", MetaResultSetSignatures.SUPER_TYPES_EMPTY_SIGNATURE);
    }

    public static ResultSet buildFromSuperTables() throws SQLException {
        return MetaResultSetBuilder.buildEmptyResultSet("SUPER_TABLES", MetaResultSetSignatures.SUPER_TABLES_EMPTY_SIGNATURE);
    }

    public static ResultSet buildFromAttributes() throws SQLException {
        return MetaResultSetBuilder.buildEmptyResultSet("ATTRIBUTES", MetaResultSetSignatures.ATTRIBUTES_EMPTY_SIGNATURE);
    }

    public static ResultSet buildFromClientInfoPropertyMetas(List<ClientInfoPropertyMeta> metas) throws SQLException {
        metas = metas.stream().sorted(MetaResultSetComparators.CLIENT_INFO_PROPERTY_COMPARATOR).collect(Collectors.toList());
        return MetaResultSetBuilder.buildResultSet("CLIENT_INFO_PROPERTIES", metas, MetaResultSetSignatures.CLIENT_INFO_PROPERTY_SIGNATURE);
    }

    public static ResultSet buildFromPseudoColumns(List<Column> columns) throws SQLException {
        columns = columns.stream().sorted(MetaResultSetComparators.PSEUDO_COLUMN_COMPARATOR).collect(Collectors.toList());
        return MetaResultSetBuilder.buildResultSet("PSEUDO_COLUMNS", columns, MetaResultSetSignatures.PSEUDO_COLUMN_SIGNATURE);
    }

    public static ResultSet fromBestRowIdentifiers(List<Column> columns) throws SQLException {
        return MetaResultSetBuilder.buildResultSet("BEST_ROW_IDENTIFIERS", columns, MetaResultSetSignatures.BEST_ROW_IDENTIFIER_SIGNATURE);
    }

    public static ResultSet buildFromUserDefinedTypes(List<UserDefinedType> userDefinedTypes) throws SQLException {
        return MetaResultSetBuilder.buildEmptyResultSet("USER_DEFINED_TYPES", MetaResultSetSignatures.USER_DEFINED_TYPE_EMPTY_SIGNATURE);
    }

    public static ResultSet fromFunctions(List<Function> functions) throws SQLException {
        functions = functions.stream().sorted(MetaResultSetComparators.FUNCTION_COMPARATOR).collect(Collectors.toList());
        return MetaResultSetBuilder.buildResultSet("FUNCTIONS", functions, MetaResultSetSignatures.FUNCTION_SIGNATURE);
    }

    public static ResultSet buildFromFunctionColumns() throws SQLException {
        return MetaResultSetBuilder.buildEmptyResultSet("FUNCTION_COLUMNS", MetaResultSetSignatures.FUNCTION_COLUMN_EMPTY_SIGNATURE);
    }
}

