/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.meta;

import java.util.Comparator;
import org.polypheny.jdbc.dependency.prism.ClientInfoPropertyMeta;
import org.polypheny.jdbc.dependency.prism.Column;
import org.polypheny.jdbc.dependency.prism.Function;
import org.polypheny.jdbc.dependency.prism.Namespace;
import org.polypheny.jdbc.dependency.prism.Table;
import org.polypheny.jdbc.dependency.prism.Type;
import org.polypheny.jdbc.meta.GenericMetaContainer;
import org.polypheny.jdbc.utils.TypedValueUtils;

public class MetaResultSetComparators {
    public static final Comparator<Type> TYPE_INFO_COMPARATOR = Comparator.comparing(t -> TypedValueUtils.getJdbcTypeFromPolyTypeName(t.getTypeName()));
    public static final Comparator<Namespace> NAMESPACE_COMPARATOR = Comparator.comparing(Namespace::getNamespaceName);
    public static final Comparator<GenericMetaContainer> PRIMARY_KEY_COMPARATOR = Comparator.comparing(g -> (String)g.getValue(2));
    public static final Comparator<GenericMetaContainer> INDEX_COMPARATOR = Comparator.comparing(g -> (Boolean)g.getValue(2)).thenComparing(g -> (int)((Integer)g.getValue(7))).thenComparing(g -> (String)g.getValue(3)).thenComparing(g -> (Integer)g.getValue(4));
    public static final Comparator<GenericMetaContainer> IMPORTED_KEYS_COMPARATOR = Comparator.comparing(g -> (String)g.getValue(0)).thenComparing(g -> (String)g.getValue(1)).thenComparing(g -> (Integer)g.getValue(5));
    public static final Comparator<GenericMetaContainer> EXPORTED_KEYS_COMPARATOR = Comparator.comparing(g -> (String)g.getValue(4)).thenComparing(g -> (String)g.getValue(5)).thenComparing(g -> (String)g.getValue(6)).thenComparing(g -> (Integer)g.getValue(8));
    public static final Comparator<GenericMetaContainer> CROSS_REFERENCE_COMPARATOR = EXPORTED_KEYS_COMPARATOR;
    public static final Comparator<Function> FUNCTION_COMPARATOR = Comparator.comparing(Function::getName);
    public static final Comparator<Column> COLUMN_COMPARATOR = Comparator.comparing(Column::getNamespaceName).thenComparing(Column::getTableName).thenComparing(Column::getColumnIndex);
    public static final Comparator<Table> TABLE_COMPARATOR = Comparator.comparing(Table::getTableType).thenComparing(Table::getNamespaceName).thenComparing(Table::getTableName);
    public static final Comparator<Column> PSEUDO_COLUMN_COMPARATOR = Comparator.comparing(Column::getNamespaceName).thenComparing(Column::getTableName).thenComparing(Column::getColumnName);
    public static final Comparator<ClientInfoPropertyMeta> CLIENT_INFO_PROPERTY_COMPARATOR = Comparator.comparing(ClientInfoPropertyMeta::getKey);
    public static final Comparator<GenericMetaContainer> TABLE_PRIVILEGE_COMPARATOR = Comparator.comparing(g -> (String)g.getValue(0)).thenComparing(g -> (String)g.getValue(1)).thenComparing(g -> (String)g.getValue(2)).thenComparing(g -> (String)g.getValue(5));
    public static final Comparator<GenericMetaContainer> COLUMN_PRIVILEGE_COMPARATOR = Comparator.comparing(g -> (String)g.getValue(6));
}

