/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.meta;

import java.sql.PseudoColumnUsage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.polypheny.jdbc.dependency.org.apache.commons.lang3.ObjectUtils;
import org.polypheny.jdbc.dependency.prism.ClientInfoPropertyMeta;
import org.polypheny.jdbc.dependency.prism.Column;
import org.polypheny.jdbc.dependency.prism.Namespace;
import org.polypheny.jdbc.dependency.prism.Procedure;
import org.polypheny.jdbc.dependency.prism.Table;
import org.polypheny.jdbc.dependency.prism.TableType;
import org.polypheny.jdbc.dependency.prism.Type;
import org.polypheny.jdbc.meta.GenericMetaContainer;
import org.polypheny.jdbc.meta.MetaResultSetParameter;
import org.polypheny.jdbc.utils.TypedValueUtils;

public class MetaResultSetSignatures {
    private static final Function DUMMY_ACCESSOR = a -> "Dummy value: Accessor not implemented";
    public static final List<MetaResultSetParameter<Table>> TABLE_SIGNATURE = Arrays.asList(new MetaResultSetParameter<Table>("TABLE_CAT", 12, p -> null), new MetaResultSetParameter<Table>("TABLE_SCHEM", 12, Table::getNamespaceName), new MetaResultSetParameter<Table>("TABLE_NAME", 12, Table::getTableName), new MetaResultSetParameter<Table>("TABLE_TYPE", 12, Table::getTableType), new MetaResultSetParameter<Table>("REMARKS", 12, p -> ""), new MetaResultSetParameter<Table>("TYPE_CAT", 12, p -> null), new MetaResultSetParameter<Table>("TYPE_SCHEM", 12, p -> null), new MetaResultSetParameter<Table>("TYPE_NAME", 12, p -> null), new MetaResultSetParameter<Table>("SELF_REFERENCING_COL_NAME", 12, p -> null), new MetaResultSetParameter<Table>("REF_GENERATION", 12, p -> null));
    public static final List<MetaResultSetParameter<TableType>> TABLE_TYPE_SIGNATURE = Collections.singletonList(new MetaResultSetParameter<TableType>("TABLE_TYPE", 12, TableType::getTableType));
    public static final List<MetaResultSetParameter<Namespace>> NAMESPACE_SIGNATURE = Arrays.asList(new MetaResultSetParameter<Namespace>("TABLE_SCHEM", 12, Namespace::getNamespaceName), new MetaResultSetParameter<Namespace>("TABLE_CATALOG", 12, p -> null), new MetaResultSetParameter<Namespace>("SCHEMA_TYPE", 12, MetaResultSetSignatures.nullIfFalse(Namespace::getNamespaceType, Namespace::hasNamespaceType)));
    public static final List<MetaResultSetParameter<Column>> COLUMN_SIGNATURE = Arrays.asList(new MetaResultSetParameter<Column>("TABLE_CAT", 12, p -> null), new MetaResultSetParameter<Column>("TABLE_SCHEM", 12, Column::getNamespaceName), new MetaResultSetParameter<Column>("TABLE_NAME", 12, Column::getTableName), new MetaResultSetParameter<Column>("COLUMN_NAME", 12, Column::getColumnName), new MetaResultSetParameter<Column>("DATA_TYPE", 4, p -> TypedValueUtils.getJdbcTypeFromPolyTypeName(p.getTypeName())), new MetaResultSetParameter<Column>("TYPE_NAME", 12, Column::getTypeName), new MetaResultSetParameter<Column>("COLUMN_SIZE", 4, MetaResultSetSignatures.nullIfFalse(Column::getTypeLength, Column::hasTypeLength)), new MetaResultSetParameter<Column>("BUFFER_LENGTH", 4, p -> null), new MetaResultSetParameter<Column>("DECIMAL_DIGITS", 4, MetaResultSetSignatures.nullIfFalse(MetaResultSetSignatures.convertScale(Column::getTypeScale), Column::hasTypeScale)), new MetaResultSetParameter<Column>("NUM_PREC_RADIX", 4, p -> null), new MetaResultSetParameter<Column>("NULLABLE", 4, p -> p.getIsNullable() ? 1 : 0), new MetaResultSetParameter<Column>("REMARKS", 12, p -> ""), new MetaResultSetParameter<Column>("COLUMN_DEF", 12, MetaResultSetSignatures.nullIfFalse(Column::getDefaultValueAsString, Column::hasDefaultValueAsString)), new MetaResultSetParameter<Column>("SQL_DATA_TYPE", 4, p -> null), new MetaResultSetParameter<Column>("SQL_DATETIME_SUB", 4, p -> null), new MetaResultSetParameter<Column>("CHAR_OCTET_LENGTH", 4, p -> null), new MetaResultSetParameter<Column>("ORDINAL_POSITION", 4, Column::getColumnIndex), new MetaResultSetParameter<Column>("IS_NULLABLE", 12, p -> p.getIsNullable() ? "YES" : "NO"), new MetaResultSetParameter<Column>("SCOPE_CATALOG", 12, p -> null), new MetaResultSetParameter<Column>("SCOPE_SCHEMA", 12, p -> null), new MetaResultSetParameter<Column>("SCOPE_TABLE", 12, p -> null), new MetaResultSetParameter<Column>("SOURCE_DATA_TYPE", 5, p -> null), new MetaResultSetParameter<Column>("IS_AUTOINCREMENT", 12, p -> "NO"), new MetaResultSetParameter<Column>("IS_GENERATEDCOLUMN", 12, p -> "NO"), new MetaResultSetParameter<Column>("COLLATION", 12, MetaResultSetSignatures.nullIfFalse(Column::getCollation, Column::hasCollation)));
    public static final List<MetaResultSetParameter<GenericMetaContainer>> PRIMARY_KEY_GMC_SIGNATURE = Arrays.asList(new MetaResultSetParameter<GenericMetaContainer>("TABLE_CAT", 12, p -> null), new MetaResultSetParameter<GenericMetaContainer>("TABLE_SCHEM", 12, p -> p.getValue(0)), new MetaResultSetParameter<GenericMetaContainer>("TABLE_NAME", 12, p -> p.getValue(1)), new MetaResultSetParameter<GenericMetaContainer>("COLUMN_NAME", 12, p -> p.getValue(2)), new MetaResultSetParameter<GenericMetaContainer>("KEY_SEQ", 5, p -> p.getValue(3)), new MetaResultSetParameter<GenericMetaContainer>("PK_NAME", 12, p -> p.getValue(4)));
    public static final List<MetaResultSetParameter<String>> CATALOG_SIGNATURE = Arrays.asList(new MetaResultSetParameter<String>("TABLE_CAT", 12, s -> "APP"), new MetaResultSetParameter<String>("DEFAULT_SCHEMA", 12, s -> s));
    public static final List<MetaResultSetParameter<GenericMetaContainer>> FOREIGN_KEY_GMC_SIGNATURE = Arrays.asList(new MetaResultSetParameter<GenericMetaContainer>("PKTABLE_CAT", 12, p -> null), new MetaResultSetParameter<GenericMetaContainer>("PKTABLE_SCHEM", 12, p -> p.getValue(0)), new MetaResultSetParameter<GenericMetaContainer>("PKTABLE_NAME", 12, p -> p.getValue(1)), new MetaResultSetParameter<GenericMetaContainer>("PKCOLUMN_NAME", 12, p -> null), new MetaResultSetParameter<GenericMetaContainer>("FKTABLE_CAT", 12, p -> null), new MetaResultSetParameter<GenericMetaContainer>("FKTABLE_SCHEM", 12, p -> p.getValue(2)), new MetaResultSetParameter<GenericMetaContainer>("FKTABLE_NAME", 12, p -> p.getValue(3)), new MetaResultSetParameter<GenericMetaContainer>("FKCOLUMN_NAME", 12, p -> p.getValue(4)), new MetaResultSetParameter<GenericMetaContainer>("KEY_SEQ", 5, p -> p.getValue(5)), new MetaResultSetParameter<GenericMetaContainer>("UPDATE_RULE", 5, p -> p.getValue(6)), new MetaResultSetParameter<GenericMetaContainer>("DELETE_RULE", 5, p -> p.getValue(7)), new MetaResultSetParameter<GenericMetaContainer>("FK_NAME", 12, p -> p.getValue(8)), new MetaResultSetParameter<GenericMetaContainer>("PK_NAME", 12, p -> null), new MetaResultSetParameter<GenericMetaContainer>("DEFERRABILITY", 5, p -> null));
    public static final List<MetaResultSetParameter<Type>> TYPE_SIGNATURE = Arrays.asList(new MetaResultSetParameter<Type>("TYPE_NAME", 12, Type::getTypeName), new MetaResultSetParameter<Type>("DATA_TYPE", 4, t -> TypedValueUtils.getJdbcTypeFromPolyTypeName(t.getTypeName())), new MetaResultSetParameter<Type>("PRECISION", 4, Type::getPrecision), new MetaResultSetParameter<Type>("LITERAL_PREFIX", 12, MetaResultSetSignatures.nullIfFalse(Type::getLiteralPrefix, Type::hasLiteralPrefix)), new MetaResultSetParameter<Type>("LITERAL_SUFFIX", 12, MetaResultSetSignatures.nullIfFalse(Type::getLiteralSuffix, Type::hasLiteralSuffix)), new MetaResultSetParameter<Type>("CREATE_PARAMS", 12, p -> null), new MetaResultSetParameter<Type>("NULLABLE", 5, p -> 1), new MetaResultSetParameter<Type>("CASE_SENSITIVE", 16, Type::getIsCaseSensitive), new MetaResultSetParameter<Type>("SEARCHABLE", 5, MetaResultSetSignatures.integerAsShort(Type::getIsSearchable)), new MetaResultSetParameter<Type>("UNSIGNED_ATTRIBUTE", 16, p -> false), new MetaResultSetParameter<Type>("FIXED_PREC_SCALE", 16, p -> false), new MetaResultSetParameter<Type>("AUTO_INCREMENT", 16, Type::getIsAutoIncrement), new MetaResultSetParameter<Type>("LOCAL_TYPE_NAME", 12, Type::getTypeName), new MetaResultSetParameter<Type>("MINIMUM_SCALE", 5, MetaResultSetSignatures.convertScale(Type::getMinScale)), new MetaResultSetParameter<Type>("MAXIMUM_SCALE", 5, MetaResultSetSignatures.convertScale(Type::getMaxScale)), new MetaResultSetParameter<Type>("SQL_DATA_TYPE", 4, p -> null), new MetaResultSetParameter<Type>("SQL_DATETIME_SUB", 4, p -> null), new MetaResultSetParameter<Type>("NUM_PREC_RADIX", 4, Type::getRadix));
    public static final List<MetaResultSetParameter<GenericMetaContainer>> INDEX_GMC_SIGNATURE = Arrays.asList(new MetaResultSetParameter<GenericMetaContainer>("TABLE_CAT", 12, p -> null), new MetaResultSetParameter<GenericMetaContainer>("TABLE_SCHEM", 12, p -> p.getValue(0)), new MetaResultSetParameter<GenericMetaContainer>("TABLE_NAME", 12, p -> p.getValue(1)), new MetaResultSetParameter<GenericMetaContainer>("NON_UNIQUE", 16, p -> p.getValue(2)), new MetaResultSetParameter<GenericMetaContainer>("INDEX_QUALIFIER", 12, p -> null), new MetaResultSetParameter<GenericMetaContainer>("INDEX_NAME", 12, p -> p.getValue(3)), new MetaResultSetParameter<GenericMetaContainer>("TYPE", -6, p -> 0), new MetaResultSetParameter<GenericMetaContainer>("ORDINAL_POSITION", -6, MetaResultSetSignatures.integerAsShort(p -> p.getValue(4))), new MetaResultSetParameter<GenericMetaContainer>("COLUMN_NAME", 12, p -> p.getValue(5)), new MetaResultSetParameter<GenericMetaContainer>("ASC_OR_DESC", 12, p -> null), new MetaResultSetParameter<GenericMetaContainer>("CARDINALITY", -5, p -> -1L), new MetaResultSetParameter<GenericMetaContainer>("PAGES", -5, p -> null), new MetaResultSetParameter<GenericMetaContainer>("FILTER_CONDITION", 12, p -> null), new MetaResultSetParameter<GenericMetaContainer>("LOCATION", 4, p -> p.getValue(6)), new MetaResultSetParameter<GenericMetaContainer>("INDEX_TYPE", 4, p -> p.getValue(7)));
    public static final List<MetaResultSetParameter<Procedure>> PROCEDURE_SIGNATURE = Arrays.asList(new MetaResultSetParameter<Procedure>("PROCEDURE_CAT", 12, p -> null), new MetaResultSetParameter<Procedure>("PROCEDURE_SCHEM", 12, p -> null), new MetaResultSetParameter<Procedure>("PROCEDURE_NAME", 12, Procedure::getTrivialName), new MetaResultSetParameter<Procedure>("reserved for future use", 12, p -> null), new MetaResultSetParameter<Procedure>("reserved for future use", 12, p -> null), new MetaResultSetParameter<Procedure>("reserved for future use", 12, p -> null), new MetaResultSetParameter<Procedure>("REMARKS", 12, Procedure::getDescription), new MetaResultSetParameter<Procedure>("PROCEDURE_TYPE", -6, Procedure::getReturnTypeValue), new MetaResultSetParameter<Procedure>("SPECIFIC_NAME", 12, Procedure::getUniqueName));
    public static final List<MetaResultSetParameter<ObjectUtils.Null>> PROCEDURE_COLUMN_EMPTY_SIGNATURE = Arrays.asList(new MetaResultSetParameter("PROCEDURE_CAT", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("PROCEDURE_SCHEM", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("PROCEDURE_NAME", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("COLUMN_NAME", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("COLUMN_TYPE", -6, DUMMY_ACCESSOR), new MetaResultSetParameter("DATA_TYPE", 4, DUMMY_ACCESSOR), new MetaResultSetParameter("TYPE_NAME", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("PRECISION", 4, DUMMY_ACCESSOR), new MetaResultSetParameter("LENGTH", 4, DUMMY_ACCESSOR), new MetaResultSetParameter("SCALE", -6, DUMMY_ACCESSOR), new MetaResultSetParameter("RADIX", -6, DUMMY_ACCESSOR), new MetaResultSetParameter("NULLABLE", -6, DUMMY_ACCESSOR), new MetaResultSetParameter("REMARKS", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("COLUMN_DEF", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SQL_DATA_TYPE", 4, DUMMY_ACCESSOR), new MetaResultSetParameter("SQL_DATETIME_SUB", 4, DUMMY_ACCESSOR), new MetaResultSetParameter("CHAR_OCTET_LENGTH", 4, DUMMY_ACCESSOR), new MetaResultSetParameter("ORDINAL_POSITION", 4, DUMMY_ACCESSOR), new MetaResultSetParameter("IS_NULLABLE", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SPECIFIC_NAME", 12, DUMMY_ACCESSOR));
    public static final List<MetaResultSetParameter<GenericMetaContainer>> COLUMN_PRIVILEGES_GMC_SIGNATURE = Arrays.asList(new MetaResultSetParameter<GenericMetaContainer>("TABLE_CAT", 12, p -> null), new MetaResultSetParameter<GenericMetaContainer>("TABLE_SCHEM", 12, p -> p.getValue(0)), new MetaResultSetParameter<GenericMetaContainer>("TABLE_NAME", 12, p -> p.getValue(1)), new MetaResultSetParameter<GenericMetaContainer>("COLUMN_NAME", 12, p -> p.getValue(2)), new MetaResultSetParameter<GenericMetaContainer>("GRANTOR", 12, p -> p.getValue(3)), new MetaResultSetParameter<GenericMetaContainer>("GRANTEE", 12, p -> p.getValue(4)), new MetaResultSetParameter<GenericMetaContainer>("PRIVILEGE", 12, p -> p.getValue(5)), new MetaResultSetParameter<GenericMetaContainer>("IS_GRANTABLE", 12, p -> p.getValue(6)));
    public static final List<MetaResultSetParameter<GenericMetaContainer>> TABLE_PRIVILEGES_GMC_SIGNATURE = Arrays.asList(new MetaResultSetParameter<GenericMetaContainer>("TABLE_CAT", 12, p -> p.getValue(0)), new MetaResultSetParameter<GenericMetaContainer>("TABLE_SCHEM", 12, p -> p.getValue(1)), new MetaResultSetParameter<GenericMetaContainer>("TABLE_NAME", 12, p -> p.getValue(2)), new MetaResultSetParameter<GenericMetaContainer>("GRANTOR", 12, p -> p.getValue(3)), new MetaResultSetParameter<GenericMetaContainer>("GRANTEE ", 12, p -> p.getValue(4)), new MetaResultSetParameter<GenericMetaContainer>("PRIVILEGE", 12, p -> p.getValue(5)), new MetaResultSetParameter<GenericMetaContainer>("IS_GRANTABLE", 12, p -> p.getValue(6)));
    public static final List<MetaResultSetParameter<Column>> VERSION_COLUMN_SIGNATURE = Arrays.asList(new MetaResultSetParameter<Column>("SCOPE", -6, p -> null), new MetaResultSetParameter<Column>("COLUMN_NAME", 12, Column::getColumnName), new MetaResultSetParameter<Column>("DATA_TYPE", 4, p -> TypedValueUtils.getJdbcTypeFromPolyTypeName(p.getTypeName())), new MetaResultSetParameter<Column>("TYPE_NAME", 12, Column::getTypeName), new MetaResultSetParameter<Column>("COLUMN_SIZE", 4, Column::getTypeLength), new MetaResultSetParameter<Column>("BUFFER_LENGTH", 4, p -> null), new MetaResultSetParameter<Column>("DECIMAL_DIGITS", -6, MetaResultSetSignatures.nullIfFalse(MetaResultSetSignatures.convertScale(Column::getTypeScale), Column::hasTypeScale)), new MetaResultSetParameter<Column>("PSEUDO_COLUMN", -6, p -> p.getIsHidden() ? 2 : 1));
    public static final List<MetaResultSetParameter<ObjectUtils.Null>> SUPER_TYPES_EMPTY_SIGNATURE = Arrays.asList(new MetaResultSetParameter("TYPE_CAT", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("TYPE_SCHEM", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("TYPE_NAME", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SUPERTYPE_CAT", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SUPERTYPE_SCHEM", 4, DUMMY_ACCESSOR), new MetaResultSetParameter("SUPERTYPE_NAME", 12, DUMMY_ACCESSOR));
    public static final List<MetaResultSetParameter<ObjectUtils.Null>> SUPER_TABLES_EMPTY_SIGNATURE = Arrays.asList(new MetaResultSetParameter("TABLE_CAT", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("TABLE_SCHEM", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("TABLE_NAME", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SUPERTABLE_NAME", 12, DUMMY_ACCESSOR));
    public static final List<MetaResultSetParameter<ObjectUtils.Null>> ATTRIBUTES_EMPTY_SIGNATURE = Arrays.asList(new MetaResultSetParameter("TABLE_CAT", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("TABLE_SCHEM", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("TABLE_NAME", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("ATTR_NAME", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("DATA_TYPE", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("ATTR_TYPE_NAME", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("ATTR_SIZE", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("DECIMAL_DIGITS", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("NUM_PREC_RADIX", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("NULLABLE", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("REMARKS", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("ATTR_DEF", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SQL_DATA_TYPE", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SQL_DATETIME_SUB", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("CHAR_OCTET_LENGTH", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("ORDINAL_POSITION", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("IS_NULLABLE", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SCOPE_CATALOG", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SCOPE_SCHEMA", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SCOPE_TABLE", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SOURCE_DATA_TYPE", 12, DUMMY_ACCESSOR));
    public static final List<MetaResultSetParameter<ClientInfoPropertyMeta>> CLIENT_INFO_PROPERTY_SIGNATURE = Arrays.asList(new MetaResultSetParameter<ClientInfoPropertyMeta>("NAME", 12, ClientInfoPropertyMeta::getKey), new MetaResultSetParameter<ClientInfoPropertyMeta>("MAX_LEN", 12, ClientInfoPropertyMeta::getMaxlength), new MetaResultSetParameter<ClientInfoPropertyMeta>("DEFAULT_VALUE", 12, ClientInfoPropertyMeta::getDefaultValue), new MetaResultSetParameter<ClientInfoPropertyMeta>("DESCRIPTION", 12, ClientInfoPropertyMeta::getDescription));
    public static final List<MetaResultSetParameter<Column>> PSEUDO_COLUMN_SIGNATURE = Arrays.asList(new MetaResultSetParameter<Column>("TABLE_CAT", 12, p -> null), new MetaResultSetParameter<Column>("TABLE_SCHEM", 12, Column::getNamespaceName), new MetaResultSetParameter<Column>("TABLE_NAME", 12, Column::getTableName), new MetaResultSetParameter<Column>("COLUMN_NAME", 12, Column::getColumnName), new MetaResultSetParameter<Column>("DATA_TYPE", 12, p -> TypedValueUtils.getJdbcTypeFromPolyTypeName(p.getTypeName())), new MetaResultSetParameter<Column>("COLUMN_SIZE", 4, MetaResultSetSignatures.nullIfFalse(Column::getTypeLength, Column::hasTypeLength)), new MetaResultSetParameter<Column>("DECIMAL_DIGITS", 4, MetaResultSetSignatures.nullIfFalse(MetaResultSetSignatures.convertScale(Column::getTypeScale), Column::hasTypeScale)), new MetaResultSetParameter<Column>("NUM_PREC_RADIX", 4, p -> null), new MetaResultSetParameter<Column>("COLUMN_USAGE", 12, p -> PseudoColumnUsage.USAGE_UNKNOWN), new MetaResultSetParameter<Column>("REMARKS", 12, p -> ""), new MetaResultSetParameter<Column>("CHAR_OCTET_LENGTH", 4, p -> null), new MetaResultSetParameter<Column>("IS_NULLABLE", 12, p -> p.getIsNullable() ? "YES" : "NO"));
    public static final List<MetaResultSetParameter<Column>> BEST_ROW_IDENTIFIER_SIGNATURE = Arrays.asList(new MetaResultSetParameter<Column>("SCOPE", 5, MetaResultSetSignatures.integerAsShort(p -> 2)), new MetaResultSetParameter<Column>("COLUMN_NAME", 12, Column::getColumnName), new MetaResultSetParameter<Column>("DATA_TYPE", 4, p -> TypedValueUtils.getJdbcTypeFromPolyTypeName(p.getTypeName())), new MetaResultSetParameter<Column>("TYPE_NAME", 12, Column::getTypeName), new MetaResultSetParameter<Column>("COLUMN_SIZE", 4, MetaResultSetSignatures.nullIfFalse(Column::getTypeLength, Column::hasTypeLength)), new MetaResultSetParameter<Column>("BUFFER_LENGTH", 4, p -> null), new MetaResultSetParameter<Column>("DECIMAL_DIGITS", 5, MetaResultSetSignatures.nullIfFalse(MetaResultSetSignatures.convertScale(Column::getTypeScale), Column::hasTypeScale)), new MetaResultSetParameter<Column>("PSEUDO_COLUMN", 5, p -> p.getIsHidden() ? 2 : 1));
    public static final List<MetaResultSetParameter<ObjectUtils.Null>> USER_DEFINED_TYPE_EMPTY_SIGNATURE = Arrays.asList(new MetaResultSetParameter("TYPE_CAT", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("TYPE_SCHEM", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("TYPE_NAME", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("CLASS_NAME", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("DATA_TYPE", 4, DUMMY_ACCESSOR), new MetaResultSetParameter("REMARKS", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("BASE_TYPE", 5, DUMMY_ACCESSOR));
    public static final List<MetaResultSetParameter<org.polypheny.jdbc.dependency.prism.Function>> FUNCTION_SIGNATURE = Arrays.asList(new MetaResultSetParameter<org.polypheny.jdbc.dependency.prism.Function>("FUNCTION_CAT", 12, p -> null), new MetaResultSetParameter<org.polypheny.jdbc.dependency.prism.Function>("FUNCTION_SCHEM", 12, p -> null), new MetaResultSetParameter<org.polypheny.jdbc.dependency.prism.Function>("FUNCTION_NAME", 12, org.polypheny.jdbc.dependency.prism.Function::getName), new MetaResultSetParameter<org.polypheny.jdbc.dependency.prism.Function>("REMARKS", 12, org.polypheny.jdbc.dependency.prism.Function::getSyntax), new MetaResultSetParameter<org.polypheny.jdbc.dependency.prism.Function>("FUNCTION_TYPE", 5, p -> p.getIsTableFunction() ? 2 : 1), new MetaResultSetParameter<org.polypheny.jdbc.dependency.prism.Function>("REMARKS", 12, org.polypheny.jdbc.dependency.prism.Function::getName));
    public static final List<MetaResultSetParameter<ObjectUtils.Null>> FUNCTION_COLUMN_EMPTY_SIGNATURE = Arrays.asList(new MetaResultSetParameter("FUNCTION_CAT", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("FUNCTION_SCHEM", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("FUNCTION_NAME", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("COLUMN_NAME", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("COLUMN_TYPE", 4, DUMMY_ACCESSOR), new MetaResultSetParameter("DATA_TYPE", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("TYPE_NAME", 5, DUMMY_ACCESSOR), new MetaResultSetParameter("PRECISION", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("LENGTH", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SCALE", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("RADIX", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("NULLABLE", 4, DUMMY_ACCESSOR), new MetaResultSetParameter("REMARKS", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("CHAR_OCTET_LENGTH", 5, DUMMY_ACCESSOR), new MetaResultSetParameter("ORDINAL_POSITION", 4, DUMMY_ACCESSOR), new MetaResultSetParameter("IS_NULLABLE", 12, DUMMY_ACCESSOR), new MetaResultSetParameter("SPECIFIC_NAME", 5, DUMMY_ACCESSOR));

    private static <T> Function<T, Object> nullIfFalse(Function<T, Object> accessor, Function<T, Boolean> booleanFunction) {
        return message -> {
            if (((Boolean)booleanFunction.apply(message)).booleanValue()) {
                return accessor.apply(message);
            }
            return null;
        };
    }

    private static <T> Function<T, Object> integerAsShort(Function<T, Object> accessor) {
        return message -> {
            Object value = accessor.apply(message);
            if (value instanceof Integer) {
                return ((Integer)value).shortValue();
            }
            throw new IllegalArgumentException("Can't convert this value to a short");
        };
    }

    private static <T> Function<T, Object> convertScale(Function<T, Object> accessor) {
        return message -> {
            Object value = accessor.apply(message);
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("Can't convert this value to a short");
            }
            Integer integer = (Integer)value;
            if (integer == -1) {
                return 0;
            }
            return integer.shortValue();
        };
    }
}

