/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.meta;

import java.util.List;
import org.polypheny.jdbc.BidirectionalScrollable;
import org.polypheny.jdbc.PrismInterfaceServiceException;

public class MetaScroller<T>
implements BidirectionalScrollable<T> {
    private static final int CURSOR_BEFORE_DATA = -1;
    private final List<T> data;
    private T current;
    private int currentIndex;

    public MetaScroller(List<T> rows) {
        this.data = rows;
        this.current = null;
        this.currentIndex = -1;
    }

    private int rowToIndex(int row) {
        return row - 1;
    }

    private int indexToRow(int index) {
        return index + 1;
    }

    @Override
    public void fetchAllAndSync() {
    }

    @Override
    public boolean absolute(int rowIndex) {
        if (rowIndex == 0) {
            this.current = null;
            this.currentIndex = -1;
            return false;
        }
        if (rowIndex > 0) {
            this.current = null;
            this.currentIndex = this.rowToIndex(rowIndex);
            if (this.currentIndex >= this.data.size()) {
                this.currentIndex = this.data.size();
                return false;
            }
            this.current = this.data.get(this.currentIndex);
            return true;
        }
        return this.accessFromBack(rowIndex);
    }

    private boolean accessFromBack(int rowIndex) {
        this.current = null;
        this.currentIndex = this.data.size() + rowIndex;
        if (this.currentIndex > -1) {
            this.current = this.data.get(this.currentIndex);
            return true;
        }
        this.currentIndex = -1;
        return false;
    }

    @Override
    public boolean relative(int offset) {
        this.current = null;
        this.currentIndex += offset;
        if (this.currentIndex < 0) {
            this.currentIndex = -1;
            return false;
        }
        if (this.currentIndex >= this.data.size()) {
            this.currentIndex = this.data.size();
            return false;
        }
        this.current = this.data.get(this.currentIndex);
        return true;
    }

    @Override
    public boolean previous() {
        this.current = null;
        --this.currentIndex;
        if (this.currentIndex > -1 && this.currentIndex < this.data.size()) {
            this.current = this.data.get(this.currentIndex);
            return true;
        }
        this.currentIndex = -1;
        return false;
    }

    @Override
    public void beforeFirst() {
        this.current = null;
        this.currentIndex = -1;
    }

    @Override
    public void afterLast() {
        this.current = null;
        this.currentIndex = this.data.size();
    }

    @Override
    public boolean first() {
        this.current = null;
        this.currentIndex = -1;
        if (this.data.isEmpty()) {
            return false;
        }
        this.currentIndex = 0;
        this.current = this.data.get(this.currentIndex);
        return true;
    }

    @Override
    public boolean last() {
        this.current = null;
        this.currentIndex = -1;
        if (this.data.isEmpty()) {
            return false;
        }
        this.currentIndex = this.data.size() - 1;
        this.current = this.data.get(this.currentIndex);
        return true;
    }

    @Override
    public boolean next() throws PrismInterfaceServiceException {
        this.current = null;
        ++this.currentIndex;
        if (this.currentIndex >= this.data.size()) {
            this.currentIndex = this.data.size();
            return false;
        }
        this.current = this.data.get(this.currentIndex);
        return true;
    }

    @Override
    public T current() {
        return this.current;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isBeforeFirst() {
        return this.currentIndex == -1;
    }

    @Override
    public boolean isAfterLast() {
        return this.data.isEmpty() || this.currentIndex >= this.data.size();
    }

    @Override
    public boolean isFirst() {
        return this.currentIndex == 0;
    }

    @Override
    public boolean isLast() {
        return this.currentIndex == this.data.size() - 1;
    }

    @Override
    public int getRow() {
        if (this.currentIndex < 0) {
            return 0;
        }
        if (this.currentIndex >= this.data.size()) {
            return 0;
        }
        return this.indexToRow(this.currentIndex);
    }

    @Override
    public boolean hasCurrent() {
        return this.current != null;
    }
}

