/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.meta;

import java.sql.JDBCType;
import lombok.Generated;
import org.polypheny.jdbc.dependency.org.apache.commons.lang3.NotImplementedException;
import org.polypheny.jdbc.dependency.prism.ColumnMeta;
import org.polypheny.jdbc.dependency.prism.ProtoPolyType;
import org.polypheny.jdbc.types.ProtoToJdbcTypeMap;

public class PolyphenyColumnMeta {
    private final int ordinal;
    private final boolean autoIncrement;
    private final boolean caseSensitive;
    private final boolean searchable;
    private final boolean currency;
    private final int nullable;
    private final boolean signed;
    private final int displaySize;
    private final String columnLabel;
    private final String columnName;
    private final String namespace;
    private final int precision;
    private final int scale;
    private final String tableName;
    private final String catalogName;
    private final boolean readOnly;
    private final boolean writable;
    private final boolean definitelyWritable;
    private final String columnClassName;
    private final int sqlType;
    private final String polyphenyFieldTypeName;

    public PolyphenyColumnMeta(ColumnMeta protoColumnMeta) {
        this.ordinal = protoColumnMeta.getColumnIndex();
        this.autoIncrement = false;
        this.caseSensitive = true;
        this.searchable = false;
        this.currency = false;
        this.nullable = protoColumnMeta.getIsNullable() ? 1 : 0;
        this.signed = false;
        this.displaySize = protoColumnMeta.getLength();
        this.columnLabel = protoColumnMeta.getColumnLabel();
        this.columnName = protoColumnMeta.getColumnName();
        this.namespace = protoColumnMeta.getNamespace();
        this.precision = protoColumnMeta.getPrecision();
        this.scale = 1;
        this.tableName = protoColumnMeta.getEntityName();
        this.catalogName = "";
        this.readOnly = false;
        this.writable = false;
        this.definitelyWritable = false;
        this.columnClassName = "";
        if (protoColumnMeta.getTypeMeta().getProtoValueType() == ProtoPolyType.USER_DEFINED_TYPE) {
            throw new NotImplementedException("Struct types not implemented yet");
        }
        if (protoColumnMeta.getTypeMeta().getProtoValueType() == ProtoPolyType.ARRAY) {
            ProtoPolyType type = protoColumnMeta.getTypeMeta().getArrayMeta().getElementType().getProtoValueType();
            this.sqlType = JDBCType.ARRAY.getVendorTypeNumber();
            this.polyphenyFieldTypeName = type.name();
            return;
        }
        ProtoPolyType type = protoColumnMeta.getTypeMeta().getProtoValueType();
        this.sqlType = ProtoToJdbcTypeMap.getJdbcTypeFromProto(type);
        this.polyphenyFieldTypeName = type.name();
    }

    public static PolyphenyColumnMeta fromSpecification(int ordinal, String columnLabel, String entityName, int jdcType) {
        return new PolyphenyColumnMeta(ordinal, columnLabel, entityName, jdcType);
    }

    private PolyphenyColumnMeta(int ordinal, String columnLabel, String entityName, int jdbcType) {
        this.ordinal = ordinal;
        this.autoIncrement = false;
        this.caseSensitive = true;
        this.searchable = false;
        this.currency = false;
        this.nullable = 1;
        this.signed = false;
        this.displaySize = -1;
        this.columnLabel = columnLabel;
        this.columnName = columnLabel;
        this.namespace = null;
        this.precision = -1;
        this.scale = 1;
        this.tableName = entityName;
        this.catalogName = "";
        this.readOnly = false;
        this.writable = false;
        this.definitelyWritable = false;
        this.columnClassName = "";
        this.sqlType = jdbcType;
        this.polyphenyFieldTypeName = "";
    }

    @Generated
    public int getOrdinal() {
        return this.ordinal;
    }

    @Generated
    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    @Generated
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Generated
    public boolean isSearchable() {
        return this.searchable;
    }

    @Generated
    public boolean isCurrency() {
        return this.currency;
    }

    @Generated
    public int getNullable() {
        return this.nullable;
    }

    @Generated
    public boolean isSigned() {
        return this.signed;
    }

    @Generated
    public int getDisplaySize() {
        return this.displaySize;
    }

    @Generated
    public String getColumnLabel() {
        return this.columnLabel;
    }

    @Generated
    public String getColumnName() {
        return this.columnName;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public int getPrecision() {
        return this.precision;
    }

    @Generated
    public int getScale() {
        return this.scale;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Generated
    public boolean isWritable() {
        return this.writable;
    }

    @Generated
    public boolean isDefinitelyWritable() {
        return this.definitelyWritable;
    }

    @Generated
    public String getColumnClassName() {
        return this.columnClassName;
    }

    @Generated
    public int getSqlType() {
        return this.sqlType;
    }

    @Generated
    public String getPolyphenyFieldTypeName() {
        return this.polyphenyFieldTypeName;
    }
}

