/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.polypheny.jdbc.ConnectionString;
import org.polypheny.jdbc.PolyConnection;
import org.polypheny.jdbc.PrismInterfaceClient;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.prism.Column;
import org.polypheny.jdbc.dependency.prism.DbmsVersionResponse;
import org.polypheny.jdbc.dependency.prism.Entity;
import org.polypheny.jdbc.dependency.prism.ForeignKey;
import org.polypheny.jdbc.dependency.prism.Function;
import org.polypheny.jdbc.dependency.prism.Index;
import org.polypheny.jdbc.dependency.prism.Namespace;
import org.polypheny.jdbc.dependency.prism.PrimaryKey;
import org.polypheny.jdbc.dependency.prism.Procedure;
import org.polypheny.jdbc.dependency.prism.Table;
import org.polypheny.jdbc.dependency.prism.TableType;
import org.polypheny.jdbc.dependency.prism.Type;
import org.polypheny.jdbc.meta.MetaResultSetBuilder;
import org.polypheny.jdbc.meta.MetaUtils;
import org.polypheny.jdbc.properties.DriverProperties;
import org.polypheny.jdbc.properties.PropertyUtils;

public class PolyphenyDatabaseMetadata
implements DatabaseMetaData {
    private static final int NO_VERSION = -1;
    private ConnectionString connectionString;
    private NullSorting nullSorting;
    private PrismInterfaceClient prismInterfaceClient;
    private PolyConnection polyConnection;
    private String productName;
    private String productVersion;
    private int databaseMinorVersion = -1;
    private int databaseMajorVersion = -1;

    public PolyphenyDatabaseMetadata(PrismInterfaceClient prismInterfaceClient, ConnectionString target) {
        this.prismInterfaceClient = prismInterfaceClient;
        this.connectionString = target;
        this.nullSorting = NullSorting.END;
    }

    private void throwNotSupportedIfStrict() throws SQLFeatureNotSupportedException {
        if (!this.polyConnection.isStrict()) {
            return;
        }
        throw new SQLFeatureNotSupportedException();
    }

    public void setConnection(PolyConnection connection) {
        this.polyConnection = connection;
    }

    private void fetchDbmsVersionInfo() throws SQLException {
        DbmsVersionResponse response = this.prismInterfaceClient.getDbmsVersion(this.getConnection().getNetworkTimeout());
        this.productName = response.getDbmsName();
        this.productVersion = response.getVersionName();
        this.databaseMinorVersion = response.getMinorVersion();
        this.databaseMajorVersion = response.getMajorVersion();
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        if (this.connectionString == null) {
            return null;
        }
        return DriverProperties.getDRIVER_URL_SCHEMA() + "//" + this.connectionString.getTarget();
    }

    @Override
    public String getUserName() throws SQLException {
        if (this.connectionString == null) {
            return null;
        }
        return this.connectionString.getUser();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return PropertyUtils.isDEFAULT_READ_ONLY();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.nullSorting == NullSorting.HIGH;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.nullSorting == NullSorting.LOW;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.nullSorting == NullSorting.START;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.nullSorting == NullSorting.END;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        if (this.productName == null) {
            this.fetchDbmsVersionInfo();
        }
        return this.productName;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (this.productVersion == null) {
            this.fetchDbmsVersionInfo();
        }
        return this.productVersion;
    }

    @Override
    public String getDriverName() throws SQLException {
        return DriverProperties.getDRIVER_NAME();
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return DriverProperties.getDRIVER_VERSION();
    }

    @Override
    public int getDriverMajorVersion() {
        return DriverProperties.getDRIVER_MAJOR_VERSION();
    }

    @Override
    public int getDriverMinorVersion() {
        return DriverProperties.getDRIVER_MINOR_VERSION();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.prismInterfaceClient.getSqlKeywords(this.getConnection().getNetworkTimeout());
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return this.prismInterfaceClient.getSqlNumericFunctions(this.getConnection().getNetworkTimeout());
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return this.prismInterfaceClient.getSqlStringFunctions(this.getConnection().getNetworkTimeout());
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return this.prismInterfaceClient.getSqlSystemFunctions(this.getConnection().getNetworkTimeout());
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return this.prismInterfaceClient.getSqlTimeDateFunctions(this.getConnection().getNetworkTimeout());
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "namespace";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return PropertyUtils.getDEFAULT_TRANSACTION_ISOLATION();
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return PropertyUtils.isValidIsolationLevel(level);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.throwNotSupportedIfStrict();
        List<Procedure> procedures = this.prismInterfaceClient.searchProcedures("sql", procedureNamePattern, this.getConnection().getNetworkTimeout());
        return MetaResultSetBuilder.buildFromProcedures(procedures);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        this.throwNotSupportedIfStrict();
        return MetaResultSetBuilder.buildFromProcedureColumns();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        List<Table> tables = this.getTableStream(schemaPattern, tableNamePattern).collect(Collectors.toList());
        if (types == null) {
            return MetaResultSetBuilder.buildFromTables(tables);
        }
        HashSet<String> tableTypes = new HashSet<String>(Arrays.asList(types));
        tables = tables.stream().filter(t -> tableTypes.contains(t.getTableType())).collect(Collectors.toList());
        return MetaResultSetBuilder.buildFromTables(tables);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String defaultNamespace = this.prismInterfaceClient.getDefaultNamespace(this.getConnection().getNetworkTimeout());
        return MetaResultSetBuilder.buildFromDatabases(defaultNamespace);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        List<TableType> tableTypes = this.prismInterfaceClient.getTablesTypes(this.getConnection().getNetworkTimeout());
        return MetaResultSetBuilder.buildFromTableTypes(tableTypes);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        List<Column> columns = this.prismInterfaceClient.searchNamespaces(schemaPattern, MetaUtils.NamespaceTypes.RELATIONAL.name(), this.getConnection().getNetworkTimeout()).stream().map(n -> {
            try {
                return this.getMatchingColumns((Namespace)n, tableNamePattern, columnNamePattern);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
        return MetaResultSetBuilder.buildFromColumns(columns);
    }

    private List<Column> getMatchingColumns(Namespace namespace, String tableNamePattern, String columnNamePattern) throws SQLException {
        Stream columnStream = this.prismInterfaceClient.searchEntities(namespace.getNamespaceName(), tableNamePattern, this.getConnection().getNetworkTimeout()).stream().filter(Entity::hasTable).map(Entity::getTable).map(Table::getColumnsList).flatMap(Collection::stream);
        if (columnNamePattern == null) {
            return columnStream.collect(Collectors.toList());
        }
        return columnStream.filter(c -> this.columnMatchesPattern(namespace, (Column)c, columnNamePattern)).collect(Collectors.toList());
    }

    private boolean columnMatchesPattern(Namespace namespace, Column column, String columnNamePattern) {
        if (namespace.getIsCaseSensitive()) {
            return column.getColumnName().matches(MetaUtils.convertToRegex(columnNamePattern));
        }
        return Pattern.compile(MetaUtils.convertToRegex(columnNamePattern), 2).matcher(column.getColumnName().toLowerCase()).find();
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.throwNotSupportedIfStrict();
        List<Column> columns = this.prismInterfaceClient.searchNamespaces(schemaPattern, MetaUtils.NamespaceTypes.RELATIONAL.name(), this.getConnection().getNetworkTimeout()).stream().map(n -> {
            try {
                return this.getMatchingColumns((Namespace)n, tableNamePattern, columnNamePattern);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
        return MetaResultSetBuilder.buildFromColumnPrivileges(columns, this.getUserName());
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.throwNotSupportedIfStrict();
        List<Table> tables = this.getTableStream(schemaPattern, tableNamePattern).collect(Collectors.toList());
        return MetaResultSetBuilder.buildFromTablePrivileges(tables, this.getUserName());
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        List<Column> columns = this.getTableStream(schema, table).filter(Table::hasPrimaryKey).map(Table::getPrimaryKey).map(PrimaryKey::getColumnsList).flatMap(Collection::stream).filter(c -> !c.getIsNullable() || nullable).collect(Collectors.toList());
        return MetaResultSetBuilder.fromBestRowIdentifiers(columns);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        List<Column> columns = this.getTableStream(schema, table).map(Table::getColumnsList).flatMap(Collection::stream).filter(c -> c.getColumnType() == Column.ColumnType.VERSION).collect(Collectors.toList());
        return MetaResultSetBuilder.buildFromVersionColumns(columns);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        List<PrimaryKey> primaryKeys = this.getTableStream(schema, table).filter(Table::hasPrimaryKey).map(Table::getPrimaryKey).collect(Collectors.toList());
        return MetaResultSetBuilder.buildFromPrimaryKeys(primaryKeys);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        List<ForeignKey> foreignKeys = this.getTableStream(schema, table).map(Table::getForeignKeysList).flatMap(Collection::stream).collect(Collectors.toList());
        return MetaResultSetBuilder.buildFromImportedKeys(foreignKeys);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        List<ForeignKey> exportedKeys = this.getTableStream(schema, table).map(Table::getExportedKeysList).flatMap(Collection::stream).collect(Collectors.toList());
        return MetaResultSetBuilder.buildFromExportedKeys(exportedKeys);
    }

    private Stream<Table> getTableStream(String namespace, String table) throws SQLException {
        return this.prismInterfaceClient.searchNamespaces(namespace, MetaUtils.NamespaceTypes.RELATIONAL.name(), this.getConnection().getNetworkTimeout()).stream().map(Namespace::getNamespaceName).map(name -> {
            try {
                return this.prismInterfaceClient.searchEntities((String)name, table, this.getConnection().getNetworkTimeout());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).filter(Entity::hasTable).map(Entity::getTable);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        HashMap parentTables = this.getTableStream(parentSchema, parentTable).collect(Collectors.toMap(Table::getTableName, t -> t, (prev, next) -> next, HashMap::new));
        List<ForeignKey> foreignKeys = this.getTableStream(foreignSchema, foreignTable).map(Table::getForeignKeysList).flatMap(Collection::stream).filter(f -> this.referencesTable((ForeignKey)f, (Table)parentTables.get(f.getReferencedTableName()))).collect(Collectors.toList());
        return MetaResultSetBuilder.buildFromCrossReference(foreignKeys);
    }

    private boolean referencesTable(ForeignKey foreignKey, Table table) {
        if (table == null) {
            return false;
        }
        if (!foreignKey.getReferencedTableName().equals(table.getTableName())) {
            return false;
        }
        return foreignKey.getReferencedNamespaceName().equals(table.getNamespaceName());
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        List<Type> types = this.prismInterfaceClient.getTypes(this.getConnection().getNetworkTimeout());
        return MetaResultSetBuilder.buildFromTypes(types);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        List<Index> indexes = this.getTableStream(schema, table).map(Table::getIndexesList).flatMap(Collection::stream).filter(i -> i.getUnique() || !unique).collect(Collectors.toList());
        return MetaResultSetBuilder.buildFromIndexes(indexes);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return PropertyUtils.isValidResultSetType(type);
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return PropertyUtils.isValidResultSetConcurrency(type, concurrency);
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        this.throwNotSupportedIfStrict();
        throw new SQLFeatureNotSupportedException("This feature is not yet supported.");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.polyConnection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        this.throwNotSupportedIfStrict();
        return MetaResultSetBuilder.buildFromSuperTypes();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.throwNotSupportedIfStrict();
        return MetaResultSetBuilder.buildFromSuperTables();
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        this.throwNotSupportedIfStrict();
        return MetaResultSetBuilder.buildFromAttributes();
    }

    @Override
    public boolean supportsResultSetHoldability(int resultSetHoldability) throws SQLException {
        return PropertyUtils.isValidResultSetHoldability(resultSetHoldability);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return PropertyUtils.getDEFAULT_RESULTSET_HOLDABILITY();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        if (this.databaseMajorVersion == -1) {
            this.fetchDbmsVersionInfo();
        }
        return this.databaseMinorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        if (this.databaseMajorVersion == -1) {
            this.fetchDbmsVersionInfo();
        }
        return this.databaseMinorVersion;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return DriverProperties.getDRIVER_MAJOR_VERSION();
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return DriverProperties.getDRIVER_MINOR_VERSION();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        List<Namespace> namespaces = this.prismInterfaceClient.searchNamespaces(schemaPattern, null, this.getConnection().getNetworkTimeout());
        return MetaResultSetBuilder.buildFromNamespaces(namespaces);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLFeatureNotSupportedException("This feature is not yet supported.");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        List<Function> functions = this.prismInterfaceClient.searchFunctions("sql", "SYSTEM", this.getConnection().getNetworkTimeout()).stream().filter(f -> f.getName().matches(MetaUtils.convertToRegex(functionNamePattern))).collect(Collectors.toList());
        return MetaResultSetBuilder.fromFunctions(functions);
    }

    @Override
    public ResultSet getFunctionColumns(String s, String s1, String s2, String s3) throws SQLException {
        this.throwNotSupportedIfStrict();
        return MetaResultSetBuilder.buildFromFunctionColumns();
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        List<Column> columns = this.prismInterfaceClient.searchNamespaces(schemaPattern, MetaUtils.NamespaceTypes.RELATIONAL.name(), this.getConnection().getNetworkTimeout()).stream().map(n -> {
            try {
                return this.getMatchingColumns((Namespace)n, tableNamePattern, columnNamePattern);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).filter(Column::getIsHidden).collect(Collectors.toList());
        return MetaResultSetBuilder.buildFromPseudoColumns(columns);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return aClass.cast(this);
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.WRAPPER_INCORRECT_TYPE, "Not a wrapper for " + aClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) {
        return aClass.isInstance(this);
    }

    private static enum NullSorting {
        START,
        END,
        HIGH,
        LOW;

    }
}

