/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.meta;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.List;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.prism.PreparedStatementSignature;
import org.polypheny.jdbc.meta.MetaUtils;
import org.polypheny.jdbc.meta.PolyphenyParameterMeta;

public class PolyphenyParameterMetaData
implements ParameterMetaData {
    private int parameterCount;
    private List<PolyphenyParameterMeta> parameterMetas;

    public PolyphenyParameterMetaData(PreparedStatementSignature statementSignature) {
        this.parameterCount = statementSignature.getParameterMetasCount();
        this.parameterMetas = MetaUtils.buildParameterMetas(statementSignature.getParameterMetasList());
    }

    private void throwIfOutOfBounds(int param) throws SQLException {
        if (--param < 0) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.PARAMETER_NOT_EXISTS, "Index out of Bounds.");
        }
        if (param >= this.parameterCount) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.PARAMETER_NOT_EXISTS, "Index out of Bounds.");
        }
    }

    private PolyphenyParameterMeta getMeta(int param) throws SQLException {
        this.throwIfOutOfBounds(param);
        return this.parameterMetas.get(param);
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.getMeta(param).getIsNullable();
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getMeta(param).isSigned();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getMeta(param).getPrecision();
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getMeta(param).getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getMeta(param).getParameterType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getMeta(param).getParameterTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getMeta(param).getParameterClassName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return this.getMeta(param).getParameterMode();
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return aClass.cast(this);
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.WRAPPER_INCORRECT_TYPE, "Not a wrapper for " + aClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) {
        return aClass.isInstance(this);
    }
}

