/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.meta;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.meta.PolyphenyColumnMeta;

public class PolyphenyResultSetMetadata
implements ResultSetMetaData {
    private final List<PolyphenyColumnMeta> columnMetas;
    private final Map<String, Integer> columnIndexes;

    public PolyphenyResultSetMetadata(List<PolyphenyColumnMeta> columnMetas) {
        this.columnMetas = columnMetas;
        this.columnIndexes = this.columnMetas.stream().collect(Collectors.toMap(c -> c.getColumnName().toLowerCase(), c -> c.getOrdinal() + 1, (m, n) -> n));
    }

    private PolyphenyColumnMeta getMeta(int columnIndex) throws SQLException {
        try {
            return this.columnMetas.get(columnIndex - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Column index out of bounds", (Throwable)e);
        }
    }

    public int getColumnIndexFromLabel(String columnLabel) throws SQLException {
        Integer columnIndex = this.columnIndexes.get(columnLabel.toLowerCase());
        if (columnIndex == null) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.COLUMN_NOT_EXISTS, "Invalid column label: " + columnLabel);
        }
        return columnIndex;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnMetas.size();
    }

    @Override
    public boolean isAutoIncrement(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).isCaseSensitive();
    }

    @Override
    public boolean isSearchable(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).isSearchable();
    }

    @Override
    public boolean isCurrency(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).isCurrency();
    }

    @Override
    public int isNullable(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).getNullable();
    }

    @Override
    public boolean isSigned(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).getDisplaySize();
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).getColumnLabel();
    }

    @Override
    public String getColumnName(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).getColumnName();
    }

    @Override
    public String getSchemaName(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).getNamespace();
    }

    @Override
    public int getPrecision(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).getPrecision();
    }

    @Override
    public int getScale(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).getScale();
    }

    @Override
    public String getTableName(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).getTableName();
    }

    @Override
    public String getCatalogName(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).getCatalogName();
    }

    @Override
    public int getColumnType(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).getSqlType();
    }

    @Override
    public String getColumnTypeName(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).getPolyphenyFieldTypeName();
    }

    @Override
    public boolean isReadOnly(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).isReadOnly();
    }

    @Override
    public boolean isWritable(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).isWritable();
    }

    @Override
    public boolean isDefinitelyWritable(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).isDefinitelyWritable();
    }

    @Override
    public String getColumnClassName(int columnIndex) throws SQLException {
        return this.getMeta(columnIndex).getColumnClassName();
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return aClass.cast(this);
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.WRAPPER_INCORRECT_TYPE, "Not a wrapper for " + aClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) {
        return aClass.isInstance(this);
    }
}

