/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.multimodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.polypheny.jdbc.PolyConnection;
import org.polypheny.jdbc.PrismInterfaceClient;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.prism.DocumentFrame;
import org.polypheny.jdbc.dependency.prism.Frame;
import org.polypheny.jdbc.dependency.prism.ProtoDocument;
import org.polypheny.jdbc.multimodel.PolyStatement;
import org.polypheny.jdbc.multimodel.Result;
import org.polypheny.jdbc.properties.PropertyUtils;
import org.polypheny.jdbc.types.PolyDocument;

public class DocumentResult
extends Result
implements Iterable<PolyDocument> {
    private final PolyStatement polyStatement;
    private final List<PolyDocument> documents;
    private boolean isFullyFetched;

    public DocumentResult(Frame frame, PolyStatement polyStatement) {
        super(Result.ResultType.DOCUMENT);
        this.polyStatement = polyStatement;
        this.isFullyFetched = frame.getIsLast();
        this.documents = new ArrayList<PolyDocument>();
        this.addDocuments(frame.getDocumentFrame());
    }

    private void addDocuments(DocumentFrame documentFrame) {
        documentFrame.getDocumentsList().forEach(d -> this.documents.add(new PolyDocument((ProtoDocument)d)));
    }

    private void fetchMore() throws PrismInterfaceServiceException {
        int id = this.polyStatement.getStatementId();
        int timeout = this.getPolyphenyConnection().getTimeout();
        Frame frame = this.getPrismInterfaceClient().fetchResult(id, timeout, PropertyUtils.getDEFAULT_FETCH_SIZE());
        if (frame.getResultCase() != Frame.ResultCase.DOCUMENT_FRAME) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.RESULT_TYPE_INVALID, "Statement returned a result of illegal type " + frame.getResultCase());
        }
        this.isFullyFetched = frame.getIsLast();
        this.addDocuments(frame.getDocumentFrame());
    }

    private PolyConnection getPolyphenyConnection() {
        return this.polyStatement.getConnection();
    }

    private PrismInterfaceClient getPrismInterfaceClient() {
        return this.getPolyphenyConnection().getPrismInterfaceClient();
    }

    @Override
    public Iterator<PolyDocument> iterator() {
        return new DocumentIterator();
    }

    class DocumentIterator
    implements Iterator<PolyDocument> {
        int index = -1;

        DocumentIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.index + 1 >= DocumentResult.this.documents.size()) {
                if (DocumentResult.this.isFullyFetched) {
                    return false;
                }
                try {
                    DocumentResult.this.fetchMore();
                }
                catch (PrismInterfaceServiceException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.index + 1 < DocumentResult.this.documents.size();
        }

        @Override
        public PolyDocument next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more documents");
            }
            return (PolyDocument)DocumentResult.this.documents.get(++this.index);
        }
    }
}

