/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.multimodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.polypheny.jdbc.dependency.prism.Row;
import org.polypheny.jdbc.types.TypedValue;

public class PolyRow {
    List<TypedValue> values;

    public PolyRow(List<TypedValue> value) {
        this.values = new ArrayList<TypedValue>(value);
    }

    public PolyRow(TypedValue ... value) {
        this(Arrays.asList(value));
    }

    public int getColumnCount() {
        return this.values.size();
    }

    public TypedValue getValue(int columnIndex) {
        return this.values.get(columnIndex);
    }

    public static <E extends TypedValue> PolyRow of(E ... values) {
        return new PolyRow((TypedValue[])values);
    }

    public static PolyRow fromProto(Row protoRow) {
        return new PolyRow(protoRow.getValuesList().stream().map(TypedValue::new).collect(Collectors.toList()));
    }
}

