/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.multimodel;

import lombok.Generated;
import org.polypheny.jdbc.PolyConnection;
import org.polypheny.jdbc.PrismInterfaceClient;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.prism.Frame;
import org.polypheny.jdbc.dependency.prism.Response;
import org.polypheny.jdbc.dependency.prism.StatementResponse;
import org.polypheny.jdbc.multimodel.DocumentResult;
import org.polypheny.jdbc.multimodel.RelationalResult;
import org.polypheny.jdbc.multimodel.Result;
import org.polypheny.jdbc.multimodel.ScalarResult;
import org.polypheny.jdbc.utils.CallbackQueue;

public class PolyStatement {
    private static final long SCALAR_NOT_SET = -1L;
    private static final int NO_STATEMENT_ID = -1;
    private PolyConnection connection;
    private int statementId;

    private void resetStatement() {
        this.statementId = -1;
    }

    private PrismInterfaceClient getPrismInterfaceClient() {
        return this.connection.getPrismInterfaceClient();
    }

    private Result getResultFromFrame(Frame frame) throws PrismInterfaceServiceException {
        switch (frame.getResultCase()) {
            case RELATIONAL_FRAME: {
                return new RelationalResult(frame, this);
            }
            case DOCUMENT_FRAME: {
                return new DocumentResult(frame, this);
            }
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.RESULT_TYPE_INVALID, "Statement produced unknown result type");
    }

    public PolyStatement(PolyConnection polyConnection) {
        this.connection = polyConnection;
    }

    public Result execute(String namespaceName, String languageName, String statement) throws PrismInterfaceServiceException {
        StatementResponse response;
        this.resetStatement();
        CallbackQueue<StatementResponse> callback = new CallbackQueue<StatementResponse>(Response::getStatementResponse);
        int timeout = this.connection.getTimeout();
        this.getPrismInterfaceClient().executeUnparameterizedStatement(namespaceName, languageName, statement, callback, timeout);
        do {
            response = callback.takeNext();
            if (this.statementId != -1) continue;
            this.statementId = response.getStatementId();
        } while (!response.hasResult());
        try {
            callback.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.DRIVER_THREADING_ERROR, "Awaiting completion of api call failed.", (Throwable)e);
        }
        if (!response.getResult().hasFrame()) {
            return new ScalarResult(response.getResult().getScalar());
        }
        return this.getResultFromFrame(response.getResult().getFrame());
    }

    @Generated
    public PolyConnection getConnection() {
        return this.connection;
    }

    @Generated
    public int getStatementId() {
        return this.statementId;
    }
}

