/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.multimodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.polypheny.jdbc.PolyConnection;
import org.polypheny.jdbc.PrismInterfaceClient;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.dependency.prism.Frame;
import org.polypheny.jdbc.dependency.prism.RelationalFrame;
import org.polypheny.jdbc.multimodel.PolyRow;
import org.polypheny.jdbc.multimodel.PolyStatement;
import org.polypheny.jdbc.multimodel.Result;
import org.polypheny.jdbc.properties.PropertyUtils;

public class RelationalResult
extends Result
implements Iterable<PolyRow> {
    private final PolyStatement polyStatement;
    private final List<PolyRow> rows;
    private boolean isFullyFetched;

    public RelationalResult(Frame frame, PolyStatement polyStatement) throws PrismInterfaceServiceException {
        super(Result.ResultType.RELATIONAL);
        this.polyStatement = polyStatement;
        this.isFullyFetched = frame.getIsLast();
        this.rows = new ArrayList<PolyRow>();
        this.addRows(frame.getRelationalFrame());
    }

    private void addRows(RelationalFrame relationalFrame) {
        relationalFrame.getRowsList().forEach(d -> this.rows.add(PolyRow.fromProto(d)));
    }

    private void fetchMore() throws PrismInterfaceServiceException {
        int id = this.polyStatement.getStatementId();
        int timeout = this.getPolyphenyConnection().getTimeout();
        Frame frame = this.getPrismInterfaceClient().fetchResult(id, timeout, PropertyUtils.getDEFAULT_FETCH_SIZE());
        if (frame.getResultCase() != Frame.ResultCase.DOCUMENT_FRAME) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.RESULT_TYPE_INVALID, "Statement returned a result of illegal type " + frame.getResultCase());
        }
        this.isFullyFetched = frame.getIsLast();
        this.addRows(frame.getRelationalFrame());
    }

    private PolyConnection getPolyphenyConnection() {
        return this.polyStatement.getConnection();
    }

    private PrismInterfaceClient getPrismInterfaceClient() {
        return this.getPolyphenyConnection().getPrismInterfaceClient();
    }

    @Override
    public Iterator<PolyRow> iterator() {
        return new RowIterator();
    }

    class RowIterator
    implements Iterator<PolyRow> {
        int index = -1;

        RowIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.index + 1 >= RelationalResult.this.rows.size()) {
                if (RelationalResult.this.isFullyFetched) {
                    return false;
                }
                try {
                    RelationalResult.this.fetchMore();
                }
                catch (PrismInterfaceServiceException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.index + 1 < RelationalResult.this.rows.size();
        }

        @Override
        public PolyRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more documents");
            }
            return (PolyRow)RelationalResult.this.rows.get(++this.index);
        }
    }
}

