/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.properties;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import lombok.Generated;
import org.polypheny.jdbc.ConnectionString;
import org.polypheny.jdbc.PrismInterfaceClient;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.properties.DriverProperties;
import org.polypheny.jdbc.properties.PolyphenyStatementProperties;
import org.polypheny.jdbc.properties.PropertyUtils;

public class PolyphenyConnectionProperties {
    private PrismInterfaceClient prismInterfaceClient;
    private String username;
    private String password;
    private boolean isAutoCommit;
    private boolean isReadOnly;
    private int resultSetHoldability;
    private int networkTimeout;
    private int transactionIsolation;
    private String catalogName;
    private String namespaceName;
    private Calendar calendar;
    private boolean isStrict;

    public PolyphenyConnectionProperties(ConnectionString connectionString, PrismInterfaceClient prismInterfaceClient) throws SQLException {
        this.prismInterfaceClient = prismInterfaceClient;
        this.isAutoCommit = PropertyUtils.isDEFAULT_AUTOCOMMIT();
        this.isReadOnly = PropertyUtils.isDEFAULT_READ_ONLY();
        this.resultSetHoldability = PropertyUtils.getDEFAULT_RESULTSET_HOLDABILITY();
        this.networkTimeout = PropertyUtils.getDEFAULT_NETWORK_TIMEOUT();
        this.transactionIsolation = PropertyUtils.getDEFAULT_TRANSACTION_ISOLATION();
        this.calendar = Calendar.getInstance(DriverProperties.getDEFAULT_TIMEZONE(), Locale.ROOT);
        this.catalogName = null;
        this.isStrict = true;
        Map<String, String> parameters = connectionString.getParameters();
        Optional.ofNullable(parameters.get(PropertyUtils.getUSERNAME_KEY())).ifPresent(p -> {
            this.username = p;
        });
        Optional.ofNullable(parameters.get(PropertyUtils.getPASSWORD_KEY())).ifPresent(p -> {
            this.password = p;
        });
        Optional.ofNullable(parameters.get(PropertyUtils.getAUTOCOMMIT_KEY())).ifPresent(p -> {
            this.isAutoCommit = Boolean.parseBoolean(p);
        });
        Optional.ofNullable(parameters.get(PropertyUtils.getREAD_ONLY_KEY())).ifPresent(p -> {
            this.isReadOnly = Boolean.parseBoolean(p);
        });
        Optional.ofNullable(parameters.get(PropertyUtils.getNETWORK_TIMEOUT_KEY())).ifPresent(p -> {
            this.networkTimeout = Integer.parseInt(p);
        });
        Optional.ofNullable(parameters.get(PropertyUtils.getNAMESPACE_KEY())).ifPresent(p -> {
            this.namespaceName = p;
        });
        Optional.ofNullable(parameters.get(PropertyUtils.getTIMEZONE_KEY())).ifPresent(p -> {
            this.calendar = Calendar.getInstance(TimeZone.getTimeZone(p), Locale.ROOT);
        });
        Optional.ofNullable(parameters.get(PropertyUtils.getSTRICT_MODE_KEY())).ifPresent(p -> {
            this.isStrict = Boolean.parseBoolean(p);
        });
        if (parameters.containsKey(PropertyUtils.getRESULT_SET_HOLDABILITY_KEY())) {
            int resultSetHoldability = this.parseResultSetHoldability(parameters.get(PropertyUtils.getRESULT_SET_HOLDABILITY_KEY()));
            if (!PropertyUtils.isValidResultSetHoldability(resultSetHoldability)) {
                throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Result set holdability not supported:" + resultSetHoldability);
            }
            this.resultSetHoldability = resultSetHoldability;
        }
        if (parameters.containsKey(PropertyUtils.getTRANSACTION_ISOLATION_KEY())) {
            int transactionIsolation = PolyphenyConnectionProperties.parseTransactionIsolation(parameters.get(PropertyUtils.getTRANSACTION_ISOLATION_KEY()));
            if (!PropertyUtils.isValidIsolationLevel(transactionIsolation)) {
                throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Transaction isolation level not supported: " + transactionIsolation);
            }
            this.transactionIsolation = transactionIsolation;
        }
    }

    private static int parseTransactionIsolation(String string) throws SQLException {
        switch (string) {
            case "COMMITTED": {
                return 2;
            }
            case "DIRTY": {
                return 1;
            }
            case "SERIALIZABLE": {
                return 8;
            }
            case "REPEATABLE_READ": {
                return 4;
            }
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Invalid value for transaction isolation: " + string);
    }

    private int parseResultSetHoldability(String string) throws SQLException {
        switch (string) {
            case "HOLD": {
                return 1;
            }
            case "CLOSE": {
                return 2;
            }
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Invalid value for result set holdability: " + string);
    }

    public void setAutoCommit(boolean isAutoCommit) throws PrismInterfaceServiceException {
        this.isAutoCommit = isAutoCommit;
        this.sync();
    }

    public void setReadOnly(boolean isReadOnly) throws PrismInterfaceServiceException {
        this.isReadOnly = isReadOnly;
        this.sync();
    }

    public void setResultSetHoldability(int resultSetHoldability) throws SQLException {
        if (!PropertyUtils.isValidResultSetHoldability(resultSetHoldability)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Invalid value for result set holdability");
        }
        this.resultSetHoldability = resultSetHoldability;
    }

    public void setNetworkTimeout(int networkTimeout) throws PrismInterfaceServiceException {
        this.networkTimeout = networkTimeout;
        this.sync();
    }

    public void setTransactionIsolation(int transactionIsolation) throws SQLException {
        if (!PropertyUtils.isValidIsolationLevel(transactionIsolation)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Invalid value for transaction isolation");
        }
        this.transactionIsolation = transactionIsolation;
        this.sync();
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setNamespaceName(String namespaceName) throws PrismInterfaceServiceException {
        this.namespaceName = namespaceName;
        this.sync();
    }

    private void sync() throws PrismInterfaceServiceException {
        this.prismInterfaceClient.setConnectionProperties(this, this.getNetworkTimeout());
    }

    public PolyphenyStatementProperties toStatementProperties() throws SQLException {
        return this.toStatementProperties(PropertyUtils.getDEFAULT_RESULTSET_TYPE(), PropertyUtils.getDEFAULT_RESULTSET_CONCURRENCY());
    }

    public PolyphenyStatementProperties toStatementProperties(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.toStatementProperties(resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    public PolyphenyStatementProperties toStatementProperties(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PolyphenyStatementProperties properties = new PolyphenyStatementProperties();
        properties.setCalendar(this.calendar);
        properties.setPrismInterfaceClient(this.prismInterfaceClient);
        properties.setQueryTimeoutSeconds(PropertyUtils.getDEFAULT_QUERY_TIMEOUT_SECONDS());
        properties.setResultSetType(resultSetType);
        properties.setResultSetConcurrency(resultSetConcurrency);
        properties.setResultSetHoldability(resultSetHoldability);
        properties.setFetchSize(PropertyUtils.getDEFAULT_FETCH_SIZE());
        properties.setFetchDirection(PropertyUtils.getDEFAULT_FETCH_DIRECTION());
        properties.setMaxFieldSize(PropertyUtils.getDEFAULT_MAX_FIELD_SIZE());
        properties.setLargeMaxRows(PropertyUtils.getDEFAULT_LARGE_MAX_ROWS());
        properties.setDoesEscapeProcessing(PropertyUtils.isDEFAULT_DOING_ESCAPE_PROCESSING());
        properties.setIsPoolable(PropertyUtils.isDEFAULT_STATEMENT_POOLABLE());
        properties.setCloseOnCompletion(false);
        return properties;
    }

    @Generated
    public PrismInterfaceClient getPrismInterfaceClient() {
        return this.prismInterfaceClient;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    @Generated
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Generated
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    @Generated
    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    @Generated
    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getNamespaceName() {
        return this.namespaceName;
    }

    @Generated
    public Calendar getCalendar() {
        return this.calendar;
    }

    @Generated
    public boolean isStrict() {
        return this.isStrict;
    }
}

