/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.properties;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import lombok.Generated;

public class PolyphenyResultSetProperties {
    private int resultSetType;
    private int resultSetConcurrency;
    private int resultSetHoldability;
    private int fetchDirection;
    private int statementFetchSize;
    private int resultSetFetchSize;
    private int maxFieldSize;
    private long largeMaxRows;
    private Calendar calendar;

    public boolean isReadOnly() {
        return this.resultSetConcurrency == 1007;
    }

    public static PolyphenyResultSetProperties forMetaResultSet() {
        PolyphenyResultSetProperties properties = new PolyphenyResultSetProperties();
        properties.setResultSetType(1004);
        properties.setResultSetConcurrency(1007);
        properties.setResultSetHoldability(2);
        properties.setFetchDirection(1000);
        properties.setStatementFetchSize(0);
        properties.setMaxFieldSize(0);
        properties.setLargeMaxRows(0L);
        properties.setCalendar(Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT));
        return properties;
    }

    public void setStatementFetchSize(int fetchSize) {
        this.statementFetchSize = fetchSize;
        this.resultSetFetchSize = fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.resultSetFetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.resultSetFetchSize;
    }

    @Generated
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Generated
    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    @Generated
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Generated
    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    @Generated
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    @Generated
    public void setResultSetHoldability(int resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    @Generated
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Generated
    public void setFetchDirection(int fetchDirection) {
        this.fetchDirection = fetchDirection;
    }

    @Generated
    public int getStatementFetchSize() {
        return this.statementFetchSize;
    }

    @Generated
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Generated
    public void setMaxFieldSize(int maxFieldSize) {
        this.maxFieldSize = maxFieldSize;
    }

    @Generated
    public long getLargeMaxRows() {
        return this.largeMaxRows;
    }

    @Generated
    public void setLargeMaxRows(long largeMaxRows) {
        this.largeMaxRows = largeMaxRows;
    }

    @Generated
    public Calendar getCalendar() {
        return this.calendar;
    }

    @Generated
    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }
}

