/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.properties;

import java.sql.SQLException;
import java.util.Calendar;
import lombok.Generated;
import org.polypheny.jdbc.PolyphenyStatement;
import org.polypheny.jdbc.PrismInterfaceClient;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;
import org.polypheny.jdbc.properties.PolyphenyResultSetProperties;
import org.polypheny.jdbc.properties.PropertyUtils;

public class PolyphenyStatementProperties {
    private static final int UNSET_INT = -1;
    PrismInterfaceClient prismInterfaceClient;
    PolyphenyStatement polyphenyStatement;
    private int queryTimeoutSeconds;
    private int resultSetType = -1;
    private int resultSetConcurrency = -1;
    private int resultSetHoldability = -1;
    private int fetchSize;
    private int fetchDirection;
    private int maxFieldSize;
    private long largeMaxRows;
    private boolean doesEscapeProcessing;
    private boolean isPoolable;
    private Calendar calendar;
    private boolean isCloseOnCompletion;

    public void setPolyphenyStatement(PolyphenyStatement polyphenyStatement) throws SQLException {
        if (this.polyphenyStatement != null) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Can't change polyphenyStatement" + polyphenyStatement);
        }
        this.polyphenyStatement = polyphenyStatement;
    }

    public void setQueryTimeoutSeconds(int queryTimeoutSeconds) throws SQLException {
        if (queryTimeoutSeconds < 0) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal value for max");
        }
        this.queryTimeoutSeconds = queryTimeoutSeconds;
    }

    public void setResultSetType(int resultSetType) throws SQLException {
        if (this.resultSetType != -1) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Can't change result set type");
        }
        if (!PropertyUtils.isValidResultSetType(resultSetType)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal value for result set type");
        }
        this.resultSetType = resultSetType;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) throws SQLException {
        if (this.resultSetConcurrency != -1) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPERATION_ILLEGAL, "Can't change result set type");
        }
        if (!PropertyUtils.isValidResultSetConcurrency(resultSetConcurrency)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal value for result set concurrency");
        }
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public void setResultSetHoldability(int resultSetHoldability) throws SQLException {
        if (this.resultSetHoldability != -1) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Can't change result set type");
        }
        if (!PropertyUtils.isValidResultSetHoldability(resultSetHoldability)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal value for result set concurrency");
        }
        this.resultSetHoldability = resultSetHoldability;
    }

    public void setFetchSize(int fetchSize) throws SQLException {
        if (fetchSize < 0) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal value for fetch size");
        }
        this.fetchSize = fetchSize;
    }

    public void setFetchDirection(int fetchDirection) throws SQLException {
        if (PropertyUtils.isInvalidFetchDirection(fetchDirection)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal value for fetch direction");
        }
        this.fetchDirection = fetchDirection;
    }

    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        if (maxFieldSize < 0) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.STREAM_ERROR, "Illegal argument for max field size");
        }
        this.maxFieldSize = maxFieldSize;
    }

    public void setLargeMaxRows(long largeMaxRows) throws SQLException {
        if (largeMaxRows < 0L) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal value for large max rows");
        }
        this.largeMaxRows = largeMaxRows;
    }

    public void setDoesEscapeProcessing(boolean doesEscapeProcessing) throws SQLException {
        this.doesEscapeProcessing = doesEscapeProcessing;
    }

    public void setIsPoolable(boolean isPoolable) throws SQLException {
        this.isPoolable = isPoolable;
    }

    public PolyphenyResultSetProperties toResultSetProperties() {
        PolyphenyResultSetProperties properties = new PolyphenyResultSetProperties();
        properties.setResultSetType(this.resultSetType);
        properties.setResultSetConcurrency(this.resultSetConcurrency);
        properties.setResultSetHoldability(this.resultSetHoldability);
        properties.setFetchDirection(this.fetchDirection);
        properties.setStatementFetchSize(this.fetchSize);
        properties.setMaxFieldSize(this.maxFieldSize);
        properties.setLargeMaxRows(this.largeMaxRows);
        properties.setCalendar(this.calendar);
        return properties;
    }

    @Generated
    public void setPrismInterfaceClient(PrismInterfaceClient prismInterfaceClient) {
        this.prismInterfaceClient = prismInterfaceClient;
    }

    @Generated
    public int getQueryTimeoutSeconds() {
        return this.queryTimeoutSeconds;
    }

    @Generated
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Generated
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Generated
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    @Generated
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Generated
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Generated
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Generated
    public long getLargeMaxRows() {
        return this.largeMaxRows;
    }

    @Generated
    public boolean isDoesEscapeProcessing() {
        return this.doesEscapeProcessing;
    }

    @Generated
    public boolean isPoolable() {
        return this.isPoolable;
    }

    @Generated
    public Calendar getCalendar() {
        return this.calendar;
    }

    @Generated
    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    @Generated
    public boolean isCloseOnCompletion() {
        return this.isCloseOnCompletion;
    }

    @Generated
    public void setCloseOnCompletion(boolean isCloseOnCompletion) {
        this.isCloseOnCompletion = isCloseOnCompletion;
    }
}

