/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.properties;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.polypheny.jdbc.PrismInterfaceErrors;
import org.polypheny.jdbc.PrismInterfaceServiceException;

public class PropertyUtils {
    private static final int DEFAULT_TRANSACTION_ISOLATION = 2;
    private static final int DEFAULT_NETWORK_TIMEOUT = 0;
    private static final int DEFAULT_QUERY_TIMEOUT_SECONDS = 0;
    private static final int DEFAULT_FETCH_SIZE = 100;
    private static final int DEFAULT_FETCH_DIRECTION = 1000;
    private static final int DEFAULT_RESULTSET_TYPE = 1003;
    private static final int DEFAULT_RESULTSET_CONCURRENCY = 1007;
    private static final int DEFAULT_MAX_FIELD_SIZE = 0;
    private static final long DEFAULT_LARGE_MAX_ROWS = 0L;
    private static final boolean DEFAULT_DOING_ESCAPE_PROCESSING = true;
    private static final boolean DEFAULT_STATEMENT_POOLABLE = false;
    private static final boolean DEFAULT_PREPARED_STATEMENT_POOLABLE = false;
    private static final boolean DEFAULT_CALLABLE_STATEMENT_POOLABLE = false;
    private static final boolean DEFAULT_AUTOCOMMIT = true;
    private static final boolean DEFAULT_READ_ONLY = false;
    private static final int DEFAULT_RESULTSET_HOLDABILITY = 2;
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 20590;
    private static final String SQL_LANGUAGE_NAME = "sql";
    private static final String USERNAME_KEY = "user";
    private static final String PASSWORD_KEY = "password";
    private static final String NAMESPACE_KEY = "namespace";
    private static final String AUTOCOMMIT_KEY = "autocommit";
    private static final String READ_ONLY_KEY = "readonly";
    private static final String RESULT_SET_HOLDABILITY_KEY = "holdability";
    private static final String NETWORK_TIMEOUT_KEY = "nwtimeout";
    private static final String TRANSACTION_ISOLATION_KEY = "isolation";
    private static final String TIMEZONE_KEY = "timezone";
    private static final String STRICT_MODE_KEY = "strict";
    private static Map<Integer, List<Integer>> SUPPORTED_CONCURRENCIES = new HashMap<Integer, List<Integer>>();
    private static final Set<Integer> RESULT_SET_TYPES;
    private static final Set<Integer> RESULT_SET_CONCURRENCIES;
    private static final Set<Integer> RESULT_SET_HOLDABILITIES;
    private static final Set<Integer> TRANSACTION_ISOLATION_LEVELS;
    private static final Set<Integer> AUTO_GENERATED_KEYS;
    private static final Set<Integer> FETCH_DIRECTIONS;

    public static String getHoldabilityName(int resultSetHoldability) throws PrismInterfaceServiceException {
        switch (resultSetHoldability) {
            case 2: {
                return "CLOSE";
            }
            case 1: {
                return "HOLD";
            }
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "The passed integer value does not match a result holdability.");
    }

    public static String getTransactionIsolationName(int transactionIsolation) throws PrismInterfaceServiceException {
        switch (transactionIsolation) {
            case 1: {
                return "DIRTY";
            }
            case 2: {
                return "COMMITTED";
            }
            case 8: {
                return "SERIALIZABLE";
            }
            case 4: {
                return "REPEATABLE_READ";
            }
        }
        throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "The passed integer value does not match a transaction isolation level.");
    }

    public static boolean isValidResultSetConcurrency(int resultSetType, int resultSetConcurrency) {
        List<Integer> supportedConcurrencies = SUPPORTED_CONCURRENCIES.get(resultSetType);
        if (supportedConcurrencies == null) {
            return false;
        }
        return supportedConcurrencies.contains(resultSetConcurrency);
    }

    public static boolean isValidResultSetType(int resultSetType) {
        return RESULT_SET_TYPES.contains(resultSetType);
    }

    public static boolean isValidResultSetConcurrency(int resultSetConcurrency) {
        return RESULT_SET_CONCURRENCIES.contains(resultSetConcurrency);
    }

    public static boolean isValidResultSetHoldability(int resultSetHoldability) {
        return RESULT_SET_HOLDABILITIES.contains(resultSetHoldability);
    }

    public static boolean isValidIsolationLevel(int transactionIsolationLevel) {
        return TRANSACTION_ISOLATION_LEVELS.contains(transactionIsolationLevel);
    }

    public static void throwIfInvalid(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PropertyUtils.throwIfInvalid(resultSetType, resultSetConcurrency);
        if (!PropertyUtils.isValidResultSetHoldability(resultSetHoldability)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal value for result set holdability.");
        }
    }

    public static void throwIfInvalid(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!PropertyUtils.isValidResultSetType(resultSetType)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal value for result set type.");
        }
        if (!PropertyUtils.isValidResultSetConcurrency(resultSetConcurrency)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.VALUE_ILLEGAL, "Illegal value for result set concurrency.");
        }
        if (!PropertyUtils.isValidResultSetConcurrency(resultSetType, resultSetConcurrency)) {
            throw new PrismInterfaceServiceException(PrismInterfaceErrors.OPTION_NOT_SUPPORTED, "The specified concurrency is not supported for the specified result set type");
        }
    }

    public static boolean isValidAutogeneratedKeys(int autogeneratedKeys) {
        return AUTO_GENERATED_KEYS.contains(autogeneratedKeys);
    }

    public static boolean isInvalidFetchDirection(int fetchDirection) {
        return !FETCH_DIRECTIONS.contains(fetchDirection);
    }

    @Generated
    public static int getDEFAULT_TRANSACTION_ISOLATION() {
        return 2;
    }

    @Generated
    public static int getDEFAULT_NETWORK_TIMEOUT() {
        return 0;
    }

    @Generated
    public static int getDEFAULT_QUERY_TIMEOUT_SECONDS() {
        return 0;
    }

    @Generated
    public static int getDEFAULT_FETCH_SIZE() {
        return 100;
    }

    @Generated
    public static int getDEFAULT_FETCH_DIRECTION() {
        return 1000;
    }

    @Generated
    public static int getDEFAULT_RESULTSET_TYPE() {
        return 1003;
    }

    @Generated
    public static int getDEFAULT_RESULTSET_CONCURRENCY() {
        return 1007;
    }

    @Generated
    public static int getDEFAULT_MAX_FIELD_SIZE() {
        return 0;
    }

    @Generated
    public static long getDEFAULT_LARGE_MAX_ROWS() {
        return 0L;
    }

    @Generated
    public static boolean isDEFAULT_DOING_ESCAPE_PROCESSING() {
        return true;
    }

    @Generated
    public static boolean isDEFAULT_STATEMENT_POOLABLE() {
        return false;
    }

    @Generated
    public static boolean isDEFAULT_PREPARED_STATEMENT_POOLABLE() {
        return false;
    }

    @Generated
    public static boolean isDEFAULT_CALLABLE_STATEMENT_POOLABLE() {
        return false;
    }

    @Generated
    public static boolean isDEFAULT_AUTOCOMMIT() {
        return true;
    }

    @Generated
    public static boolean isDEFAULT_READ_ONLY() {
        return false;
    }

    @Generated
    public static int getDEFAULT_RESULTSET_HOLDABILITY() {
        return 2;
    }

    @Generated
    public static String getDEFAULT_HOST() {
        return DEFAULT_HOST;
    }

    @Generated
    public static int getDEFAULT_PORT() {
        return 20590;
    }

    @Generated
    public static String getSQL_LANGUAGE_NAME() {
        return SQL_LANGUAGE_NAME;
    }

    @Generated
    public static String getUSERNAME_KEY() {
        return USERNAME_KEY;
    }

    @Generated
    public static String getPASSWORD_KEY() {
        return PASSWORD_KEY;
    }

    @Generated
    public static String getNAMESPACE_KEY() {
        return NAMESPACE_KEY;
    }

    @Generated
    public static String getAUTOCOMMIT_KEY() {
        return AUTOCOMMIT_KEY;
    }

    @Generated
    public static String getREAD_ONLY_KEY() {
        return READ_ONLY_KEY;
    }

    @Generated
    public static String getRESULT_SET_HOLDABILITY_KEY() {
        return RESULT_SET_HOLDABILITY_KEY;
    }

    @Generated
    public static String getNETWORK_TIMEOUT_KEY() {
        return NETWORK_TIMEOUT_KEY;
    }

    @Generated
    public static String getTRANSACTION_ISOLATION_KEY() {
        return TRANSACTION_ISOLATION_KEY;
    }

    @Generated
    public static String getTIMEZONE_KEY() {
        return TIMEZONE_KEY;
    }

    @Generated
    public static String getSTRICT_MODE_KEY() {
        return STRICT_MODE_KEY;
    }

    static {
        SUPPORTED_CONCURRENCIES.put(1003, Collections.singletonList(1007));
        SUPPORTED_CONCURRENCIES.put(1004, Collections.singletonList(1007));
        RESULT_SET_TYPES = new HashSet<Integer>();
        RESULT_SET_TYPES.add(1003);
        RESULT_SET_TYPES.add(1004);
        RESULT_SET_CONCURRENCIES = new HashSet<Integer>();
        RESULT_SET_CONCURRENCIES.add(1007);
        RESULT_SET_CONCURRENCIES.add(1008);
        RESULT_SET_HOLDABILITIES = new HashSet<Integer>();
        RESULT_SET_HOLDABILITIES.add(2);
        TRANSACTION_ISOLATION_LEVELS = new HashSet<Integer>();
        TRANSACTION_ISOLATION_LEVELS.add(2);
        AUTO_GENERATED_KEYS = new HashSet<Integer>();
        AUTO_GENERATED_KEYS.add(1);
        AUTO_GENERATED_KEYS.add(2);
        FETCH_DIRECTIONS = new HashSet<Integer>();
        FETCH_DIRECTIONS.add(1000);
    }
}

