/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.transport;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.polypheny.jdbc.transport.Transport;

public class PlainTransport
implements Transport {
    private static final String VERSION = "plain-v1@polypheny.com";
    protected final SocketChannel con;
    private final Lock writeLock = new ReentrantLock();

    public PlainTransport(String host, int port) throws IOException {
        this.con = SocketChannel.open(new InetSocketAddress(host, port));
        this.con.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        this.exchangeVersion();
    }

    private void exchangeVersion() throws IOException {
        ByteBuffer length = ByteBuffer.allocate(1);
        this.readEntireBuffer(length);
        byte len = length.get();
        if (len <= 0) {
            throw new IOException("Invalid version length");
        }
        ByteBuffer response = ByteBuffer.allocate(1 + len);
        response.put(len);
        this.readEntireBuffer(response);
        byte[] remoteVersion = new byte[len - 1];
        response.position(1);
        response.get(remoteVersion);
        if (!Arrays.equals(VERSION.getBytes(StandardCharsets.US_ASCII), remoteVersion)) {
            String s = StandardCharsets.US_ASCII.decode(ByteBuffer.wrap(remoteVersion)).toString();
            if (s.matches("\\A[a-z0-9@.-]+\\z")) {
                throw new IOException("Unsupported version: '" + s + "' expected '" + VERSION + "'");
            }
            throw new IOException("Unsupported version");
        }
        if (response.get() != 10) {
            throw new IOException("Invalid version message");
        }
        response.rewind();
        this.writeEntireBuffer(response);
    }

    protected void writeEntireBuffer(ByteBuffer bb) throws IOException {
        this.writeLock.lock();
        try {
            while (bb.remaining() > 0) {
                int i = this.con.write(bb);
                if (i != -1) continue;
                throw new EOFException();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void sendMessage(byte[] message) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(8 + message.length);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putLong(message.length);
        bb.put(message);
        bb.rewind();
        this.writeEntireBuffer(bb);
    }

    protected void readEntireBuffer(ByteBuffer bb) throws IOException {
        while (bb.remaining() > 0) {
            int i = this.con.read(bb);
            if (i != -1) continue;
            throw new EOFException();
        }
        bb.rewind();
    }

    @Override
    public byte[] receiveMessage() throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(8);
        this.readEntireBuffer(bb);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        long length = bb.getLong();
        if (length == 0L) {
            throw new IOException("Invalid message length");
        }
        bb = ByteBuffer.allocate((int)length);
        this.readEntireBuffer(bb);
        return bb.array();
    }

    @Override
    public void close() {
        try {
            this.con.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

