/*
 * Decompiled with CFR 0.152.
 */
package org.polypheny.jdbc.types;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.polypheny.jdbc.PolyphenyResultSet;
import org.polypheny.jdbc.dependency.prism.ProtoPolyType;
import org.polypheny.jdbc.meta.PolyphenyColumnMeta;
import org.polypheny.jdbc.types.ProtoToJdbcTypeMap;
import org.polypheny.jdbc.types.TypedValue;

public class PolyArray
implements Array {
    private final String protoBaseTypeName;
    private final Object[] elements;

    public PolyArray(String protoBaseTypeName, Object[] elements) {
        this.protoBaseTypeName = protoBaseTypeName;
        Object[] shiftedElements = new Object[elements.length];
        int endIdx = elements.length;
        System.arraycopy(elements, 0, shiftedElements, 0, endIdx);
        this.elements = shiftedElements;
    }

    public PolyArray(String protoBaseTypeName, List<TypedValue> values) throws SQLException {
        this.protoBaseTypeName = protoBaseTypeName;
        ArrayList<Object> objects = new ArrayList<Object>();
        for (TypedValue v : values) {
            objects.add(v.asObject());
        }
        this.elements = objects.toArray(new Object[0]);
    }

    private int longToInt(long value) {
        return Math.toIntExact(value);
    }

    @Override
    public String getBaseTypeName() {
        return this.protoBaseTypeName;
    }

    @Override
    public int getBaseType() {
        return ProtoToJdbcTypeMap.getJdbcTypeFromProto(ProtoPolyType.valueOf(this.protoBaseTypeName));
    }

    @Override
    public Object getArray() {
        return this.elements;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public Object getArray(long index, int count) {
        return Arrays.copyOfRange(this.elements, this.longToInt(index - 1L), count);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(0L, this.elements.length);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        int jdbcBaseType = this.getBaseType();
        ArrayList<PolyphenyColumnMeta> columnMetas = new ArrayList<PolyphenyColumnMeta>();
        columnMetas.add(PolyphenyColumnMeta.fromSpecification(0, "INDEX", "ARRAY", 4));
        columnMetas.add(PolyphenyColumnMeta.fromSpecification(1, "VALUE", "ARRAY", jdbcBaseType));
        ArrayList<List<TypedValue>> rows = new ArrayList<List<TypedValue>>();
        for (int i = 1; i < this.elements.length; ++i) {
            ArrayList<TypedValue> currentRow = new ArrayList<TypedValue>();
            currentRow.add(TypedValue.fromInteger(i));
            currentRow.add(TypedValue.fromObject(this.elements[i], jdbcBaseType));
            rows.add(currentRow);
        }
        return new PolyphenyResultSet(columnMetas, rows);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void free() {
    }
}

